/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.type.DateTimes;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimeZoneToTimeWithTimeZoneCast {
    private TimeWithTimeZoneToTimeWithTimeZoneCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static long shortToShort(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision) with time zone") long packedTime) {
        if (sourcePrecision <= targetPrecision) {
            return packedTime;
        }
        long nanos = DateTimeEncoding.unpackTimeNanos((long)packedTime);
        nanos = DateTimes.round(nanos, (int)(9L - targetPrecision));
        return DateTimeEncoding.packTimeWithTimeZone((long)(nanos % 86400000000000L), (int)DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static LongTimeWithTimeZone shortToLong(@SqlType(value="time(sourcePrecision) with time zone") long packedTime) {
        return new LongTimeWithTimeZone(DateTimeEncoding.unpackTimeNanos((long)packedTime) * 1000L, DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision) with time zone") LongTimeWithTimeZone timestamp) {
        long nanos = DateTimes.round(timestamp.getPicoseconds(), (int)(12L - targetPrecision)) / 1000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)(nanos % 86400000000000L), (int)timestamp.getOffsetMinutes());
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static LongTimeWithTimeZone longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision) with time zone") LongTimeWithTimeZone timestamp) {
        return new LongTimeWithTimeZone(DateTimes.round(timestamp.getPicoseconds(), (int)(12L - targetPrecision)) % 86400000000000000L, timestamp.getOffsetMinutes());
    }
}

