/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.util.concurrent.MoreExecutors;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.client.util.ScheduledExecutorProvider;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicVersion;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecker
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthChecker.class);
    public static final String HEALTH_CHECK_TOPIC_SUFFIX = "healthcheck";
    private static final Duration DEFAULT_HEALTH_CHECK_READ_TIMEOUT = Duration.ofSeconds(58L);
    private static final TimeoutException HEALTH_CHECK_TIMEOUT_EXCEPTION = FutureUtil.createTimeoutException((String)"Timeout", HealthChecker.class, (String)"healthCheckRecursiveReadNext(...)");
    private final PulsarService pulsar;
    private final String heartbeatTopicV1;
    private final String heartbeatTopicV2;
    private final PulsarClient client;
    private final ScheduledExecutorProvider lookupExecutor;
    private final ScheduledExecutorProvider scheduledExecutorProvider;
    private final Set<CompletableFuture<Void>> pendingFutures = new HashSet<CompletableFuture<Void>>();
    private final ScheduledExecutorService healthCheckExecutor;
    private final Duration timeout = DEFAULT_HEALTH_CHECK_READ_TIMEOUT;

    public HealthChecker(PulsarService pulsar) throws PulsarServerException {
        this.pulsar = pulsar;
        this.heartbeatTopicV1 = HealthChecker.getHeartbeatTopicName(pulsar.getBrokerId(), pulsar.getConfiguration(), false);
        this.heartbeatTopicV2 = HealthChecker.getHeartbeatTopicName(pulsar.getBrokerId(), pulsar.getConfiguration(), true);
        this.lookupExecutor = new ScheduledExecutorProvider(1, "health-checker-client-lookup-executor");
        this.scheduledExecutorProvider = new ScheduledExecutorProvider(1, "health-checker-client-scheduled-executor");
        this.healthCheckExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("health-checker-executor"));
        try {
            this.client = pulsar.createClientImpl(builder -> {
                builder.lookupExecutorProvider((ExecutorProvider)this.lookupExecutor);
                builder.scheduledExecutorProvider(this.scheduledExecutorProvider);
            });
        }
        catch (PulsarClientException e) {
            throw new PulsarServerException("Error creating client for HealthChecker", (Throwable)e);
        }
    }

    private static String getHeartbeatTopicName(String brokerId, ServiceConfiguration configuration, boolean isV2) {
        NamespaceName namespaceName = isV2 ? NamespaceService.getHeartbeatNamespaceV2(brokerId, configuration) : NamespaceService.getHeartbeatNamespace(brokerId, configuration);
        return String.format("persistent://%s/%s", namespaceName, HEALTH_CHECK_TOPIC_SUFFIX);
    }

    public CompletableFuture<Void> checkHealth(TopicVersion topicVersion, String clientAppId) {
        String topicName = topicVersion == TopicVersion.V2 ? this.heartbeatTopicV2 : this.heartbeatTopicV1;
        log.info("[{}] Running healthCheck with topic={}", (Object)clientAppId, (Object)topicName);
        String messageStr = UUID.randomUUID().toString();
        String subscriptionName = "healthCheck-" + messageStr;
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        this.healthCheckExecutor.execute(() -> this.doHealthCheck(clientAppId, resultFuture, topicName, subscriptionName, messageStr));
        return resultFuture;
    }

    private void doHealthCheck(String clientAppId, CompletableFuture<Void> resultFuture, String topicName, String subscriptionName, String messageStr) {
        this.addToPending(resultFuture);
        resultFuture.whenCompleteAsync((result, ex) -> this.removeFromPending(resultFuture), (Executor)this.healthCheckExecutor);
        try {
            ((CompletableFuture)this.pulsar.getBrokerService().getTopic(topicName, true).thenComposeAsync(topicOptional -> {
                if (!topicOptional.isPresent()) {
                    log.error("[{}] Fail to run health check while get topic {}. because get null value.", (Object)clientAppId, (Object)topicName);
                    return CompletableFuture.failedFuture(new BrokerServiceException.TopicNotFoundException(String.format("Topic [%s] not found after create.", topicName)));
                }
                return this.doHealthCheck(clientAppId, topicName, subscriptionName, messageStr, resultFuture);
            }, (Executor)this.healthCheckExecutor)).whenComplete((result, t) -> {
                if (t != null) {
                    resultFuture.completeExceptionally((Throwable)t);
                } else if (!resultFuture.isDone()) {
                    resultFuture.complete(null);
                }
            });
        }
        catch (Exception e) {
            log.error("[{}] Fail to run health check while get topic {}. because get exception.", new Object[]{clientAppId, topicName, e});
            resultFuture.completeExceptionally(e);
        }
    }

    private synchronized void addToPending(CompletableFuture<Void> resultFuture) {
        this.pendingFutures.add(resultFuture);
    }

    private synchronized void removeFromPending(CompletableFuture<Void> resultFuture) {
        this.pendingFutures.remove(resultFuture);
    }

    private CompletableFuture<Void> doHealthCheck(String clientAppId, String topicName, String subscriptionName, String messageStr, CompletableFuture<Void> resultFuture) {
        return ((CompletableFuture)this.client.newProducer(Schema.STRING).topic(topicName).sendTimeout((int)this.timeout.toMillis(), TimeUnit.MILLISECONDS).enableBatching(false).createAsync().thenCompose(producer -> ((CompletableFuture)this.client.newReader(Schema.STRING).topic(topicName).subscriptionName(subscriptionName).startMessageId(MessageId.latest).createAsync().exceptionally(createException -> {
            producer.closeAsync().exceptionally(ex -> {
                log.error("[{}] Close producer fail while heath check.", (Object)clientAppId);
                return null;
            });
            throw FutureUtil.wrapToCompletionException((Throwable)createException);
        })).thenCompose(reader -> ((CompletableFuture)producer.sendAsync((Object)messageStr).thenCompose(__ -> FutureUtil.addTimeoutHandling(HealthChecker.healthCheckRecursiveReadNext((Reader<String>)reader, messageStr), (Duration)this.timeout, (ScheduledExecutorService)this.healthCheckExecutor, () -> HEALTH_CHECK_TIMEOUT_EXCEPTION))).whenCompleteAsync((__, ex) -> this.closeAndReCheck((Producer<String>)producer, (Reader<String>)reader, topicName, subscriptionName, clientAppId).whenComplete((unused, innerEx) -> {
            if (ex != null) {
                resultFuture.completeExceptionally((Throwable)ex);
            } else {
                resultFuture.complete(null);
            }
        }), (Executor)this.healthCheckExecutor)))).exceptionally(ex -> {
            resultFuture.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private CompletableFuture<Void> closeAndReCheck(Producer<String> producer, Reader<String> reader, String topicName, String subscriptionName, String clientAppId) {
        CompletableFuture producerCloseFuture = producer.closeAsync();
        CompletableFuture readerCloseFuture = reader.closeAsync();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(2);
        futures.add(producerCloseFuture);
        futures.add(readerCloseFuture);
        return FutureUtil.waitForAll(futures).exceptionallyAsync(closeException -> {
            if (readerCloseFuture.isCompletedExceptionally()) {
                Subscription subscription;
                log.error("[{}] Close reader fail while health check.", (Object)clientAppId);
                Optional<Topic> topic = this.pulsar.getBrokerService().getTopicReference(topicName);
                if (topic.isPresent() && (subscription = topic.get().getSubscription(subscriptionName)) != null) {
                    log.warn("[{}] Force delete subscription {} when it still exists after the reader is closed.", (Object)clientAppId, (Object)subscription);
                    subscription.deleteForcefully().exceptionally(ex -> {
                        log.error("[{}] Force delete subscription fail while health check", (Object)clientAppId, ex);
                        return null;
                    });
                }
            } else {
                log.error("[{}] Close producer fail while heath check.", (Object)clientAppId);
            }
            return null;
        }, (Executor)this.healthCheckExecutor);
    }

    private static CompletableFuture<Void> healthCheckRecursiveReadNext(Reader<String> reader, String content) {
        return reader.readNextAsync().thenCompose(msg -> {
            if (!Objects.equals(content, msg.getValue())) {
                return HealthChecker.healthCheckRecursiveReadNext(reader, content);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private void deleteHeartbeatTopics() {
        log.info("forcefully deleting heartbeat topics");
        this.deleteTopic(this.heartbeatTopicV1);
        this.deleteTopic(this.heartbeatTopicV2);
        log.info("finish forcefully deleting heartbeat topics");
    }

    private void deleteTopic(String topicName) {
        block2: {
            try {
                this.pulsar.getBrokerService().deleteTopic(topicName, true).get(this.pulsar.getConfiguration().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Throwable realCause = e.getCause();
                if (realCause instanceof ManagedLedgerException.MetadataNotFoundException || realCause instanceof MetadataStoreException.NotFoundException) break block2;
                log.error("Errors in deleting heartbeat topic [{}]", (Object)topicName, (Object)e);
            }
        }
    }

    @Override
    public synchronized void close() throws Exception {
        try {
            this.scheduledExecutorProvider.shutdownNow();
        }
        catch (Exception e) {
            log.warn("Failed to shutdown scheduled executor", (Throwable)e);
        }
        try {
            this.lookupExecutor.shutdownNow();
        }
        catch (Exception e) {
            log.warn("Failed to shutdown lookup executor", (Throwable)e);
        }
        try {
            this.client.close();
        }
        catch (PulsarClientException e) {
            log.warn("Failed to close pulsar client", (Throwable)e);
        }
        for (CompletableFuture<Void> pendingFuture : new ArrayList<CompletableFuture<Void>>(this.pendingFutures)) {
            if (pendingFuture.isDone()) continue;
            this.healthCheckExecutor.submit(() -> {
                try {
                    pendingFuture.completeExceptionally((Throwable)new PulsarClientException.AlreadyClosedException("HealthChecker is closed"));
                }
                catch (Exception e) {
                    log.warn("Failed to complete pending future", (Throwable)e);
                }
            });
        }
        boolean terminated = MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.healthCheckExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        if (!terminated) {
            log.warn("Failed to shutdown health check executor in 10 seconds");
        }
        this.deleteHeartbeatTopics();
    }
}

