/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.bookkeeper.proto.ReadLastConfirmedAndEntryContext;
import org.apache.bookkeeper.util.ByteBufList;

class BatchedReadCompletion
extends CompletionValue {
    final BookkeeperInternalCallbacks.BatchedReadEntryCallback cb;

    public BatchedReadCompletion(CompletionKey key, BookkeeperInternalCallbacks.BatchedReadEntryCallback originalCallback, Object originalCtx, long ledgerId, long entryId, PerChannelBookieClient perChannelBookieClient) {
        super("BatchedRead", originalCtx, ledgerId, entryId, perChannelBookieClient);
        this.opLogger = perChannelBookieClient.readEntryOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.readTimeoutOpLogger;
        this.cb = (rc, ledgerId1, startEntryId, bufList, ctx) -> {
            this.logOpResult(rc);
            originalCallback.readEntriesComplete(rc, ledgerId1, entryId, bufList, originalCtx);
            key.release();
        };
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.errorOutAndRunCallback(() -> this.cb.readEntriesComplete(rc, this.ledgerId, this.entryId, null, this.ctx));
    }

    @Override
    public void handleV2Response(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, BookieProtocol.Response response) {
        this.perChannelBookieClient.readEntryOutstanding.dec();
        if (!(response instanceof BookieProtocol.BatchedReadResponse)) {
            return;
        }
        BookieProtocol.BatchedReadResponse readResponse = (BookieProtocol.BatchedReadResponse)response;
        this.handleBatchedReadResponse(ledgerId, entryId, status, readResponse.getData(), -1L, -1L);
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
    }

    private void handleBatchedReadResponse(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, ByteBufList buffers, long maxLAC, long lacUpdateTimestamp) {
        int rc = this.convertStatus(status, -1);
        if (maxLAC > -1L && this.ctx instanceof BookkeeperInternalCallbacks.ReadEntryCallbackCtx) {
            ((BookkeeperInternalCallbacks.ReadEntryCallbackCtx)this.ctx).setLastAddConfirmed(maxLAC);
        }
        if (lacUpdateTimestamp > -1L && this.ctx instanceof ReadLastConfirmedAndEntryContext) {
            ((ReadLastConfirmedAndEntryContext)this.ctx).setLacUpdateTimestamp(lacUpdateTimestamp);
        }
        this.cb.readEntriesComplete(rc, ledgerId, entryId, buffers, this.ctx);
    }
}

