/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedList;

public class JavaInstanceMain {
    private static final String FUNCTIONS_INSTANCE_CLASSPATH = "pulsar.functions.instance.classpath";
    private static final Method log4j2ShutdownMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ClassLoader root = Thread.currentThread().getContextClassLoader();
        String functionInstanceClasspath = System.getProperty(FUNCTIONS_INSTANCE_CLASSPATH);
        if (functionInstanceClasspath == null) {
            throw new IllegalArgumentException("Property pulsar.functions.instance.classpath is not set!");
        }
        LinkedList<File> files = new LinkedList<File>();
        for (String entry : functionInstanceClasspath.split(":")) {
            if (JavaInstanceMain.isBlank(entry)) continue;
            File f = new File(entry.replace("*", ""));
            if (f.exists()) {
                if (f.isDirectory()) {
                    files.addAll(Arrays.asList(f.listFiles()));
                    continue;
                }
                files.add(new File(entry));
                continue;
            }
            System.out.println(String.format("[WARN] %s on functions instance classpath does not exist", f.getAbsolutePath()));
        }
        ClassLoader functionInstanceClsLoader = JavaInstanceMain.loadJar(root, files.toArray(new File[files.size()]));
        System.out.println("Using function root classloader: " + String.valueOf(root));
        System.out.println("Using function instance classloader: " + String.valueOf(functionInstanceClsLoader));
        try {
            Object main = JavaInstanceMain.createInstance("org.apache.pulsar.functions.runtime.JavaInstanceStarter", functionInstanceClsLoader);
            Method method = main.getClass().getDeclaredMethod("start", String[].class, ClassLoader.class, ClassLoader.class);
            System.out.println("Starting function instance...");
            method.invoke(main, args, functionInstanceClsLoader, root);
        }
        catch (Throwable e) {
            try {
                JavaInstanceMain.shutdownLogging();
            }
            finally {
                System.out.println("Failed to start function instance.");
                e.printStackTrace();
                Runtime.getRuntime().halt(1);
            }
        }
    }

    public static Object createInstance(String userClassName, ClassLoader classLoader) {
        Object result;
        Class<?> theCls;
        try {
            theCls = Class.forName(userClassName, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            throw new RuntimeException("Class " + userClassName + " must be in class path", cnfe);
        }
        try {
            Constructor<?> meth = theCls.getDeclaredConstructor(new Class[0]);
            meth.setAccessible(true);
            result = meth.newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("User class must be concrete", ie);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class " + userClassName + " doesn't have such method", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Class " + userClassName + " must have a no-arg constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Class " + userClassName + " constructor throws exception", e);
        }
        return result;
    }

    public static ClassLoader loadJar(ClassLoader parent, File[] jars) throws MalformedURLException {
        URL[] urls = new URL[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            urls[i] = jars[i].toURI().toURL();
        }
        return new URLClassLoader(urls, parent);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static void shutdownLogging() {
        if (log4j2ShutdownMethod != null) {
            try {
                log4j2ShutdownMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    static {
        Method shutdownMethod = null;
        try {
            shutdownMethod = Class.forName("org.apache.logging.log4j.LogManager").getMethod("shutdown", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        log4j2ShutdownMethod = shutdownMethod;
    }
}

