/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.vlsn;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.VLSNRecoveryProxy;
import com.sleepycat.je.rep.vlsn.VLSNTracker;
import com.sleepycat.je.txn.RollbackStart;
import com.sleepycat.je.utilint.VLSN;

public final class VLSNRecoveryTracker
extends VLSNTracker
implements VLSNRecoveryProxy {
    private byte rollbackType;
    private VLSN lastMatchpointVLSN = VLSN.NULL_VLSN;
    private long lastMatchpointLsn = -1L;

    public VLSNRecoveryTracker(EnvironmentImpl envImpl, int stride, int maxMappings, int maxDistance) {
        super(envImpl, stride, maxMappings, maxDistance);
        this.rollbackType = LogEntryType.LOG_ROLLBACK_START.getTypeNum();
    }

    @Override
    public void trackMapping(long lsn, LogEntryHeader currentEntryHeader, LogEntry targetLogEntry) {
        if (currentEntryHeader.getReplicated() && !currentEntryHeader.isInvisible()) {
            VLSN vlsn = currentEntryHeader.getVLSN();
            this.track(vlsn, lsn, currentEntryHeader.getType());
        } else if (currentEntryHeader.getType() == this.rollbackType) {
            RollbackStart rb = (RollbackStart)((SingleItemEntry)targetLogEntry).getMainItem();
            this.lastMatchpointVLSN = rb.getMatchpointVLSN();
            this.lastMatchpointLsn = rb.getMatchpoint();
            if (this.range.getFirst().isNull()) {
                return;
            }
            if (this.range.getFirst().compareTo(this.lastMatchpointVLSN) > 0) {
                this.initEmpty();
                return;
            }
            if (this.range.getLast().compareTo(this.lastMatchpointVLSN) <= 0) {
                return;
            }
            this.truncateFromTail(this.lastMatchpointVLSN.getNext(), this.lastMatchpointLsn);
        }
    }

    public boolean isEmpty() {
        return this.bucketCache.size() == 0;
    }

    public VLSN getLastMatchpointVLSN() {
        return this.lastMatchpointVLSN;
    }

    public long getLastMatchpointLsn() {
        return this.lastMatchpointLsn;
    }
}

