/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.deser;

import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.io.NumberInput;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.deser.std.StdScalarDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.util.ClassUtil;

abstract class JSR310DeserializerBase<T>
extends StdScalarDeserializer<T> {
    protected final boolean _isLenient;

    protected JSR310DeserializerBase(Class<T> supportedType) {
        super(supportedType);
        this._isLenient = true;
    }

    protected JSR310DeserializerBase(Class<T> supportedType, Boolean leniency) {
        super(supportedType);
        this._isLenient = !Boolean.FALSE.equals(leniency);
    }

    protected JSR310DeserializerBase(JSR310DeserializerBase<T> base) {
        super((StdScalarDeserializer<?>)base);
        this._isLenient = base._isLenient;
    }

    protected JSR310DeserializerBase(JSR310DeserializerBase<T> base, Boolean leniency) {
        super((StdScalarDeserializer<?>)base);
        this._isLenient = !Boolean.FALSE.equals(leniency);
    }

    protected abstract JSR310DeserializerBase<T> withLeniency(Boolean var1);

    protected boolean isLenient() {
        return this._isLenient;
    }

    protected T _fromEmptyString(JsonParser p, DeserializationContext ctxt, String str) throws JacksonException {
        CoercionAction act = this._checkFromStringCoercion(ctxt, str);
        switch (act) {
            case AsEmpty: {
                return (T)this.getEmptyValue(ctxt);
            }
        }
        if (!this._isLenient) {
            return this._failForNotLenient(p, ctxt, JsonToken.VALUE_STRING);
        }
        return null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.DateTime;
    }

    @Override
    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws JacksonException {
        return typeDeserializer.deserializeTypedFromAny(parser, context);
    }

    protected boolean _isValidTimestampString(String str) {
        return this._isIntNumber(str) && NumberInput.inLongRange((String)str, (str.charAt(0) == '-' ? 1 : 0) != 0);
    }

    protected <BOGUS> BOGUS _reportWrongToken(DeserializationContext context, JsonToken exp, String unit) throws JacksonException {
        context.reportWrongTokenException(this, exp, "Expected %s for '%s' of %s value", exp.name(), unit, ClassUtil.getClassDescription(this.handledType()));
        return null;
    }

    protected <BOGUS> BOGUS _reportWrongToken(JsonParser parser, DeserializationContext context, JsonToken ... expTypes) throws JacksonException {
        return (BOGUS)context.reportInputMismatch(this.handledType(), "Unexpected token (%s), expected one of %s for %s value", parser.currentToken(), Arrays.asList(expTypes).toString(), ClassUtil.getClassDescription(this.handledType()));
    }

    protected <R> R _handleDateTimeException(DeserializationContext context, DateTimeException e0, String value) throws JacksonException {
        try {
            return (R)context.handleWeirdStringValue(this.handledType(), value, "Failed to deserialize %s: (%s) %s", ClassUtil.getClassDescription(this.handledType()), e0.getClass().getName(), e0.getMessage());
        }
        catch (JacksonException e) {
            e.initCause((Throwable)e0);
            throw e;
        }
    }

    protected <R> R _handleDateTimeFormatException(DeserializationContext context, DateTimeException e0, DateTimeFormatter format, String value) throws JacksonException {
        String formatterDesc = format == null ? "[default format]" : format.toString();
        try {
            return (R)context.handleWeirdStringValue(this.handledType(), value, "Failed to deserialize %s (with format '%s'): (%s) %s", ClassUtil.getClassDescription(this.handledType()), formatterDesc, e0.getClass().getName(), e0.getMessage());
        }
        catch (JacksonException e) {
            e.initCause((Throwable)e0);
            throw e;
        }
    }

    protected <R> R _handleUnexpectedToken(DeserializationContext ctxt, JsonParser parser, String message, Object ... args) {
        return (R)ctxt.handleUnexpectedToken(this.getValueType(ctxt), parser.currentToken(), parser, message, args);
    }

    protected <R> R _handleUnexpectedToken(DeserializationContext context, JsonParser parser, JsonToken ... expTypes) {
        return this._handleUnexpectedToken(context, parser, "Unexpected token (%s), expected one of %s for %s value", parser.currentToken(), Arrays.asList(expTypes), ClassUtil.getClassDescription(this.handledType()));
    }

    protected T _failForNotLenient(JsonParser p, DeserializationContext ctxt, JsonToken expToken) throws JacksonException {
        return (T)ctxt.handleUnexpectedToken(this.getValueType(ctxt), expToken, p, "Cannot deserialize instance of %s out of %s token: not allowed because 'strict' mode set for property or type (enable 'lenient' handling to allow)", ClassUtil.nameOf(this.handledType()), p.currentToken());
    }

    protected DateTimeException _peelDTE(DateTimeException e) {
        Throwable t;
        while ((t = e.getCause()) != null && t instanceof DateTimeException) {
            e = (DateTimeException)t;
        }
        return e;
    }
}

