/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.function.Supplier;
import tools.jackson.databind.util.ClassUtil;

public abstract class UnreflectHandleSupplier
implements Supplier<MethodHandle> {
    private final MethodType asType;
    private boolean initialized;
    private Supplier<MethodHandle> delegate = this::initialize;

    public UnreflectHandleSupplier(MethodType asType) {
        this.asType = asType;
    }

    @Override
    public MethodHandle get() {
        return this.delegate.get();
    }

    synchronized MethodHandle initialize() {
        if (!this.initialized) {
            MethodHandle mh;
            try {
                mh = this.postprocess(this.unreflect());
            }
            catch (IllegalAccessException e) {
                throw ClassUtil.sneakyThrow(e);
            }
            this.delegate = () -> mh;
            this.initialized = true;
        }
        return this.delegate.get();
    }

    protected MethodHandle postprocess(MethodHandle mh) {
        if (mh == null) {
            return mh;
        }
        if (this.asType == null) {
            return mh.asFixedArity();
        }
        return mh.asType(this.asType);
    }

    protected abstract MethodHandle unreflect() throws IllegalAccessException;

    public String toString() {
        return this.get().toString();
    }
}

