/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.slf4j.Marker;

public class Logback1027WorkaroundTurboFilter
extends TurboFilter {
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (t != null && this.hasRecursiveThrowableReference(t, null)) {
            int locationAwareLoggerInteger = Level.toLocationAwareLoggerInteger((Level)level);
            logger.log(marker, logger.getName(), locationAwareLoggerInteger, format, params, (Throwable)new StringifiedException(t));
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    private boolean hasRecursiveThrowableReference(Throwable t, Set<Throwable> seen) {
        if (t == null) {
            return false;
        }
        if (seen == null) {
            seen = Collections.newSetFromMap(new IdentityHashMap());
        }
        if (!seen.add(t)) {
            return true;
        }
        Throwable[] allSuppressed = t.getSuppressed();
        int allSuppressedLength = allSuppressed.length;
        if (allSuppressedLength > 0) {
            Set<Throwable> seenCopy = Collections.newSetFromMap(new IdentityHashMap(seen.size()));
            seenCopy.addAll(seen);
            for (int i = 0; i < allSuppressedLength; ++i) {
                if (!this.hasRecursiveThrowableReference(allSuppressed[i], seenCopy)) continue;
                return true;
            }
        }
        return this.hasRecursiveThrowableReference(t.getCause(), seen);
    }

    static class StringifiedException
    extends RuntimeException {
        public StringifiedException(Throwable t) {
            super(StringifiedException.stringifyStacktrace(t));
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private static String stringifyStacktrace(Throwable e) {
            try (StringWriter sw = new StringWriter();){
                PrintWriter pw = new PrintWriter(sw);
                try {
                    e.printStackTrace(pw);
                    pw.println("End of stringified Stacktrace");
                    String string = sw.toString();
                    pw.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                throw new RuntimeException("Unexpected exception stringifying stacktrace", e1);
            }
        }
    }
}

