/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.dag;

import com.microsoft.azure.management.resources.fluentcore.dag.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class DAGNode<DataT, NodeT extends DAGNode<DataT, NodeT>>
extends Node<DataT, NodeT> {
    private List<String> dependentKeys = new ArrayList<String>();
    private int toBeResolved;
    private boolean isPreparer;
    private ReentrantLock lock = new ReentrantLock();

    public DAGNode(String key, DataT data) {
        super(key, data);
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    List<String> dependentKeys() {
        return Collections.unmodifiableList(this.dependentKeys);
    }

    public void addDependent(String key) {
        this.dependentKeys.add(key);
    }

    public List<String> dependencyKeys() {
        return this.children();
    }

    public void addDependency(String dependencyKey) {
        super.addChild(dependencyKey);
    }

    public void removeDependency(String dependencyKey) {
        super.removeChild(dependencyKey);
    }

    public boolean hasDependencies() {
        return this.hasChildren();
    }

    public void setPreparer(boolean isPreparer) {
        this.isPreparer = isPreparer;
    }

    public boolean isPreparer() {
        return this.isPreparer;
    }

    public void initialize() {
        this.toBeResolved = this.dependencyKeys().size();
        this.dependentKeys.clear();
    }

    boolean hasAllResolved() {
        return this.toBeResolved == 0;
    }

    protected void onSuccessfulResolution(String dependencyKey) {
        if (this.toBeResolved == 0) {
            throw new RuntimeException("invalid state - " + this.key() + ": The dependency '" + dependencyKey + "' is already reported or there is no such dependencyKey");
        }
        --this.toBeResolved;
    }

    protected void onFaultedResolution(String dependencyKey, Throwable throwable) {
        if (this.toBeResolved == 0) {
            throw new RuntimeException("invalid state - " + this.key() + ": The dependency '" + dependencyKey + "' is already reported or there is no such dependencyKey");
        }
        --this.toBeResolved;
    }
}

