/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.ErrorResponseException;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.PolicyClientImpl;
import com.microsoft.azure.management.resources.implementation.PolicySetDefinitionInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PolicySetDefinitionsInner {
    private PolicySetDefinitionsService service;
    private PolicyClientImpl client;

    public PolicySetDefinitionsInner(Retrofit retrofit, PolicyClientImpl client) {
        this.service = (PolicySetDefinitionsService)retrofit.create(PolicySetDefinitionsService.class);
        this.client = client;
    }

    public PolicySetDefinitionInner createOrUpdate(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return (PolicySetDefinitionInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(policySetDefinitionName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<PolicySetDefinitionInner> createOrUpdateAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters, ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(policySetDefinitionName, parameters), serviceCallback);
    }

    public Observable<PolicySetDefinitionInner> createOrUpdateAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(policySetDefinitionName, parameters).map((Func1)new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>(){

            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return (PolicySetDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicySetDefinitionInner>> createOrUpdateWithServiceResponseAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-06-01-preview";
        return this.service.createOrUpdate(policySetDefinitionName, this.client.subscriptionId(), parameters, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicySetDefinitionsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicySetDefinitionInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicySetDefinitionInner>(){}.getType()).register(201, new TypeToken<PolicySetDefinitionInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String policySetDefinitionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(policySetDefinitionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String policySetDefinitionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(policySetDefinitionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String policySetDefinitionName) {
        return this.deleteWithServiceResponseAsync(policySetDefinitionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String policySetDefinitionName) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.delete(policySetDefinitionName, this.client.subscriptionId(), "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicySetDefinitionsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicySetDefinitionInner get(String policySetDefinitionName) {
        return (PolicySetDefinitionInner)((ServiceResponse)this.getWithServiceResponseAsync(policySetDefinitionName).toBlocking().single()).body();
    }

    public ServiceFuture<PolicySetDefinitionInner> getAsync(String policySetDefinitionName, ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(policySetDefinitionName), serviceCallback);
    }

    public Observable<PolicySetDefinitionInner> getAsync(String policySetDefinitionName) {
        return this.getWithServiceResponseAsync(policySetDefinitionName).map((Func1)new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>(){

            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return (PolicySetDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicySetDefinitionInner>> getWithServiceResponseAsync(String policySetDefinitionName) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.get(policySetDefinitionName, this.client.subscriptionId(), "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicySetDefinitionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicySetDefinitionInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicySetDefinitionInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicySetDefinitionInner getBuiltIn(String policySetDefinitionName) {
        return (PolicySetDefinitionInner)((ServiceResponse)this.getBuiltInWithServiceResponseAsync(policySetDefinitionName).toBlocking().single()).body();
    }

    public ServiceFuture<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName, ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getBuiltInWithServiceResponseAsync(policySetDefinitionName), serviceCallback);
    }

    public Observable<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName) {
        return this.getBuiltInWithServiceResponseAsync(policySetDefinitionName).map((Func1)new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>(){

            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return (PolicySetDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicySetDefinitionInner>> getBuiltInWithServiceResponseAsync(String policySetDefinitionName) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.getBuiltIn(policySetDefinitionName, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicySetDefinitionsInner.this.getBuiltInDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicySetDefinitionInner> getBuiltInDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicySetDefinitionInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicySetDefinitionInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>((Page)response.body()){

            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicySetDefinitionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicySetDefinitionInner>> listAsync(ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                return PolicySetDefinitionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicySetDefinitionInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>(){

            public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicySetDefinitionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.list(this.client.subscriptionId(), "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicySetDefinitionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicySetDefinitionInner> listBuiltIn() {
        ServiceResponse response = (ServiceResponse)this.listBuiltInSinglePageAsync().toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>((Page)response.body()){

            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicySetDefinitionsInner.this.listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicySetDefinitionInner>> listBuiltInAsync(ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBuiltInSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                return PolicySetDefinitionsInner.this.listBuiltInNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicySetDefinitionInner>> listBuiltInAsync() {
        return this.listBuiltInWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>(){

            public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listBuiltInWithServiceResponseAsync() {
        return this.listBuiltInSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicySetDefinitionsInner.this.listBuiltInNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listBuiltInSinglePageAsync() {
        String apiVersion = "2017-06-01-preview";
        return this.service.listBuiltIn("2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicySetDefinitionsInner.this.listBuiltInDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listBuiltInDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicySetDefinitionInner createOrUpdateAtManagementGroup(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return (PolicySetDefinitionInner)((ServiceResponse)this.createOrUpdateAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters, ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId, parameters), serviceCallback);
    }

    public Observable<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId, parameters).map((Func1)new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>(){

            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return (PolicySetDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithServiceResponseAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-06-01-preview";
        return this.service.createOrUpdateAtManagementGroup(policySetDefinitionName, managementGroupId, parameters, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicySetDefinitionsInner.this.createOrUpdateAtManagementGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicySetDefinitionInner> createOrUpdateAtManagementGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicySetDefinitionInner>(){}.getType()).register(201, new TypeToken<PolicySetDefinitionInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void deleteAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        ((ServiceResponse)this.deleteAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId), serviceCallback);
    }

    public Observable<Void> deleteAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId) {
        return this.deleteAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtManagementGroupWithServiceResponseAsync(String policySetDefinitionName, String managementGroupId) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.deleteAtManagementGroup(policySetDefinitionName, managementGroupId, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicySetDefinitionsInner.this.deleteAtManagementGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAtManagementGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicySetDefinitionInner getAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        return (PolicySetDefinitionInner)((ServiceResponse)this.getAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId).toBlocking().single()).body();
    }

    public ServiceFuture<PolicySetDefinitionInner> getAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId), serviceCallback);
    }

    public Observable<PolicySetDefinitionInner> getAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId) {
        return this.getAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId).map((Func1)new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>(){

            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return (PolicySetDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicySetDefinitionInner>> getAtManagementGroupWithServiceResponseAsync(String policySetDefinitionName, String managementGroupId) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.getAtManagementGroup(policySetDefinitionName, managementGroupId, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicySetDefinitionsInner.this.getAtManagementGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicySetDefinitionInner> getAtManagementGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicySetDefinitionInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId) {
        ServiceResponse response = (ServiceResponse)this.listByManagementGroupSinglePageAsync(managementGroupId).toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>((Page)response.body()){

            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicySetDefinitionsInner.this.listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicySetDefinitionInner>> listByManagementGroupAsync(String managementGroupId, ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByManagementGroupSinglePageAsync(managementGroupId), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                return PolicySetDefinitionsInner.this.listByManagementGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicySetDefinitionInner>> listByManagementGroupAsync(String managementGroupId) {
        return this.listByManagementGroupWithServiceResponseAsync(managementGroupId).map((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>(){

            public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listByManagementGroupWithServiceResponseAsync(String managementGroupId) {
        return this.listByManagementGroupSinglePageAsync(managementGroupId).concatMap((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicySetDefinitionsInner.this.listByManagementGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listByManagementGroupSinglePageAsync(String managementGroupId) {
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.listByManagementGroup(managementGroupId, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicySetDefinitionsInner.this.listByManagementGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listByManagementGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicySetDefinitionInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>((Page)response.body()){

            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicySetDefinitionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicySetDefinitionInner>> listNextAsync(String nextPageLink, ServiceFuture<List<PolicySetDefinitionInner>> serviceFuture, ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                return PolicySetDefinitionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicySetDefinitionInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>(){

            public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicySetDefinitionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicySetDefinitionsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicySetDefinitionInner> listBuiltInNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>((Page)response.body()){

            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicySetDefinitionsInner.this.listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicySetDefinitionInner>> listBuiltInNextAsync(String nextPageLink, ServiceFuture<List<PolicySetDefinitionInner>> serviceFuture, ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBuiltInNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                return PolicySetDefinitionsInner.this.listBuiltInNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicySetDefinitionInner>> listBuiltInNextAsync(String nextPageLink) {
        return this.listBuiltInNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>(){

            public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listBuiltInNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBuiltInNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicySetDefinitionsInner.this.listBuiltInNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listBuiltInNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBuiltInNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicySetDefinitionsInner.this.listBuiltInNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listBuiltInNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicySetDefinitionInner> listByManagementGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>((Page)response.body()){

            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicySetDefinitionsInner.this.listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicySetDefinitionInner>> listByManagementGroupNextAsync(String nextPageLink, ServiceFuture<List<PolicySetDefinitionInner>> serviceFuture, ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByManagementGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                return PolicySetDefinitionsInner.this.listByManagementGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicySetDefinitionInner>> listByManagementGroupNextAsync(String nextPageLink) {
        return this.listByManagementGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>(){

            public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listByManagementGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByManagementGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicySetDefinitionsInner.this.listByManagementGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listByManagementGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByManagementGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicySetDefinitionsInner.this.listByManagementGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listByManagementGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface PolicySetDefinitionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="policySetDefinitionName") String var1, @Path(value="subscriptionId") String var2, @Body PolicySetDefinitionInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions delete"})
        @HTTP(path="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="policySetDefinitionName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="policySetDefinitionName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions getBuiltIn"})
        @GET(value="providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        public Observable<Response<ResponseBody>> getBuiltIn(@Path(value="policySetDefinitionName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listBuiltIn"})
        @GET(value="providers/Microsoft.Authorization/policySetDefinitions")
        public Observable<Response<ResponseBody>> listBuiltIn(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions createOrUpdateAtManagementGroup"})
        @PUT(value="providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtManagementGroup(@Path(value="policySetDefinitionName") String var1, @Path(value="managementGroupId") String var2, @Body PolicySetDefinitionInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions deleteAtManagementGroup"})
        @HTTP(path="providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtManagementGroup(@Path(value="policySetDefinitionName") String var1, @Path(value="managementGroupId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions getAtManagementGroup"})
        @GET(value="providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        public Observable<Response<ResponseBody>> getAtManagementGroup(@Path(value="policySetDefinitionName") String var1, @Path(value="managementGroupId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listByManagementGroup"})
        @GET(value="providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions")
        public Observable<Response<ResponseBody>> listByManagementGroup(@Path(value="managementGroupId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listBuiltInNext"})
        @GET
        public Observable<Response<ResponseBody>> listBuiltInNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listByManagementGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByManagementGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

