/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.impl.FindBrokerResult;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class PrintMessageSubCommand
implements SubCommand {
    public static long timestampFormat(String value) {
        long timestamp = 0L;
        try {
            timestamp = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            timestamp = UtilAll.parseDate((String)value, (String)"yyyy-MM-dd#HH:mm:ss:SSS").getTime();
        }
        return timestamp;
    }

    public static void printMessage(List<MessageExt> msgs, String charsetName, boolean printBody) {
        for (MessageExt msg : msgs) {
            try {
                System.out.printf("MSGID: %s %s BODY: %s%n", msg.getMsgId(), msg.toString(), printBody ? new String(msg.getBody(), charsetName) : "NOT PRINT BODY");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
    }

    @Override
    public String commandName() {
        return "printMsg";
    }

    @Override
    public String commandDesc() {
        return "Print Message Detail.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("t", "topic", true, "topic name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("c", "charsetName ", true, "CharsetName(eg: UTF-8,GBK)");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "subExpression ", true, "Subscribe Expression(eg: TagA || TagB)");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("b", "beginTimestamp ", true, "Begin timestamp[currentTimeMillis|yyyy-MM-dd#HH:mm:ss:SSS]");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("e", "endTimestamp ", true, "End timestamp[currentTimeMillis|yyyy-MM-dd#HH:mm:ss:SSS]");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("d", "printBody ", true, "print body");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("l", "lmqParentTopic", true, "Lmq parent topic, lmq is used to find the route.");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer("TOOLS_CONSUMER", rpcHook);
        try {
            Set mqs;
            String topic = commandLine.getOptionValue('t').trim();
            String charsetName = !commandLine.hasOption('c') ? "UTF-8" : commandLine.getOptionValue('c').trim();
            String subExpression = !commandLine.hasOption('s') ? "*" : commandLine.getOptionValue('s').trim();
            String lmqParentTopic = !commandLine.hasOption('l') ? null : commandLine.getOptionValue('l').trim();
            boolean printBody = !commandLine.hasOption('d') || Boolean.parseBoolean(commandLine.getOptionValue('d').trim());
            consumer.start();
            if (lmqParentTopic != null) {
                mqs = consumer.fetchSubscribeMessageQueues(lmqParentTopic);
                mqs.forEach(mq -> mq.setTopic(topic));
            } else {
                mqs = consumer.fetchSubscribeMessageQueues(topic);
            }
            for (MessageQueue mq2 : mqs) {
                long timeValue;
                String timestampStr;
                long minOffset = consumer.minOffset(mq2);
                long maxOffset = consumer.maxOffset(mq2);
                if (commandLine.hasOption('b')) {
                    timestampStr = commandLine.getOptionValue('b').trim();
                    timeValue = PrintMessageSubCommand.timestampFormat(timestampStr);
                    minOffset = consumer.searchOffset(mq2, timeValue);
                }
                if (commandLine.hasOption('e')) {
                    timestampStr = commandLine.getOptionValue('e').trim();
                    timeValue = PrintMessageSubCommand.timestampFormat(timestampStr);
                    maxOffset = consumer.searchOffset(mq2, timeValue);
                }
                System.out.printf("minOffset=%s, maxOffset=%s, %s%n", minOffset, maxOffset, mq2);
                long offset = minOffset;
                block13: while (offset < maxOffset) {
                    try {
                        this.fillBrokerAddrIfNotExist(consumer, mq2, lmqParentTopic);
                        PullResult pullResult = consumer.pull(mq2, subExpression, offset, 32);
                        offset = pullResult.getNextBeginOffset();
                        switch (pullResult.getPullStatus()) {
                            case FOUND: {
                                PrintMessageSubCommand.printMessage(pullResult.getMsgFoundList(), charsetName, printBody);
                                break;
                            }
                            case NO_MATCHED_MSG: {
                                System.out.printf("%s no matched msg. status=%s, offset=%s%n", mq2, pullResult.getPullStatus(), offset);
                                break;
                            }
                            case NO_NEW_MSG: 
                            case OFFSET_ILLEGAL: {
                                System.out.printf("%s print msg finished. status=%s, offset=%s%n", mq2, pullResult.getPullStatus(), offset);
                                break block13;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                System.out.printf("--------------------------------------------------------\n", new Object[0]);
            }
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            consumer.shutdown();
        }
    }

    public void fillBrokerAddrIfNotExist(DefaultMQPullConsumer defaultMQPullConsumer, MessageQueue messageQueue, String routeTopic) {
        FindBrokerResult findBrokerResult = defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, false);
        if (findBrokerResult == null) {
            defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().updateTopicRouteInfoFromNameServer(routeTopic);
        }
    }
}

