/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.spider;

import java.util.Map;
import java.util.Random;
import org.apache.sedona.common.spider.PointBasedGenerator;
import org.locationtech.jts.geom.Coordinate;

public class BitGenerator
extends PointBasedGenerator {
    private final BitParameter parameter;

    public BitGenerator(Random random, BitParameter bitParameter) {
        super(random, bitParameter.pointBasedParameter);
        this.parameter = bitParameter;
    }

    @Override
    protected Coordinate generateCoordinate() {
        double x = this.generateCoordinateValue();
        double y = this.generateCoordinateValue();
        return new Coordinate(x, y);
    }

    private double generateCoordinateValue() {
        double n = 0.0;
        for (int i = 1; i <= this.parameter.digits; ++i) {
            double bit = this.bernoulli(this.parameter.probability);
            n += bit / (double)(1 << i);
        }
        return n;
    }

    public static class BitParameter {
        public final PointBasedGenerator.PointBasedParameter pointBasedParameter;
        public final double probability;
        public final int digits;

        public BitParameter(PointBasedGenerator.PointBasedParameter pointBasedParameter, double probability, int digits) {
            if (probability < 0.0 || probability > 1.0) {
                throw new IllegalArgumentException("Probability must be between 0 and 1");
            }
            if (digits <= 0) {
                throw new IllegalArgumentException("Digits must be a positive integer");
            }
            this.pointBasedParameter = pointBasedParameter;
            this.probability = probability;
            this.digits = digits;
        }

        public static BitParameter create(Map<String, String> conf) {
            PointBasedGenerator.PointBasedParameter pointBasedParameter = PointBasedGenerator.PointBasedParameter.create(conf);
            double probability = Double.parseDouble(conf.getOrDefault("probability", "0.2"));
            int digits = Integer.parseInt(conf.getOrDefault("digits", "10"));
            return new BitParameter(pointBasedParameter, probability, digits);
        }
    }
}

