/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os;

import com.google.common.annotations.VisibleForTesting;
import com.sun.management.OperatingSystemMXBean;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.lang.management.ManagementFactory;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;

public class SystemMeter
implements PeriodMeter {
    public static final String SYSTEM_LOAD_AVERAGE = "sla";
    public static final String CPU_USAGE = "cpu";
    public static final String PROCESS_CPU_USAGE = "processCpu";
    public static final String MEMORY_USAGE = "memory";
    private OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);

    public SystemMeter(MeterRegistry meterRegistry, String name) {
        Gauge.builder((String)name, () -> this.getOsBean().getSystemLoadAverage()).tags((Iterable)Tags.of((String)"type", (String)SYSTEM_LOAD_AVERAGE)).register(meterRegistry);
        Gauge.builder((String)name, () -> this.getOsBean().getCpuLoad()).tags((Iterable)Tags.of((String)"type", (String)CPU_USAGE)).register(meterRegistry);
        Gauge.builder((String)name, () -> this.getOsBean().getProcessCpuLoad()).tags((Iterable)Tags.of((String)"type", (String)PROCESS_CPU_USAGE)).register(meterRegistry);
        Gauge.builder((String)name, () -> (double)(this.getOsBean().getTotalMemorySize() - this.getOsBean().getFreeMemorySize()) / (double)this.getOsBean().getTotalMemorySize()).tags((Iterable)Tags.of((String)"type", (String)MEMORY_USAGE)).register(meterRegistry);
    }

    @VisibleForTesting
    public void setOsBean(OperatingSystemMXBean mock) {
        this.osBean = mock;
    }

    private OperatingSystemMXBean getOsBean() {
        return this.osBean;
    }

    public void poll(long msNow, long secondInterval) {
    }
}

