/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.mcp.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.Objects;
import org.apache.shenyu.client.mcp.common.dto.ShenyuMcpRequestConfig;

public class McpRequestConfigGenerator {
    public static JsonObject generateRequestConfig(JsonObject openApiJson, ShenyuMcpRequestConfig shenyuMcpRequestConfig) {
        JsonObject root = new JsonObject();
        JsonObject requestTemplate = new JsonObject();
        root.add("requestTemplate", (JsonElement)requestTemplate);
        JsonObject paths = openApiJson.get("paths").getAsJsonObject();
        String path = null;
        Iterator iterator = paths.keySet().iterator();
        if (iterator.hasNext()) {
            String methodKey;
            path = methodKey = (String)iterator.next();
        }
        requestTemplate.addProperty("url", path);
        JsonObject method = paths.get(path).getAsJsonObject();
        String methodType = null;
        Iterator iterator2 = method.keySet().iterator();
        if (iterator2.hasNext()) {
            String methodKey;
            methodType = methodKey = (String)iterator2.next();
        }
        requestTemplate.addProperty("method", methodType);
        JsonObject methodTypeJson = method.getAsJsonObject(methodType);
        JsonArray parameters = methodTypeJson.getAsJsonArray("parameters");
        if (Objects.nonNull(parameters)) {
            JsonObject argsPosition = new JsonObject();
            for (JsonElement parameter : parameters) {
                JsonObject paramObj = parameter.getAsJsonObject();
                if (!paramObj.has("name") || !paramObj.has("in")) continue;
                String name = paramObj.get("name").getAsString();
                String inValue = paramObj.get("in").getAsString();
                argsPosition.addProperty(name, inValue);
            }
            requestTemplate.add("argsPosition", (JsonElement)argsPosition);
        }
        requestTemplate.addProperty("argsToJsonBody", shenyuMcpRequestConfig.getBodyToJson());
        JsonArray headers = new JsonArray();
        shenyuMcpRequestConfig.getHeaders().forEach((key, value) -> {
            JsonObject headerJson = new JsonObject();
            headerJson.addProperty("key", key);
            headerJson.addProperty("value", value);
            headers.add((JsonElement)headerJson);
        });
        requestTemplate.add("headers", (JsonElement)headers);
        return root;
    }
}

