/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JAXRSProviderManager {
    private static Set<Class> internalProviderClasses = Collections.synchronizedSet(new HashSet());
    private static Set<Object> customProviderInstances = Collections.synchronizedSet(new HashSet());
    public static final String CGLIB_CLASS_SEPARATOR = "$$";

    public static void registerInternalProviderClass(Class provider) {
        internalProviderClasses.add(provider);
    }

    public static void removeInternalProviderClass(Class provider) {
        internalProviderClasses.remove(provider);
    }

    public static Set<Class> getInternalProviderClasses() {
        return internalProviderClasses;
    }

    public static void registerCustomProviderInstance(Object provider) {
        customProviderInstances.add(provider);
    }

    public static void removeCustomProviderInstance(Object provider) {
        customProviderInstances.remove(provider);
    }

    public static Set<Object> getCustomProviderInstances() {
        return customProviderInstances;
    }

    public static Class<?> getTargetClass(Object candidate) {
        return JAXRSProviderManager.isCglibProxyClass(candidate.getClass()) ? candidate.getClass().getSuperclass() : candidate.getClass();
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && JAXRSProviderManager.isCglibProxyClassName(clazz.getName());
    }

    public static boolean isCglibProxyClassName(String className) {
        return className != null && className.contains(CGLIB_CLASS_SEPARATOR);
    }
}

