/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.interceptor;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.interceptor.TripleServerInterceptor;
import com.alipay.sofa.rpc.tracer.sofatracer.TracingContextKey;
import com.alipay.sofa.rpc.tracer.sofatracer.TripleTracerAdapter;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerReqHeaderInterceptor
extends TripleServerInterceptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(ServerReqHeaderInterceptor.class);

    public ServerReqHeaderInterceptor(ServerServiceDefinition serverServiceDefinition) {
        super(serverServiceDefinition);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
        final ServerServiceDefinition serverServiceDefinition = this.getServerServiceDefinition();
        final SofaResponse sofaResponse = new SofaResponse();
        final Throwable[] throwable = new Throwable[]{null};
        final SofaRequest sofaRequest = new SofaRequest();
        TripleTracerAdapter.serverReceived(sofaRequest, serverServiceDefinition, call, requestHeaders);
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan serverSpan = sofaTraceContext.getCurrentSpan();
        final Context ctxWithSpan = Context.current().withValue(TracingContextKey.getKey(), (Object)serverSpan).withValue(TracingContextKey.getSpanContextKey(), (Object)serverSpan.context()).withValue(TracingContextKey.getKeySofaRequest(), (Object)sofaRequest);
        if (RpcRunningState.isDebugMode()) {
            LOGGER.info("[1]header received from client:" + requestHeaders);
        }
        ForwardingServerCall.SimpleForwardingServerCall realCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendHeaders(Metadata responseHeaders) {
                if (RpcRunningState.isDebugMode()) {
                    LOGGER.info("[4]send response header:{}", (Object)responseHeaders);
                }
                super.sendHeaders(responseHeaders);
            }

            public void sendMessage(RespT message) {
                if (RpcRunningState.isDebugMode()) {
                    LOGGER.info("[5]send response message:{}", message);
                }
                super.sendMessage(message);
                sofaResponse.setAppResponse(message);
            }

            public void close(Status status, Metadata trailers) {
                if (RpcRunningState.isDebugMode()) {
                    LOGGER.info("[6]send response message:{},trailers:{}", (Object)status, (Object)trailers);
                }
                super.close(status, trailers);
            }
        };
        ServerCall.Listener listenerWithContext = Contexts.interceptCall((Context)ctxWithSpan, (ServerCall)realCall, (Metadata)requestHeaders, next);
        ForwardingServerCallListener.SimpleForwardingServerCallListener result = new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listenerWithContext){

            public void onComplete() {
                super.onComplete();
                if (RpcRunningState.isDebugMode()) {
                    LOGGER.info("[7]server processed done received from client:" + requestHeaders);
                }
                TripleTracerAdapter.serverReceived(sofaRequest, serverServiceDefinition, call, requestHeaders);
                SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
                SofaTracerSpan serverSpan = sofaTraceContext.getCurrentSpan();
                SofaTracerSpan originalSpan = (SofaTracerSpan)TracingContextKey.getKey().get(ctxWithSpan);
                serverSpan.setStartTime(originalSpan.getStartTime());
                serverSpan.setTag("remote.ip", (String)originalSpan.getTagsWithStr().get("remote.ip"));
                long endTime = RpcRuntimeContext.now();
                serverSpan.setTag("biz.impl.time", (Number)(endTime - originalSpan.getStartTime()));
                TripleTracerAdapter.serverSend(sofaRequest, requestHeaders, sofaResponse, throwable[0]);
            }

            public void onHalfClose() {
                try {
                    this.doOnHalfClose();
                }
                finally {
                    RpcInvokeContext.removeContext();
                }
            }

            private void doOnHalfClose() {
                if (RpcRunningState.isDebugMode()) {
                    LOGGER.info("[2]body received done from client:" + requestHeaders);
                }
                TripleTracerAdapter.serverReceived(sofaRequest, serverServiceDefinition, call, requestHeaders);
                try {
                    super.onHalfClose();
                }
                catch (Throwable t) {
                    StatusRuntimeException exception = this.fromThrowable(t);
                    call.close(exception.getStatus(), exception.getTrailers());
                    throwable[0] = t;
                }
            }

            private StatusRuntimeException fromThrowable(Throwable t) {
                Metadata trailers = new Metadata();
                return new StatusRuntimeException(Status.UNKNOWN, trailers);
            }
        };
        return result;
    }
}

