/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.cluster;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.support.log.LoggerFactory;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class ServantInvokerAliveStat {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private final String identity;
    private final AtomicBoolean lastCallSuccess = new AtomicBoolean(true);
    private long timeout_startTime = 0L;
    private long frequencyFailInvoke = 0L;
    private long frequencyFailInvoke_startTime = 0L;
    private long timeoutCount = 0L;
    private long failedCount = 0L;
    private long successCount = 0L;
    private boolean netConnectTimeout = false;
    private boolean alive = true;
    private long lastRetryTime = 0L;

    ServantInvokerAliveStat(String identity) {
        this.identity = identity;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public synchronized void onCallFinished(int ret, ServantProxyConfig config) {
        if (ret == 0) {
            this.frequencyFailInvoke = 0L;
            this.frequencyFailInvoke_startTime = 0L;
            this.lastCallSuccess.set(true);
            this.netConnectTimeout = false;
            ++this.successCount;
        } else if (ret == 2) {
            if (!this.lastCallSuccess.get()) {
                ++this.frequencyFailInvoke;
            } else {
                this.lastCallSuccess.set(false);
                this.frequencyFailInvoke = 1L;
                this.frequencyFailInvoke_startTime = System.currentTimeMillis();
            }
            this.netConnectTimeout = false;
            ++this.timeoutCount;
        } else if (ret == 1) {
            if (!this.lastCallSuccess.get()) {
                ++this.frequencyFailInvoke;
            } else {
                this.lastCallSuccess.set(false);
                this.frequencyFailInvoke = 1L;
                this.frequencyFailInvoke_startTime = System.currentTimeMillis();
            }
            this.netConnectTimeout = false;
            ++this.failedCount;
        } else if (ret == 3) {
            this.netConnectTimeout = true;
        }
        if (this.timeout_startTime + (long)config.getCheckInterval() < System.currentTimeMillis()) {
            this.timeoutCount = 0L;
            this.failedCount = 0L;
            this.successCount = 0L;
            this.timeout_startTime = System.currentTimeMillis();
        }
        if (this.alive) {
            double radio;
            long totalCount = this.timeoutCount + this.failedCount + this.successCount;
            if (this.timeoutCount >= (long)config.getMinTimeoutInvoke() && (radio = this.div(this.timeoutCount, totalCount, 2)) > (double)config.getFrequenceFailRadio()) {
                this.alive = false;
                this.lastRetryTime = System.currentTimeMillis();
                logger.info(this.identity + "|alive=false|radio=" + radio + "|" + this.toString());
            }
            if (this.alive && this.frequencyFailInvoke >= (long)config.getFrequenceFailInvoke() && this.frequencyFailInvoke_startTime + 5000L > System.currentTimeMillis()) {
                this.alive = false;
                this.lastRetryTime = System.currentTimeMillis();
                logger.info("{}|alive=false|frequenceFailInvoke={}|{}", new Object[]{this.identity, this.frequencyFailInvoke, this.toString()});
            }
            if (this.alive && this.netConnectTimeout) {
                this.alive = false;
                this.lastRetryTime = System.currentTimeMillis();
                logger.info("{}|alive=false|netConnectTimeout|{}", (Object)this.identity, (Object)this.toString());
            }
        } else if (ret == 0) {
            this.alive = true;
        }
    }

    public long getLastRetryTime() {
        return this.lastRetryTime;
    }

    public void setLastRetryTime(long lastRetryTime) {
        this.lastRetryTime = lastRetryTime;
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append("lastCallSucc:").append(this.lastCallSuccess.get()).append("|");
        build.append("timeoutCount:").append(this.timeoutCount).append("|");
        build.append("failedCount:").append(this.failedCount).append("|");
        build.append("succCount:").append(this.successCount).append("|");
        build.append("available:").append(this.alive).append("|");
        build.append("netConnectTimeout:").append(this.netConnectTimeout).append("|");
        build.append("timeout_startTime:").append(new Date(this.timeout_startTime)).append("|");
        build.append("frequenceFailInvoke:").append(this.frequencyFailInvoke).append("|");
        build.append("frequenceFailInvoke_startTime:").append(new Date(this.frequencyFailInvoke_startTime)).append("|");
        build.append("lastRetryTime:").append(new Date(this.lastRetryTime));
        return build.toString();
    }

    private double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }
}

