/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.MessageIdAdvUtils;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.io.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NegativeAcksTracker
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(NegativeAcksTracker.class);
    private HashMap<MessageId, Long> nackedMessages = null;
    private final ConsumerBase<?> consumer;
    private final Timer timer;
    private final long nackDelayNanos;
    private final long timerIntervalNanos;
    private final RedeliveryBackoff negativeAckRedeliveryBackoff;
    private Timeout timeout;
    private static final long MIN_NACK_DELAY_NANOS = TimeUnit.MILLISECONDS.toNanos(100L);

    public NegativeAcksTracker(ConsumerBase<?> consumer, ConsumerConfigurationData<?> conf) {
        this.consumer = consumer;
        this.timer = consumer.getClient().timer();
        this.nackDelayNanos = Math.max(TimeUnit.MICROSECONDS.toNanos(conf.getNegativeAckRedeliveryDelayMicros()), MIN_NACK_DELAY_NANOS);
        this.negativeAckRedeliveryBackoff = conf.getNegativeAckRedeliveryBackoff();
        this.timerIntervalNanos = this.negativeAckRedeliveryBackoff != null ? Math.max(TimeUnit.MILLISECONDS.toNanos(this.negativeAckRedeliveryBackoff.next(0)), MIN_NACK_DELAY_NANOS) / 3L : this.nackDelayNanos / 3L;
    }

    private synchronized void triggerRedelivery(Timeout t2) {
        if (this.nackedMessages.isEmpty()) {
            this.timeout = null;
            return;
        }
        HashSet<MessageId> messagesToRedeliver = new HashSet<MessageId>();
        long now = System.nanoTime();
        this.nackedMessages.forEach((msgId, timestamp) -> {
            if (timestamp < now) {
                UnAckedMessageTracker.addChunkedMessageIdsAndRemoveFromSequenceMap(msgId, messagesToRedeliver, this.consumer);
                messagesToRedeliver.add((MessageId)msgId);
            }
        });
        if (!messagesToRedeliver.isEmpty()) {
            messagesToRedeliver.forEach(this.nackedMessages::remove);
            this.consumer.onNegativeAcksSend(messagesToRedeliver);
            log.info("[{}] {} messages will be re-delivered", this.consumer, (Object)messagesToRedeliver.size());
            this.consumer.redeliverUnacknowledgedMessages(messagesToRedeliver);
        }
        this.timeout = this.timer.newTimeout(this::triggerRedelivery, this.timerIntervalNanos, TimeUnit.NANOSECONDS);
    }

    public synchronized void add(MessageId messageId) {
        this.add(messageId, 0);
    }

    public synchronized void add(Message<?> message) {
        this.add(message.getMessageId(), message.getRedeliveryCount());
    }

    private synchronized void add(MessageId messageId, int redeliveryCount) {
        if (this.nackedMessages == null) {
            this.nackedMessages = new HashMap();
        }
        long backoffNs = this.negativeAckRedeliveryBackoff != null ? TimeUnit.MILLISECONDS.toNanos(this.negativeAckRedeliveryBackoff.next(redeliveryCount)) : this.nackDelayNanos;
        this.nackedMessages.put(MessageIdAdvUtils.discardBatch(messageId), System.nanoTime() + backoffNs);
        if (this.timeout == null) {
            this.timeout = this.timer.newTimeout(this::triggerRedelivery, this.timerIntervalNanos, TimeUnit.NANOSECONDS);
        }
    }

    @VisibleForTesting
    Optional<Integer> getNackedMessagesCount() {
        return Optional.ofNullable(this.nackedMessages).map(HashMap::size);
    }

    @Override
    public synchronized void close() {
        if (this.timeout != null && !this.timeout.isCancelled()) {
            this.timeout.cancel();
            this.timeout = null;
        }
        if (this.nackedMessages != null) {
            this.nackedMessages.clear();
            this.nackedMessages = null;
        }
    }
}

