/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.v2motan;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.rpc.CompressRpcCodec;
import com.weibo.api.motan.protocol.rpc.DefaultRpcCodec;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.protocol.v2motan.MotanV2Codec;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.ByteUtil;
import java.io.IOException;

@SpiMeta(name="motan-compatible")
public class CompatibleCodec
implements Codec {
    private Codec v1 = new DefaultRpcCodec();
    private Codec v1Compress = new CompressRpcCodec();
    private Codec v2 = new MotanV2Codec();

    @Override
    public byte[] encode(Channel channel, Object message) throws IOException {
        if (message instanceof Response) {
            byte version = ((Response)message).getRpcProtocolVersion();
            if (version == RpcProtocolVersion.VERSION_1.getVersion()) {
                return this.v1.encode(channel, message);
            }
            if (version == RpcProtocolVersion.VERSION_1_Compress.getVersion()) {
                return this.v1Compress.encode(channel, message);
            }
        }
        return this.v2.encode(channel, message);
    }

    @Override
    public Object decode(Channel channel, String remoteIp, byte[] buffer) throws IOException {
        if (buffer.length < 2) {
            throw new MotanServiceException("not enough bytes for decode. length:" + buffer.length);
        }
        short type = ByteUtil.bytes2short(buffer, 0);
        if (type == -3856) {
            return this.v1Compress.decode(channel, remoteIp, buffer);
        }
        if (type == -3599) {
            return this.v2.decode(channel, remoteIp, buffer);
        }
        throw new MotanFrameworkException("decode error: magic error. magic:" + type);
    }
}

