/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer.collection;

import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.collection.IdentityMap;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.Serializer;
import io.fury.type.GenericType;
import io.fury.type.Generics;
import io.fury.type.TypeUtils;
import io.fury.util.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractMapSerializer<T>
extends Serializer<T> {
    protected MethodHandle constructor;
    protected final boolean supportCodegenHook;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    protected final ClassInfoHolder keyClassInfoWriteCache;
    protected final ClassInfoHolder keyClassInfoReadCache;
    protected final ClassInfoHolder valueClassInfoWriteCache;
    protected final ClassInfoHolder valueClassInfoReadCache;
    private final IdentityMap<GenericType, Tuple2<GenericType, GenericType>> partialGenericKVTypeMap;
    private final GenericType objType;
    protected int numElements;

    public AbstractMapSerializer(Fury fury, Class<T> cls) {
        this(fury, cls, !ReflectionUtils.isDynamicGeneratedCLass(cls));
    }

    public AbstractMapSerializer(Fury fury, Class<T> cls, boolean supportCodegenHook) {
        super(fury, cls);
        this.objType = this.fury.getClassResolver().buildGenericType((Type)((Object)Object.class));
        this.supportCodegenHook = supportCodegenHook;
        this.keyClassInfoWriteCache = fury.getClassResolver().nilClassInfoHolder();
        this.keyClassInfoReadCache = fury.getClassResolver().nilClassInfoHolder();
        this.valueClassInfoWriteCache = fury.getClassResolver().nilClassInfoHolder();
        this.valueClassInfoReadCache = fury.getClassResolver().nilClassInfoHolder();
        this.partialGenericKVTypeMap = new IdentityMap();
    }

    public void setKeySerializer(Serializer keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void setValueSerializer(Serializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Map map = this.onMapWrite(buffer, value);
        this.writeElements(this.fury, buffer, map);
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        Map map = this.onMapWrite(buffer, value);
        AbstractMapSerializer.xwriteElements(this.fury, buffer, map);
    }

    protected final void writeElements(Fury fury, MemoryBuffer buffer, Map map) {
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        this.keySerializer = null;
        this.valueSerializer = null;
        if (keySerializer != null && valueSerializer != null) {
            this.javaWriteWithKVSerializers(fury, buffer, map, keySerializer, valueSerializer);
        } else if (keySerializer != null) {
            ClassResolver classResolver = fury.getClassResolver();
            RefResolver refResolver = fury.getRefResolver();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                fury.writeRef(buffer, entry.getKey(), keySerializer);
                Object value = entry.getValue();
                this.writeJavaRefOptimized(fury, classResolver, refResolver, buffer, value, this.valueClassInfoWriteCache);
            }
        } else if (valueSerializer != null) {
            ClassResolver classResolver = fury.getClassResolver();
            RefResolver refResolver = fury.getRefResolver();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                Object key = entry.getKey();
                this.writeJavaRefOptimized(fury, classResolver, refResolver, buffer, key, this.keyClassInfoWriteCache);
                fury.writeRef(buffer, entry.getValue(), valueSerializer);
            }
        } else {
            this.genericJavaWrite(fury, buffer, map);
        }
    }

    private void javaWriteWithKVSerializers(Fury fury, MemoryBuffer buffer, Map map, Serializer keySerializer, Serializer valueSerializer) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            fury.writeRef(buffer, key, keySerializer);
            fury.writeRef(buffer, value, valueSerializer);
        }
    }

    private void genericJavaWrite(Fury fury, MemoryBuffer buffer, Map map) {
        Generics generics = fury.getGenerics();
        GenericType genericType = generics.nextGenericType();
        if (genericType == null) {
            this.generalJavaWrite(fury, buffer, map);
        } else {
            GenericType keyGenericType = genericType.getTypeParameter0();
            GenericType valueGenericType = genericType.getTypeParameter1();
            if (genericType.getTypeParametersCount() < 2) {
                Tuple2<GenericType, GenericType> kvGenericType = this.getKVGenericType(genericType);
                if (keyGenericType == this.objType && valueGenericType == this.objType) {
                    this.generalJavaWrite(fury, buffer, map);
                    return;
                }
                keyGenericType = (GenericType)kvGenericType.f0;
                valueGenericType = (GenericType)kvGenericType.f1;
            }
            boolean keyGenericTypeFinal = keyGenericType.isFinal();
            boolean valueGenericTypeFinal = valueGenericType.isFinal();
            if (keyGenericTypeFinal && valueGenericTypeFinal) {
                this.javaKVTypesFinalWrite(fury, buffer, map, keyGenericType, valueGenericType, generics);
            } else if (keyGenericTypeFinal) {
                this.javaKeyTypeFinalWrite(fury, buffer, map, keyGenericType, valueGenericType, generics);
            } else if (valueGenericTypeFinal) {
                this.javaValueTypeFinalWrite(fury, buffer, map, keyGenericType, valueGenericType, generics);
            } else {
                this.javaKVTypesNonFinalWrite(fury, buffer, map, keyGenericType, valueGenericType, generics);
            }
        }
    }

    private void javaKVTypesFinalWrite(Fury fury, MemoryBuffer buffer, Map map, GenericType keyGenericType, GenericType valueGenericType, Generics generics) {
        Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
        Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            generics.pushGenericType(keyGenericType);
            fury.writeRef(buffer, entry.getKey(), keySerializer);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            fury.writeRef(buffer, entry.getValue(), valueSerializer);
            generics.popGenericType();
        }
    }

    private void javaKeyTypeFinalWrite(Fury fury, MemoryBuffer buffer, Map map, GenericType keyGenericType, GenericType valueGenericType, Generics generics) {
        ClassResolver classResolver = fury.getClassResolver();
        RefResolver refResolver = fury.getRefResolver();
        boolean trackingValueRef = fury.getClassResolver().needToWriteRef(valueGenericType.getCls());
        Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            generics.pushGenericType(keyGenericType);
            fury.writeRef(buffer, entry.getKey(), keySerializer);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            this.writeJavaRefOptimized(fury, classResolver, refResolver, trackingValueRef, buffer, entry.getValue(), this.valueClassInfoWriteCache);
            generics.popGenericType();
        }
    }

    private void javaValueTypeFinalWrite(Fury fury, MemoryBuffer buffer, Map map, GenericType keyGenericType, GenericType valueGenericType, Generics generics) {
        ClassResolver classResolver = fury.getClassResolver();
        RefResolver refResolver = fury.getRefResolver();
        boolean trackingKeyRef = fury.getClassResolver().needToWriteRef(keyGenericType.getCls());
        Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            generics.pushGenericType(keyGenericType);
            this.writeJavaRefOptimized(fury, classResolver, refResolver, trackingKeyRef, buffer, entry.getKey(), this.keyClassInfoWriteCache);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            fury.writeRef(buffer, entry.getValue(), valueSerializer);
            generics.popGenericType();
        }
    }

    private void javaKVTypesNonFinalWrite(Fury fury, MemoryBuffer buffer, Map map, GenericType keyGenericType, GenericType valueGenericType, Generics generics) {
        ClassResolver classResolver = fury.getClassResolver();
        RefResolver refResolver = fury.getRefResolver();
        boolean trackingKeyRef = fury.getClassResolver().needToWriteRef(keyGenericType.getCls());
        boolean trackingValueRef = fury.getClassResolver().needToWriteRef(valueGenericType.getCls());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            generics.pushGenericType(keyGenericType);
            this.writeJavaRefOptimized(fury, classResolver, refResolver, trackingKeyRef, buffer, entry.getKey(), this.keyClassInfoWriteCache);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            this.writeJavaRefOptimized(fury, classResolver, refResolver, trackingValueRef, buffer, entry.getValue(), this.valueClassInfoWriteCache);
            generics.popGenericType();
        }
    }

    private void generalJavaWrite(Fury fury, MemoryBuffer buffer, Map map) {
        ClassResolver classResolver = fury.getClassResolver();
        RefResolver refResolver = fury.getRefResolver();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            this.writeJavaRefOptimized(fury, classResolver, refResolver, buffer, entry.getKey(), this.keyClassInfoWriteCache);
            this.writeJavaRefOptimized(fury, classResolver, refResolver, buffer, entry.getValue(), this.valueClassInfoWriteCache);
        }
    }

    public static void xwriteElements(Fury fury, MemoryBuffer buffer, Map value) {
        Generics generics = fury.getGenerics();
        GenericType genericType = generics.nextGenericType();
        if (genericType == null || genericType.getTypeParametersCount() != 2) {
            Iterator iterator = value.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                fury.xwriteRef(buffer, entry.getKey());
                fury.xwriteRef(buffer, entry.getValue());
            }
        } else {
            GenericType keyGenericType = genericType.getTypeParameter0();
            GenericType valueGenericType = genericType.getTypeParameter1();
            Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
            Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
            if (!keyGenericType.hasGenericParameters() && !valueGenericType.hasGenericParameters()) {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    fury.xwriteRefByNullableSerializer(buffer, entry.getKey(), keySerializer);
                    fury.xwriteRefByNullableSerializer(buffer, entry.getValue(), valueSerializer);
                }
            } else if (valueGenericType.hasGenericParameters()) {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    fury.xwriteRefByNullableSerializer(buffer, entry.getKey(), keySerializer);
                    generics.pushGenericType(valueGenericType);
                    fury.xwriteRefByNullableSerializer(buffer, entry.getValue(), valueSerializer);
                    generics.popGenericType();
                }
            } else if (keyGenericType.hasGenericParameters()) {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    generics.pushGenericType(keyGenericType);
                    fury.xwriteRefByNullableSerializer(buffer, entry.getKey(), keySerializer);
                    generics.popGenericType();
                    fury.xwriteRefByNullableSerializer(buffer, entry.getValue(), valueSerializer);
                }
            } else {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    generics.pushGenericType(keyGenericType);
                    fury.xwriteRefByNullableSerializer(buffer, entry.getKey(), keySerializer);
                    generics.pushGenericType(valueGenericType);
                    fury.xwriteRefByNullableSerializer(buffer, entry.getValue(), valueSerializer);
                }
            }
            generics.popGenericType();
        }
    }

    private Tuple2<GenericType, GenericType> getKVGenericType(GenericType genericType) {
        Tuple2<GenericType, GenericType> genericTypes = this.partialGenericKVTypeMap.get(genericType);
        if (genericTypes == null) {
            TypeToken<?> typeToken = genericType.getTypeToken();
            if (!TypeUtils.MAP_TYPE.isSupertypeOf(typeToken)) {
                Tuple2<GenericType, GenericType> typeTuple = Tuple2.of(this.objType, this.objType);
                this.partialGenericKVTypeMap.put(genericType, typeTuple);
                return typeTuple;
            }
            Tuple2<TypeToken<?>, TypeToken<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeToken);
            genericTypes = Tuple2.of(this.fury.getClassResolver().buildGenericType(((TypeToken)mapKeyValueType.f0).getType()), this.fury.getClassResolver().buildGenericType(((TypeToken)mapKeyValueType.f1).getType()));
            this.partialGenericKVTypeMap.put(genericType, genericTypes);
        }
        return genericTypes;
    }

    @Override
    public T xread(MemoryBuffer buffer) {
        Map map = this.newMap(buffer);
        AbstractMapSerializer.xreadElements(this.fury, buffer, map, this.numElements);
        return this.onMapRead(map);
    }

    protected final void readElements(MemoryBuffer buffer, int size, Map map) {
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        this.keySerializer = null;
        this.valueSerializer = null;
        if (keySerializer != null && valueSerializer != null) {
            for (int i = 0; i < size; ++i) {
                Object key = this.fury.readRef(buffer, keySerializer);
                Object value = this.fury.readRef(buffer, valueSerializer);
                map.put(key, value);
            }
        } else if (keySerializer != null) {
            for (int i = 0; i < size; ++i) {
                Object key = this.fury.readRef(buffer, keySerializer);
                map.put(key, this.fury.readRef(buffer, this.keyClassInfoReadCache));
            }
        } else if (valueSerializer != null) {
            for (int i = 0; i < size; ++i) {
                Object key = this.fury.readRef(buffer);
                Object value = this.fury.readRef(buffer, valueSerializer);
                map.put(key, value);
            }
        } else {
            this.genericJavaRead(this.fury, buffer, map, size);
        }
    }

    private void genericJavaRead(Fury fury, MemoryBuffer buffer, Map map, int size) {
        Generics generics = fury.getGenerics();
        GenericType genericType = generics.nextGenericType();
        if (genericType == null) {
            this.generalJavaRead(fury, buffer, map, size);
        } else {
            GenericType keyGenericType = genericType.getTypeParameter0();
            GenericType valueGenericType = genericType.getTypeParameter1();
            if (genericType.getTypeParametersCount() < 2) {
                Tuple2<GenericType, GenericType> kvGenericType = this.getKVGenericType(genericType);
                if (keyGenericType == this.objType && valueGenericType == this.objType) {
                    this.generalJavaRead(fury, buffer, map, size);
                    return;
                }
                keyGenericType = (GenericType)kvGenericType.f0;
                valueGenericType = (GenericType)kvGenericType.f1;
            }
            boolean keyGenericTypeFinal = keyGenericType.isFinal();
            boolean valueGenericTypeFinal = valueGenericType.isFinal();
            if (keyGenericTypeFinal && valueGenericTypeFinal) {
                this.javaKVTypesFinalRead(fury, buffer, map, keyGenericType, valueGenericType, generics, size);
            } else if (keyGenericTypeFinal) {
                this.javaKeyTypeFinalRead(fury, buffer, map, keyGenericType, valueGenericType, generics, size);
            } else if (valueGenericTypeFinal) {
                this.javaValueTypeFinalRead(fury, buffer, map, keyGenericType, valueGenericType, generics, size);
            } else {
                this.javaKVTypesNonFinalRead(fury, buffer, map, keyGenericType, valueGenericType, generics, size);
            }
            generics.popGenericType();
        }
    }

    private void javaKVTypesFinalRead(Fury fury, MemoryBuffer buffer, Map map, GenericType keyGenericType, GenericType valueGenericType, Generics generics, int size) {
        Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
        Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
        for (int i = 0; i < size; ++i) {
            generics.pushGenericType(keyGenericType);
            Object key = fury.readRef(buffer, keySerializer);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            Object value = fury.readRef(buffer, valueSerializer);
            generics.popGenericType();
            map.put(key, value);
        }
    }

    private void javaKeyTypeFinalRead(Fury fury, MemoryBuffer buffer, Map map, GenericType keyGenericType, GenericType valueGenericType, Generics generics, int size) {
        RefResolver refResolver = fury.getRefResolver();
        boolean trackingValueRef = fury.getClassResolver().needToWriteRef(valueGenericType.getCls());
        Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
        for (int i = 0; i < size; ++i) {
            generics.pushGenericType(keyGenericType);
            Object key = fury.readRef(buffer, keySerializer);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            Object value = this.readJavaRefOptimized(fury, refResolver, trackingValueRef, buffer, this.valueClassInfoWriteCache);
            generics.popGenericType();
            map.put(key, value);
        }
    }

    private void javaValueTypeFinalRead(Fury fury, MemoryBuffer buffer, Map map, GenericType keyGenericType, GenericType valueGenericType, Generics generics, int size) {
        boolean trackingKeyRef = fury.getClassResolver().needToWriteRef(keyGenericType.getCls());
        Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
        RefResolver refResolver = fury.getRefResolver();
        for (int i = 0; i < size; ++i) {
            generics.pushGenericType(keyGenericType);
            Object key = this.readJavaRefOptimized(fury, refResolver, trackingKeyRef, buffer, this.keyClassInfoWriteCache);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            Object value = fury.readRef(buffer, valueSerializer);
            generics.popGenericType();
            map.put(key, value);
        }
    }

    private void javaKVTypesNonFinalRead(Fury fury, MemoryBuffer buffer, Map map, GenericType keyGenericType, GenericType valueGenericType, Generics generics, int size) {
        ClassResolver classResolver = fury.getClassResolver();
        RefResolver refResolver = fury.getRefResolver();
        boolean trackingKeyRef = classResolver.needToWriteRef(keyGenericType.getCls());
        boolean trackingValueRef = classResolver.needToWriteRef(valueGenericType.getCls());
        for (int i = 0; i < size; ++i) {
            generics.pushGenericType(keyGenericType);
            Object key = this.readJavaRefOptimized(fury, refResolver, trackingKeyRef, buffer, this.keyClassInfoWriteCache);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            Object value = this.readJavaRefOptimized(fury, refResolver, trackingValueRef, buffer, this.valueClassInfoWriteCache);
            generics.popGenericType();
            map.put(key, value);
        }
    }

    private void generalJavaRead(Fury fury, MemoryBuffer buffer, Map map, int size) {
        for (int i = 0; i < size; ++i) {
            Object key = fury.readRef(buffer, this.keyClassInfoReadCache);
            Object value = fury.readRef(buffer, this.valueClassInfoReadCache);
            map.put(key, value);
        }
    }

    public static void xreadElements(Fury fury, MemoryBuffer buffer, Map map, int size) {
        Generics generics = fury.getGenerics();
        GenericType genericType = generics.nextGenericType();
        if (genericType == null || genericType.getTypeParametersCount() != 2) {
            for (int i = 0; i < size; ++i) {
                Object key = fury.xreadRef(buffer);
                Object value = fury.xreadRef(buffer);
                map.put(key, value);
            }
        } else {
            GenericType keyGenericType = genericType.getTypeParameter0();
            GenericType valueGenericType = genericType.getTypeParameter1();
            Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
            Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
            if (!keyGenericType.hasGenericParameters() && !valueGenericType.hasGenericParameters()) {
                for (int i = 0; i < size; ++i) {
                    Object key = fury.xreadRefByNullableSerializer(buffer, keySerializer);
                    Object value = fury.xreadRefByNullableSerializer(buffer, valueSerializer);
                    map.put(key, value);
                }
            } else if (valueGenericType.hasGenericParameters()) {
                for (int i = 0; i < size; ++i) {
                    Object key = fury.xreadRefByNullableSerializer(buffer, keySerializer);
                    generics.pushGenericType(valueGenericType);
                    Object value = fury.xreadRefByNullableSerializer(buffer, valueSerializer);
                    generics.popGenericType();
                    map.put(key, value);
                }
            } else if (keyGenericType.hasGenericParameters()) {
                for (int i = 0; i < size; ++i) {
                    generics.pushGenericType(keyGenericType);
                    Object key = fury.xreadRefByNullableSerializer(buffer, keySerializer);
                    generics.popGenericType();
                    Object value = fury.xreadRefByNullableSerializer(buffer, valueSerializer);
                    map.put(key, value);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    generics.pushGenericType(keyGenericType);
                    Object key = fury.xreadRefByNullableSerializer(buffer, keySerializer);
                    generics.pushGenericType(valueGenericType);
                    Object value = fury.xreadRefByNullableSerializer(buffer, valueSerializer);
                    map.put(key, value);
                }
            }
            generics.popGenericType();
        }
    }

    public final boolean supportCodegenHook() {
        return this.supportCodegenHook;
    }

    public abstract Map onMapWrite(MemoryBuffer var1, T var2);

    private void writeJavaRefOptimized(Fury fury, ClassResolver classResolver, RefResolver refResolver, MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
        if (!refResolver.writeNullFlag(buffer, obj)) {
            fury.writeRef(buffer, obj, classResolver.getClassInfo(obj.getClass(), classInfoHolder));
        }
    }

    private void writeJavaRefOptimized(Fury fury, ClassResolver classResolver, RefResolver refResolver, boolean trackingRef, MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
        if (trackingRef) {
            if (!refResolver.writeNullFlag(buffer, obj)) {
                fury.writeRef(buffer, obj, classResolver.getClassInfo(obj.getClass(), classInfoHolder));
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            fury.writeNonRef(buffer, obj, classResolver.getClassInfo(obj.getClass(), classInfoHolder));
        }
    }

    @Override
    public abstract T read(MemoryBuffer var1);

    public Map newMap(MemoryBuffer buffer) {
        this.numElements = buffer.readPositiveVarInt();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            Map instance = this.constructor.invoke();
            this.fury.getRefResolver().reference(instance);
            return instance;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
        }
    }

    public int getNumElements() {
        return this.numElements;
    }

    public abstract T onMapRead(Map var1);

    private Object readJavaRefOptimized(Fury fury, RefResolver refResolver, boolean trackingRef, MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        if (trackingRef) {
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object obj = fury.readNonRef(buffer, classInfoHolder);
                refResolver.setReadObject(nextReadRefId, obj);
                return obj;
            }
            return refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return fury.readNonRef(buffer, classInfoHolder);
    }
}

