/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.reader;

import java.util.Map;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.geotiff.base.GeoKeys;
import org.apache.sis.storage.geotiff.reader.CRSBuilder;
import org.apache.sis.util.CharSequences;

public class GeoKeysLoader {
    public Vector keyDirectory;
    public Vector numericParameters;
    String asciiParameters;
    short majorRevision;
    short minorRevision;
    CRSBuilder logger;

    protected GeoKeysLoader() {
    }

    public final void setAsciiParameters(String[] values) {
        switch (values.length) {
            case 0: {
                break;
            }
            case 1: {
                this.asciiParameters = values[0];
                break;
            }
            default: {
                this.asciiParameters = String.join((CharSequence)"\u0000", values).concat("\u0000");
            }
        }
    }

    protected final boolean load(Map<Short, Object> geoKeys) {
        int numberOfKeys;
        int directoryLength = this.keyDirectory.size();
        if (directoryLength >= 4) {
            int version = this.keyDirectory.intValue(0);
            if (version != 1) {
                this.warning((short)20, version);
                return false;
            }
            this.majorRevision = this.keyDirectory.shortValue(1);
            this.minorRevision = this.keyDirectory.shortValue(2);
            numberOfKeys = this.keyDirectory.intValue(3);
        } else {
            numberOfKeys = 0;
        }
        int expectedLength = (numberOfKeys + 1) * 4;
        if (directoryLength < expectedLength) {
            this.warning((short)10, "GeoKeyDirectory", expectedLength, directoryLength);
            return false;
        }
        int numberOfDoubles = this.numericParameters != null ? this.numericParameters.size() : 0;
        int numberOfChars = this.asciiParameters != null ? this.asciiParameters.length() : 0;
        block18: for (int i = 1; i <= numberOfKeys; ++i) {
            Object value;
            int p = i * 4;
            short key = this.keyDirectory.shortValue(p);
            int tagLocation = this.keyDirectory.intValue(p + 1);
            int count = this.keyDirectory.intValue(p + 2);
            int valueOffset = this.keyDirectory.intValue(p + 3);
            if (valueOffset < 0 || count < 0) {
                this.missingValue(key);
                continue;
            }
            switch (tagLocation) {
                case 0: {
                    switch (count) {
                        case 0: {
                            continue block18;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            this.warning((short)16, GeoKeys.name(key), count);
                        }
                    }
                    value = valueOffset;
                    break;
                }
                case 34735: {
                    if (valueOffset + count > this.keyDirectory.size()) {
                        this.missingValue(key);
                        continue block18;
                    }
                    switch (count) {
                        case 0: {
                            continue block18;
                        }
                        case 1: {
                            value = this.keyDirectory.get(valueOffset);
                            break;
                        }
                        default: {
                            int[] array = new int[count];
                            for (int j = 0; j < count; ++j) {
                                array[j] = this.keyDirectory.intValue(valueOffset + j);
                            }
                            value = array;
                            break;
                        }
                    }
                    break;
                }
                case 34736: {
                    if (valueOffset + count > numberOfDoubles) {
                        this.missingValue(key);
                        continue block18;
                    }
                    switch (count) {
                        case 0: {
                            continue block18;
                        }
                        case 1: {
                            value = this.numericParameters.get(valueOffset);
                            break;
                        }
                        default: {
                            double[] array = new double[count];
                            for (int j = 0; j < count; ++j) {
                                array[j] = this.numericParameters.doubleValue(valueOffset + j);
                            }
                            value = array;
                            break;
                        }
                    }
                    break;
                }
                case 34737: {
                    int upper = valueOffset + count;
                    if (upper > numberOfChars) {
                        this.missingValue(key);
                        continue block18;
                    }
                    for (upper = CharSequences.skipTrailingWhitespaces((CharSequence)this.asciiParameters, (int)valueOffset, (int)upper); upper > valueOffset && this.asciiParameters.charAt(upper - 1) == '|'; --upper) {
                    }
                    String s = this.asciiParameters.substring(valueOffset, upper).trim();
                    if (s.isEmpty()) continue block18;
                    value = s;
                    break;
                }
                default: {
                    this.warning((short)21, GeoKeys.name(key));
                    continue block18;
                }
            }
            geoKeys.put(key, value);
        }
        return true;
    }

    private void warning(short key, Object ... args) {
        if (this.logger != null) {
            this.logger.warning(key, args);
        }
    }

    private void missingValue(short key) {
        if (this.logger != null) {
            this.logger.missingValue(key);
        }
    }
}

