/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.type;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.PprofStackElement;
import org.apache.skywalking.oap.server.library.pprof.type.FrameTree;

public class PprofStackTree {
    private List<PprofStackElement> elements;
    private int idGen = 0;

    public PprofStackTree(FrameTree tree) {
        this.elements = this.convertTree(-1, tree);
    }

    private List<PprofStackElement> convertTree(int parentId, FrameTree tree) {
        PprofStackElement pprofStackElement = new PprofStackElement();
        pprofStackElement.setId(this.idGen++);
        pprofStackElement.setParentId(parentId);
        pprofStackElement.setCodeSignature(tree.getSignature());
        pprofStackElement.setTotal(tree.getTotal());
        pprofStackElement.setSelf(tree.getSelf());
        List children = tree.getChildren();
        ArrayList result = Lists.newArrayList((Object[])new PprofStackElement[]{pprofStackElement});
        if (Objects.isNull(children) || children.isEmpty()) {
            return result;
        }
        for (FrameTree child : children) {
            List<PprofStackElement> childElements = this.convertTree(pprofStackElement.getId(), child);
            result.addAll(childElements);
        }
        return result;
    }

    @Generated
    public void setElements(List<PprofStackElement> elements) {
        this.elements = elements;
    }

    @Generated
    public void setIdGen(int idGen) {
        this.idGen = idGen;
    }

    @Generated
    public List<PprofStackElement> getElements() {
        return this.elements;
    }

    @Generated
    public int getIdGen() {
        return this.idGen;
    }

    @Generated
    public PprofStackTree() {
    }
}

