/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.aws.firehose;

import com.google.protobuf.InvalidProtocolBufferException;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Header;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import io.opentelemetry.proto.collector.metrics.firehose.v0_7.ExportMetricsServiceRequest;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.aws.firehose.FirehoseReq;
import org.apache.skywalking.oap.server.receiver.aws.firehose.FirehoseRes;
import org.apache.skywalking.oap.server.receiver.aws.firehose.OtelMetricsConvertor;
import org.apache.skywalking.oap.server.receiver.aws.firehose.RequestData;
import org.apache.skywalking.oap.server.receiver.otel.otlp.OpenTelemetryMetricRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirehoseHTTPHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirehoseHTTPHandler.class);
    private final OpenTelemetryMetricRequestProcessor openTelemetryMetricRequestProcessor;
    private final String firehoseAccessKey;

    @Post(value="/aws/firehose/metrics")
    @ConsumesJson
    @ProducesJson
    public HttpResponse collectMetrics(FirehoseReq firehoseReq, @Default @Header(value="X-Amz-Firehose-Access-Key") String accessKey) {
        if (StringUtil.isNotBlank((String)this.firehoseAccessKey) && !this.firehoseAccessKey.equals(accessKey)) {
            return HttpResponse.ofJson((HttpStatus)HttpStatus.UNAUTHORIZED, (Object)new FirehoseRes(firehoseReq.getRequestId(), System.currentTimeMillis(), "AccessKey incorrect, please check your config"));
        }
        try {
            for (RequestData record : firehoseReq.getRecords()) {
                ExportMetricsServiceRequest request;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(record.getData()));
                while ((request = ExportMetricsServiceRequest.parseDelimitedFrom(byteArrayInputStream)) != null) {
                    this.openTelemetryMetricRequestProcessor.processMetricsRequest(OtelMetricsConvertor.convertExportMetricsRequest(request));
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            log.warn("Only OpenTelemetry format is accepted", (Throwable)e);
            return HttpResponse.ofJson((HttpStatus)HttpStatus.BAD_REQUEST, (Object)new FirehoseRes(firehoseReq.getRequestId(), System.currentTimeMillis(), "Only OpenTelemetry format is accepted"));
        }
        catch (Exception e) {
            log.error("Server error", (Throwable)e);
            return HttpResponse.ofJson((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (Object)new FirehoseRes(firehoseReq.getRequestId(), System.currentTimeMillis(), "Server error, please check the OAP log"));
        }
        return HttpResponse.ofJson((HttpStatus)HttpStatus.OK, (Object)new FirehoseRes(firehoseReq.getRequestId(), System.currentTimeMillis(), null));
    }

    @Generated
    public FirehoseHTTPHandler(OpenTelemetryMetricRequestProcessor openTelemetryMetricRequestProcessor, String firehoseAccessKey) {
        this.openTelemetryMetricRequestProcessor = openTelemetryMetricRequestProcessor;
        this.firehoseAccessKey = firehoseAccessKey;
    }
}

