/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.TraceWrite;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBTrace;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBStreamInsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.trace.BanyanDBTraceInsertRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBRecordDAO
extends AbstractBanyanDBDAO
implements IRecordDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBRecordDAO.class);
    private final StorageBuilder<Record> storageBuilder;

    public BanyanDBRecordDAO(BanyanDBStorageClient client, StorageBuilder<Record> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public InsertRequest prepareBatchInsert(Model model, Record record) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(model);
        if (schema == null) {
            throw new IOException(model.getName() + " is not registered");
        }
        if (BanyanDB.TraceGroup.NONE != model.getBanyanDBModelExtension().getTraceGroup()) {
            TraceWrite traceWrite;
            if (record instanceof BanyanDBTrace) {
                if (record instanceof BanyanDBTrace.MergeTable) {
                    BanyanDBTrace.MergeTable mergeTable = (BanyanDBTrace.MergeTable)record;
                    MetadataRegistry.Schema mergeTableSchema = MetadataRegistry.INSTANCE.findRecordMetadata(mergeTable.getMergeTableName());
                    traceWrite = ((BanyanDBStorageClient)this.getClient()).createTraceWrite(schema.getMetadata().getGroup(), mergeTable.getMergeTableName());
                    try {
                        for (String tag : mergeTableSchema.getTags()) {
                            if (tag.equals(mergeTable.getMergeTraceIdColumnName())) {
                                traceWrite.tag(tag, TagAndValue.stringTagValue((String)mergeTable.getTraceIdColumnValue()));
                                continue;
                            }
                            if (tag.equals(mergeTable.getMergeTimestampColumnName())) {
                                traceWrite.tag(tag, TagAndValue.timestampTagValue((long)mergeTable.getTimestampColumnValue()));
                                continue;
                            }
                            if (tag.equals(mergeTable.getMergeSpanIdColumnName())) {
                                traceWrite.tag(tag, TagAndValue.stringTagValue((String)mergeTable.getSpanIdColumnValue()));
                                continue;
                            }
                            traceWrite.tag(tag, TagAndValue.nullTagValue());
                        }
                    }
                    catch (BanyanDBException e) {
                        log.error("fail to add tag", (Throwable)e);
                    }
                } else {
                    traceWrite = ((BanyanDBStorageClient)this.getClient()).createTraceWrite(schema.getMetadata().getGroup(), model.getName());
                    BanyanDBConverter.TraceToStorage convert2Storage = new BanyanDBConverter.TraceToStorage(schema, traceWrite);
                    this.storageBuilder.entity2Storage((StorageData)record, (Convert2Storage)convert2Storage);
                    traceWrite = (TraceWrite)convert2Storage.obtain();
                }
            } else {
                throw new IOException(model.getName() + " is a banyandb trace model, the record should implement " + BanyanDBTrace.class.getName());
            }
            traceWrite.span(((BanyanDBTrace)record).getSpanWrapper().toByteArray());
            return new BanyanDBTraceInsertRequest(traceWrite);
        }
        StreamWrite streamWrite = ((BanyanDBStorageClient)this.getClient()).createStreamWrite(schema.getMetadata().getGroup(), model.getName(), record.id().build());
        BanyanDBConverter.StreamToStorage convert2Storage = new BanyanDBConverter.StreamToStorage(schema, streamWrite);
        this.storageBuilder.entity2Storage((StorageData)record, (Convert2Storage)convert2Storage);
        return new BanyanDBStreamInsertRequest((StreamWrite)convert2Storage.obtain());
    }
}

