/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateUuidValidator
implements DocumentViewXmlValidator {
    protected static final String MESSAGE_DUPLICATE_UUID = "Found the same jcr:uuid value '%s' in '%s' and '%s'";
    private final ValidationMessageSeverity severity;
    private final WorkspaceFilter filter;
    private Map<String, String> uuidsAndPaths;

    public DuplicateUuidValidator(ValidationMessageSeverity severity, WorkspaceFilter filter) {
        this.severity = severity;
        this.filter = filter;
        this.uuidsAndPaths = new HashMap<String, String>();
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull DocViewNode2 node, @NotNull NodeContext nodeContext, boolean isRoot) {
        String duplicateUuidPath;
        Optional identifier = node.getIdentifier();
        if (identifier.isPresent() && this.filter.contains(nodeContext.getNodePath()) && (duplicateUuidPath = this.uuidsAndPaths.put((String)identifier.get(), nodeContext.getNodePath())) != null) {
            return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_DUPLICATE_UUID, identifier.get(), duplicateUuidPath, nodeContext.getNodePath())));
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> done() {
        return null;
    }
}

