/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.AllocateDirect;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.DirectNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.DirectWritableBufferImpl;
import org.apache.datasketches.memory.internal.DirectWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.Util;

final class DirectNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private final AllocateDirect direct;

    DirectNonNativeWritableMemoryImpl(AllocateDirect direct, long offsetBytes, long capacityBytes, int typeId, long cumOffsetBytes, MemoryRequestServer memReqSvr) {
        this.direct = direct;
        this.offsetBytes = offsetBytes;
        this.capacityBytes = capacityBytes;
        this.typeId = DirectNonNativeWritableMemoryImpl.removeNnBuf(typeId) | 8 | 0 | 0x20;
        this.cumOffsetBytes = cumOffsetBytes;
        this.memReqSvr = memReqSvr;
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException("Attempted access outside owning thread");
        }
        this.owner = Thread.currentThread();
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long regionOffsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        long newOffsetBytes = this.offsetBytes + regionOffsetBytes;
        long newCumOffsetBytes = this.cumOffsetBytes + regionOffsetBytes;
        int typeIdOut = DirectNonNativeWritableMemoryImpl.removeNnBuf(this.typeId) | 0 | 2 | (readOnly ? 1 : 0);
        if (Util.isNativeByteOrder(byteOrder)) {
            return new DirectWritableMemoryImpl(this.direct, newOffsetBytes, capacityBytes, typeIdOut |= 0, newCumOffsetBytes, this.memReqSvr);
        }
        return new DirectNonNativeWritableMemoryImpl(this.direct, newOffsetBytes, capacityBytes, typeIdOut |= 0x20, newCumOffsetBytes, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = DirectNonNativeWritableMemoryImpl.removeNnBuf(this.typeId) | 0x40 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new DirectWritableBufferImpl(this.direct, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr);
        }
        return new DirectNonNativeWritableBufferImpl(this.direct, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr);
    }

    @Override
    public void close() {
        this.checkValid();
        DirectNonNativeWritableMemoryImpl.checkThread(this.owner);
        this.direct.close();
    }

    @Override
    Object getUnsafeObject() {
        return null;
    }

    @Override
    public boolean isAlive() {
        return this.direct.getValid().get();
    }
}

