/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.MapZipWith$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n      _FUNC_(map1, map2, function) - Merges two given maps into a single map by applying\n      function to the pair of values with the same key. For keys only presented in one map,\n      NULL will be passed as the value for the missing key. If an input map contains duplicated\n      keys, only the first entry of the duplicated key is passed into the lambda function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), map(1, 'x', 2, 'y'), (k, v1, v2) -> concat(v1, v2));\n       {1:\"ax\",2:\"by\"}\n      > SELECT _FUNC_(map('a', 1, 'b', 2), map('b', 3, 'c', 4), (k, v1, v2) -> coalesce(v1, 0) + coalesce(v2, 0));\n       {\"a\":1,\"b\":5,\"c\":4}\n  ", since="3.0.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0005\r-b\u0001\u0002\u001f>\u0001*C\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\te\u0002\u0011\t\u0012)A\u0005\u0017\"A1\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005u\u0001\tE\t\u0015!\u0003L\u0011!)\bA!f\u0001\n\u0003\t\b\u0002\u0003<\u0001\u0005#\u0005\u000b\u0011B&\t\u000b]\u0004A\u0011\u0001=\t\u000bu\u0004A\u0011A9\t\u0015y\u0004\u0001\u0013!EDB\u0013%q\u0010\u0003\u0006\u0002\u001a\u0001A)\u0019!C\u0001\u00037A!\"!\n\u0001\u0011\u000b\u0007I\u0011AA\u000e\u0011)\tI\u0003\u0001EC\u0002\u0013\u0005\u00111\u0006\u0005\f\u0003_\u0001\u0001\u0013!EDB\u0013%q\u0010\u0003\u0006\u00022\u0001A)\u0019!C\u0001\u00037A!\"!\u000e\u0001\u0011\u000b\u0007I\u0011AA\u000e\u0011)\tI\u0004\u0001EC\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003{\u0001\u0001R1A\u0005\u0002\u0005m\u0001BCA!\u0001!\u0015\r\u0011\"\u0001\u0002D!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA/\u0001\u0011\u0005\u0013q\f\u0005\b\u0003S\u0002A\u0011IA+\u0011\u001d\tY\u0007\u0001C!\u0003?Bq!!\u001c\u0001\t\u0003\nY\u0002C\u0004\u0002p\u0001!\t&!\u001d\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u00111\u0014\u0001\u0005B\u00055\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\r\u0003[\u0003\u0001\u0013!EDB\u0013%\u0011q\u0016\u0005\u000b\u0003s\u0003\u0001R1A\u0005\u0002\u0005m\u0006BCA`\u0001!\u0015\r\u0011\"\u0001\u0002<\"Q\u00111\u0019\u0001\t\u0006\u0004%\t!a/\t\u0015\u0005\u001d\u0007\u0001#b\u0001\n\u0013\tI\rC\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005{\u0001A\u0011\tB \u0011\u0019\u0011\t\u0006\u0001C!c\"1!1\u000b\u0001\u0005BEDaA!\u0016\u0001\t\u0003\n\bb\u0002B,\u0001\u0011E#\u0011\f\u0005\n\u0005O\u0002\u0011\u0011!C\u0001\u0005SB\u0011B!\u001d\u0001#\u0003%\tAa\u001d\t\u0013\t%\u0005!%A\u0005\u0002\tM\u0004\"\u0003BF\u0001E\u0005I\u0011\u0001B:\u0011%\u0011i\tAA\u0001\n\u0003\u0012y\tC\u0005\u0003 \u0002\t\t\u0011\"\u0001\u0003\"\"I!1\u0015\u0001\u0002\u0002\u0013\u0005!Q\u0015\u0005\n\u0005W\u0003\u0011\u0011!C!\u0005[C\u0011Ba.\u0001\u0003\u0003%\tA!/\t\u0013\tu\u0006!!A\u0005B\t}\u0006\"\u0003Bb\u0001\u0005\u0005I\u0011\tBc\u000f%\u0011I/PA\u0001\u0012\u0003\u0011YO\u0002\u0005={\u0005\u0005\t\u0012\u0001Bw\u0011\u00199h\u0007\"\u0001\u0004\u0006!I1q\u0001\u001c\u0002\u0002\u0013\u00153\u0011\u0002\u0005\n\u0007\u00171\u0014\u0011!CA\u0007\u001bA\u0011b!\u00067\u0003\u0003%\tia\u0006\t\u0013\r\u0005b'!A\u0005\n\r\r\"AC'bajK\u0007oV5uQ*\u0011ahP\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002A\u0003\u0006A1-\u0019;bYf\u001cHO\u0003\u0002C\u0007\u0006\u00191/\u001d7\u000b\u0005\u0011+\u0015!B:qCJ\\'B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001e\u001c\u0001aE\u0004\u0001\u0017>\u0013\u0006L\u00183\u0011\u00051kU\"A\u001f\n\u00059k$AC#yaJ,7o]5p]B\u0011A\nU\u0005\u0003#v\u00121\u0003S5hQ\u0016\u0014xJ\u001d3fe\u001a+hn\u0019;j_:\u0004\"a\u0015,\u000e\u0003QS!!V\u001f\u0002\u000f\r|G-Z4f]&\u0011q\u000b\u0016\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0019\u0011\fX&\u000e\u0003iS!aW \u0002\u000bQ\u0014X-Z:\n\u0005uS&a\u0003+fe:\f'/\u001f'jW\u0016\u0004\"a\u00182\u000e\u0003\u0001T\u0011!Y\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0002\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002f[:\u0011am\u001b\b\u0003O*l\u0011\u0001\u001b\u0006\u0003S&\u000ba\u0001\u0010:p_Rt\u0014\"A1\n\u00051\u0004\u0017a\u00029bG.\fw-Z\u0005\u0003]>\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u001c1\u0002\t1,g\r^\u000b\u0002\u0017\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\n\u0001BZ;oGRLwN\\\u0001\nMVt7\r^5p]\u0002\na\u0001P5oSRtD\u0003B={wr\u0004\"\u0001\u0014\u0001\t\u000bA<\u0001\u0019A&\t\u000bM<\u0001\u0019A&\t\u000bU<\u0001\u0019A&\u0002\u001f\u0019,hn\u0019;j_:4uN]#wC2\fA\u0001\u001f\u00133oU\u0011\u0011\u0011\u0001\t\n?\u0006\r\u0011qAA\u0004\u0003'I1!!\u0002a\u0005\u0019!V\u000f\u001d7fgA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0005\u000bQ\u0001^=qKNLA!!\u0005\u0002\f\tAA)\u0019;b)f\u0004X\rE\u0002`\u0003+I1!a\u0006a\u0005\u001d\u0011un\u001c7fC:\f1\u0002\\3gi.+\u0017\u0010V=qKV\u0011\u0011q\u0001\u0015\u0004\u0015\u0005}\u0001cA0\u0002\"%\u0019\u00111\u00051\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!\u00047fMR4\u0016\r\\;f)f\u0004X\rK\u0002\f\u0003?\tQ\u0003\\3giZ\u000bG.^3D_:$\u0018-\u001b8t\u001dVdG.\u0006\u0002\u0002\u0014!\u001aA\"a\b\u0002\ta$#\u0007O\u0001\re&<\u0007\u000e^&fsRK\b/\u001a\u0015\u0004\u001d\u0005}\u0011A\u0004:jO\"$h+\u00197vKRK\b/\u001a\u0015\u0004\u001f\u0005}\u0011A\u0006:jO\"$h+\u00197vK\u000e{g\u000e^1j]NtU\u000f\u001c7)\u0007A\ty\"A\u0004lKf$\u0016\u0010]3)\u0007E\ty\"\u0001\u0005pe\u0012,'/\u001b8h+\t\t)\u0005E\u0003f\u0003\u000f\nY%C\u0002\u0002J=\u0014\u0001b\u0014:eKJLgn\u001a\t\u0004?\u00065\u0013bAA(A\n\u0019\u0011I\\=)\u0007I\ty\"A\u0005be\u001e,X.\u001a8ugV\u0011\u0011q\u000b\t\u0005K\u0006e3*C\u0002\u0002\\=\u00141aU3r\u00035\t'oZ;nK:$H+\u001f9fgV\u0011\u0011\u0011\r\t\u0006K\u0006e\u00131\r\t\u0005\u0003\u0013\t)'\u0003\u0003\u0002h\u0005-!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003%1WO\\2uS>t7/A\u0007gk:\u001cG/[8o)f\u0004Xm]\u0001\tI\u0006$\u0018\rV=qK\u0006a!-\u001b8e\u0013:$XM\u001d8bYR\u0019\u00110a\u001d\t\u000f\u0005U\u0004\u00041\u0001\u0002x\u0005\ta\r\u0005\u0005`\u0003sZ\u0015QPAC\u0013\r\tY\b\u0019\u0002\n\rVt7\r^5p]J\u0002R!ZA-\u0003\u007f\u0002raXAA\u0003\u000f\t\u0019\"C\u0002\u0002\u0004\u0002\u0014a\u0001V;qY\u0016\u0014\u0004c\u0001'\u0002\b&\u0019\u0011\u0011R\u001f\u0003\u001d1\u000bWN\u00193b\rVt7\r^5p]\u000612\r[3dW\u0006\u0013x-^7f]R$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016~\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u00033\u000b\u0019JA\bUsB,7\t[3dWJ+7/\u001e7u\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t\u0003\u0011)g/\u00197\u0015\t\u0005-\u0013\u0011\u0015\u0005\n\u0003G[\u0002\u0013!a\u0001\u0003K\u000bQ!\u001b8qkR\u0004B!a*\u0002*6\tq(C\u0002\u0002,~\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006!\u0001\u0010\n\u001a:+\t\t\t\fE\u0005`\u0003\u0007\t\u0019,a-\u00024B\u0019A*!.\n\u0007\u0005]VHA\nOC6,G\rT1nE\u0012\fg+\u0019:jC\ndW-\u0001\u0004lKf4\u0016M]\u000b\u0003\u0003gC3!HA\u0010\u0003%1\u0018\r\\;fcY\u000b'\u000fK\u0002\u001f\u0003?\t\u0011B^1mk\u0016\u0014d+\u0019:)\u0007}\ty\"A\fhKR\\U-_:XSRDg+\u00197vK&sG-\u001a=fgV\u0011\u00111\u001a\t\n?\u0006e\u0014QZAg\u00033\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'|\u0014\u0001B;uS2LA!a6\u0002R\nI\u0011I\u001d:bs\u0012\u000bG/\u0019\t\u0007\u00037\f)/!;\u000e\u0005\u0005u'\u0002BAp\u0003C\fq!\\;uC\ndWMC\u0002\u0002d\u0002\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9/!8\u0003\u0011%#XM]1cY\u0016\u0004raXAA\u0003\u0017\nY\u000fE\u0003`\u0003[\f\t0C\u0002\u0002p\u0002\u0014Q!\u0011:sCf\u0004RaXAz\u0003oL1!!>a\u0005\u0019y\u0005\u000f^5p]B\u0019q,!?\n\u0007\u0005m\bMA\u0002J]RD3\u0001IA\u0010\u0003]\t7o]3siNK'0Z(g\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0006\u0003\u0003\u0004\t%\u0001cA0\u0003\u0006%\u0019!q\u00011\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u0017\t\u0003\u0019AA|\u0003\u0011\u0019\u0018N_3\u0002-\u001d,GoS3zg^KG\u000f[%oI\u0016DXm\u001d$bgR$bA!\u0005\u0003\u0018\tm\u0001\u0003CAn\u0005'\tY%a;\n\t\tU\u0011Q\u001c\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\t\u000f\te!\u00051\u0001\u0002N\u0006)1.Z=tc!9!Q\u0004\u0012A\u0002\u00055\u0017!B6fsN\u0014\u0014\u0001H4fi.+\u0017p],ji\"Le\u000eZ3yKN\u0014%/\u001e;f\r>\u00148-\u001a\u000b\u0007\u0005G\u0011ICa\u000b\u0011\r\u0005m'QEAu\u0013\u0011\u00119#!8\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u00053\u0019\u0003\u0019AAg\u0011\u001d\u0011ib\ta\u0001\u0003\u001b\fAB\\;mYN\u000bg-Z#wC2$\u0002\"a\u0013\u00032\tU\"\u0011\b\u0005\b\u0005g!\u0003\u0019AAS\u0003!Ig\u000e];u%><\bb\u0002B\u001cI\u0001\u0007\u00111J\u0001\u0007m\u0006dW/Z\u0019\t\u000f\tmB\u00051\u0001\u0002L\u00051a/\u00197vKJ\n\u0001B\\8eK:\u000bW.Z\u000b\u0003\u0005\u0003\u0002BAa\u0011\u0003L9!!Q\tB$!\t9\u0007-C\u0002\u0003J\u0001\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B'\u0005\u001f\u0012aa\u0015;sS:<'b\u0001B%A\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000fe\u0014YFa\u0018\u0003d!1!QL\u0015A\u0002-\u000b\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0007\u0005CJ\u0003\u0019A&\u0002\u00139,woU3d_:$\u0007B\u0002B3S\u0001\u00071*\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u000fe\u0014YG!\u001c\u0003p!9\u0001O\u000bI\u0001\u0002\u0004Y\u0005bB:+!\u0003\u0005\ra\u0013\u0005\bk*\u0002\n\u00111\u0001L\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u001e+\u0007-\u00139h\u000b\u0002\u0003zA!!1\u0010BC\u001b\t\u0011iH\u0003\u0003\u0003\u0000\t\u0005\u0015!C;oG\",7m[3e\u0015\r\u0011\u0019\tY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BD\u0005{\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005#\u0003BAa%\u0003\u001e6\u0011!Q\u0013\u0006\u0005\u0005/\u0013I*\u0001\u0003mC:<'B\u0001BN\u0003\u0011Q\u0017M^1\n\t\t5#QS\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003o\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002L\t\u001d\u0006\"\u0003BUa\u0005\u0005\t\u0019AA|\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0016\t\u0007\u0005c\u0013\u0019,a\u0013\u000e\u0005\u0005\u0005\u0018\u0002\u0002B[\u0003C\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\u0003B^\u0011%\u0011IKMA\u0001\u0002\u0004\tY%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002BI\u0005\u0003D\u0011B!+4\u0003\u0003\u0005\r!a>\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019Ba2\t\u0013\t%F'!AA\u0002\u0005-\u0003f\u0005\u0001\u0003L\nE'1\u001bBl\u00053\u0014iNa8\u0003d\n\u0015\bc\u0001'\u0003N&\u0019!qZ\u001f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!Q[\u0001\u0003l*\u0001\u0003\u0005\t\u0011!A}3UKT\"`Q5\f\u0007/\r\u0017![\u0006\u0004(\u0007\f\u0011gk:\u001cG/[8oS\u0001j\u0003%T3sO\u0016\u001c\b\u0005^<pA\u001dLg/\u001a8![\u0006\u00048\u000fI5oi>\u0004\u0013\rI:j]\u001edW\rI7ba\u0002\u0012\u0017\u0010I1qa2L\u0018N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011gk:\u001cG/[8oAQ|\u0007\u0005\u001e5fAA\f\u0017N\u001d\u0011pM\u00022\u0018\r\\;fg\u0002:\u0018\u000e\u001e5!i\",\u0007e]1nK\u0002ZW-\u001f\u0018!\r>\u0014\be[3zg\u0002zg\u000e\\=!aJ,7/\u001a8uK\u0012\u0004\u0013N\u001c\u0011p]\u0016\u0004S.\u00199-\u0015\u0001\u0002\u0003\u0005\t\u0011!\u001dVcE\nI<jY2\u0004#-\u001a\u0011qCN\u001cX\r\u001a\u0011bg\u0002\"\b.\u001a\u0011wC2,X\r\t4pe\u0002\"\b.\u001a\u0011nSN\u001c\u0018N\\4!W\u0016Lh\u0006I%gA\u0005t\u0007%\u001b8qkR\u0004S.\u00199!G>tG/Y5og\u0002\"W\u000f\u001d7jG\u0006$X\r\u001a\u0006!A\u0001\u0002\u0003\u0005I6fsNd\u0003e\u001c8ms\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI3oiJL\be\u001c4!i\",\u0007\u0005Z;qY&\u001c\u0017\r^3eA-,\u0017\u0010I5tAA\f7o]3eA%tGo\u001c\u0011uQ\u0016\u0004C.Y7cI\u0006\u0004c-\u001e8di&|gN\f\u0006!A\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tm\u0017A!\f\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\f\u0007\u000fK\u0019-A\u001d\nw\u0005\f\u00113Y\u0001:#mJ\u0015-A5\f\u0007\u000fK\u0019-A\u001dBx\u0005\f\u00113Y\u0001:\u0013pJ\u0015-A!ZG\u0006\t<2Y\u00012('\u000b\u0011.}\u0001\u001awN\\2bi\"2\u0018\u0007\f\u0011we%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>2u\t\n\u0007P\t\u00173u\t\u0012\u0017PI?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\f\u0007\u000fK\u0014bO1\u0002\u0013\u0007\f\u0011(E\u001eb\u0003EM\u0015-A5\f\u0007\u000fK\u0014cO1\u00023\u0007\f\u0011(G\u001eb\u0003\u0005N\u0015-A!ZG\u0006\t<2Y\u00012('\u000b\u0011.}\u0001\u001aw.\u00197fg\u000e,\u0007F^\u0019-AAJ\u0003e\u000b\u0011d_\u0006dWm]2fQY\u0014D\u0006\t\u0019*SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#uEb#E\u0019\u0012;k1\u00123M\t\u001e5{*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003b\u0006)1G\f\u0019/a\u0005)qM]8va\u0006\u0012!q]\u0001\rY\u0006l'\rZ1`MVt7m]\u0001\u000b\u001b\u0006\u0004(,\u001b9XSRD\u0007C\u0001'7'\u00151$q\u001eB~!!\u0011\tPa>L\u0017.KXB\u0001Bz\u0015\r\u0011)\u0010Y\u0001\beVtG/[7f\u0013\u0011\u0011IPa=\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003~\u000e\rQB\u0001B\u0000\u0015\u0011\u0019\tA!'\u0002\u0005%|\u0017b\u00018\u0003\u0000R\u0011!1^\u0001\ti>\u001cFO]5oOR\u0011!\u0011S\u0001\u0006CB\u0004H.\u001f\u000b\bs\u000e=1\u0011CB\n\u0011\u0015\u0001\u0018\b1\u0001L\u0011\u0015\u0019\u0018\b1\u0001L\u0011\u0015)\u0018\b1\u0001L\u0003\u001d)h.\u00199qYf$Ba!\u0007\u0004\u001eA)q,a=\u0004\u001cA1q,a\u0001L\u0017.C\u0001ba\b;\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAB\u0013!\u0011\u0011\u0019ja\n\n\t\r%\"Q\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class MapZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
TernaryLike<Expression>,
Serializable {
    private Tuple3<DataType, DataType, Object> x$27;
    private transient DataType leftKeyType;
    private transient DataType leftValueType;
    private transient boolean leftValueContainsNull;
    private Tuple3<DataType, DataType, Object> x$28;
    private transient DataType rightKeyType;
    private transient DataType rightValueType;
    private transient boolean rightValueContainsNull;
    private transient DataType keyType;
    private transient Ordering<Object> ordering;
    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$29;
    private transient NamedLambdaVariable keyVar;
    private transient NamedLambdaVariable value1Var;
    private transient NamedLambdaVariable value2Var;
    private transient Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes;
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient int bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(MapZipWith x$0) {
        return MapZipWith$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, MapZipWith> tupled() {
        return MapZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, MapZipWith>>> curried() {
        return MapZipWith$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    @Override
    public final HigherOrderFunction bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        return HigherOrderFunction.bind$(this, f);
    }

    private Seq<Expression> children$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x1000) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 |= 0x1000;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((this.bitmap$trans$0 & 0x1000) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.argumentsResolved$lzycompute();
        }
        return this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x2000) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 |= 0x2000;
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        if ((this.bitmap$trans$0 & 0x2000) == 0) {
            return this.functionsForEval$lzycompute();
        }
        return this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    private Tuple3<DataType, DataType, Object> x$27$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType = this.left().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                boolean leftValueContainsNull = mapType.valueContainsNull();
                this.x$27 = new Tuple3((Object)leftKeyType, (Object)leftValueType, (Object)BoxesRunTime.boxToBoolean((boolean)leftValueContainsNull));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$27;
    }

    private /* synthetic */ Tuple3 x$27() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$27$lzycompute();
        }
        return this.x$27;
    }

    private DataType leftKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.leftKeyType = (DataType)this.x$27()._1();
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.leftKeyType;
    }

    public DataType leftKeyType() {
        if ((this.bitmap$trans$0 & 1) == 0) {
            return this.leftKeyType$lzycompute();
        }
        return this.leftKeyType;
    }

    private DataType leftValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.leftValueType = (DataType)this.x$27()._2();
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.leftValueType;
    }

    public DataType leftValueType() {
        if ((this.bitmap$trans$0 & 2) == 0) {
            return this.leftValueType$lzycompute();
        }
        return this.leftValueType;
    }

    private boolean leftValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.leftValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$27()._3());
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.leftValueContainsNull;
    }

    public boolean leftValueContainsNull() {
        if ((this.bitmap$trans$0 & 4) == 0) {
            return this.leftValueContainsNull$lzycompute();
        }
        return this.leftValueContainsNull;
    }

    private Tuple3<DataType, DataType, Object> x$28$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DataType dataType = this.right().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType rightKeyType = mapType.keyType();
                DataType rightValueType = mapType.valueType();
                boolean rightValueContainsNull = mapType.valueContainsNull();
                this.x$28 = new Tuple3((Object)rightKeyType, (Object)rightValueType, (Object)BoxesRunTime.boxToBoolean((boolean)rightValueContainsNull));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$28;
    }

    private /* synthetic */ Tuple3 x$28() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.x$28$lzycompute();
        }
        return this.x$28;
    }

    private DataType rightKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.rightKeyType = (DataType)this.x$28()._1();
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.rightKeyType;
    }

    public DataType rightKeyType() {
        if ((this.bitmap$trans$0 & 8) == 0) {
            return this.rightKeyType$lzycompute();
        }
        return this.rightKeyType;
    }

    private DataType rightValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.rightValueType = (DataType)this.x$28()._2();
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.rightValueType;
    }

    public DataType rightValueType() {
        if ((this.bitmap$trans$0 & 0x10) == 0) {
            return this.rightValueType$lzycompute();
        }
        return this.rightValueType;
    }

    private boolean rightValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.rightValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$28()._3());
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.rightValueContainsNull;
    }

    public boolean rightValueContainsNull() {
        if ((this.bitmap$trans$0 & 0x20) == 0) {
            return this.rightValueContainsNull$lzycompute();
        }
        return this.rightValueContainsNull;
    }

    private DataType keyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.keyType = (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags(this.leftKeyType(), this.rightKeyType()).get();
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.keyType;
    }

    public DataType keyType() {
        if ((this.bitmap$trans$0 & 0x40) == 0) {
            return this.keyType$lzycompute();
        }
        return this.keyType;
    }

    private Ordering<Object> ordering$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.keyType());
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.ordering;
    }

    public Ordering<Object> ordering() {
        if ((this.bitmap$trans$0 & 0x80) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        MapType$ mapType$ = MapType$.MODULE$;
        MapType$ mapType$2 = MapType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)mapType$2).$colon$colon((Object)mapType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.function();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$);
    }

    @Override
    public DataType dataType() {
        return new MapType(this.keyType(), this.function().dataType(), this.function().nullable());
    }

    @Override
    public MapZipWith bindInternal(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        .colon.colon arguments = new .colon.colon((Object)new Tuple2((Object)this.keyType(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)this.leftValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)this.rightValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)arguments);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        TypeCheckResult typeCheckResult = HigherOrderFunction.checkArgumentDataTypes$(this);
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            if (DataTypeUtils$.MODULE$.sameType(this.leftKeyType(), this.rightKeyType())) {
                return TypeUtils$.MODULE$.checkForOrderingExpr(this.leftKeyType(), this.prettyName());
            }
            return new TypeCheckResult.DataTypeMismatch("MAP_ZIP_WITH_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)Cast$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.leftKeyType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.rightKeyType()))}))));
        }
        return typeCheckResult;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.checkArgumentDataTypes();
    }

    @Override
    public Object eval(InternalRow input) {
        Object value1 = this.left().eval(input);
        if (value1 == null) {
            return null;
        }
        Object value2 = this.right().eval(input);
        if (value2 == null) {
            return null;
        }
        return this.nullSafeEval(input, value1, value2);
    }

    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$29$lzycompute() {
        block5: {
            MapZipWith mapZipWith = this;
            synchronized (mapZipWith) {
                NamedLambdaVariable namedLambdaVariable;
                NamedLambdaVariable namedLambdaVariable2;
                NamedExpression value2Var;
                block7: {
                    Expression expression;
                    block6: {
                        SeqOps seqOps;
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        if ((byte)(this.bitmap$0 & 4) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (seq = (lambdaFunction = (LambdaFunction)expression).arguments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) break block6;
                        NamedExpression keyVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        NamedExpression value1Var = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        value2Var = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                        if (!(keyVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable2 = (NamedLambdaVariable)keyVar;
                        if (!(value1Var instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)value1Var;
                        if (value2Var instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable3 = (NamedLambdaVariable)value2Var;
                this.x$29 = new Tuple3((Object)namedLambdaVariable2, (Object)namedLambdaVariable, (Object)namedLambdaVariable3);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$29;
    }

    private /* synthetic */ Tuple3 x$29() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.x$29$lzycompute();
        }
        return this.x$29;
    }

    private NamedLambdaVariable keyVar$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.keyVar = (NamedLambdaVariable)this.x$29()._1();
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.keyVar;
    }

    public NamedLambdaVariable keyVar() {
        if ((this.bitmap$trans$0 & 0x100) == 0) {
            return this.keyVar$lzycompute();
        }
        return this.keyVar;
    }

    private NamedLambdaVariable value1Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x200) == 0) {
                this.value1Var = (NamedLambdaVariable)this.x$29()._2();
                this.bitmap$trans$0 |= 0x200;
            }
        }
        return this.value1Var;
    }

    public NamedLambdaVariable value1Var() {
        if ((this.bitmap$trans$0 & 0x200) == 0) {
            return this.value1Var$lzycompute();
        }
        return this.value1Var;
    }

    private NamedLambdaVariable value2Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x400) == 0) {
                this.value2Var = (NamedLambdaVariable)this.x$29()._3();
                this.bitmap$trans$0 |= 0x400;
            }
        }
        return this.value2Var;
    }

    public NamedLambdaVariable value2Var() {
        if ((this.bitmap$trans$0 & 0x400) == 0) {
            return this.value2Var$lzycompute();
        }
        return this.value2Var;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x800) == 0) {
                this.getKeysWithValueIndexes = TypeUtils$.MODULE$.typeWithProperEquals(this.keyType()) ? (Function2 & Serializable)(keys1, keys2) -> this.getKeysWithIndexesFast((ArrayData)keys1, (ArrayData)keys2) : (Function2 & Serializable)(keys1, keys2) -> this.getKeysWithIndexesBruteForce((ArrayData)keys1, (ArrayData)keys2);
                this.bitmap$trans$0 |= 0x800;
            }
        }
        return this.getKeysWithValueIndexes;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes() {
        if ((this.bitmap$trans$0 & 0x800) == 0) {
            return this.getKeysWithValueIndexes$lzycompute();
        }
        return this.getKeysWithValueIndexes;
    }

    private void assertSizeOfArrayBuffer(int size) {
        if (size > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.mapSizeExceedArraySizeWhenZipMapError(size);
        }
    }

    private LinkedHashMap<Object, Option<Object>[]> getKeysWithIndexesFast(ArrayData keys1, ArrayData keys2) {
        LinkedHashMap hashMap = new LinkedHashMap();
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)}), (Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesFast$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$30 -> {
            MapZipWith.$anonfun$getKeysWithIndexesFast$2(this, hashMap, x$30);
            return BoxedUnit.UNIT;
        });
        return hashMap;
    }

    private ArrayBuffer<Tuple2<Object, Option<Object>[]>> getKeysWithIndexesBruteForce(ArrayData keys1, ArrayData keys2) {
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)}), (Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesBruteForce$1(check$ifrefutable$2))).foreach((Function1 & Serializable)x$32 -> {
            MapZipWith.$anonfun$getKeysWithIndexesBruteForce$2(this, arrayBuffer, x$32);
            return BoxedUnit.UNIT;
        });
        return arrayBuffer;
    }

    private Object nullSafeEval(InternalRow inputRow, Object value1, Object value2) {
        MapData mapData1 = (MapData)value1;
        MapData mapData2 = (MapData)value2;
        Iterable keysWithIndexes = (Iterable)this.getKeysWithValueIndexes().apply((Object)mapData1.keyArray(), (Object)mapData2.keyArray());
        int size = keysWithIndexes.size();
        GenericArrayData keys = new GenericArrayData(new Object[size]);
        GenericArrayData values = new GenericArrayData(new Object[size]);
        ArrayData valueData1 = mapData1.valueArray();
        ArrayData valueData2 = mapData2.valueArray();
        IntRef i = IntRef.create((int)0);
        keysWithIndexes.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$nullSafeEval$2(check$ifrefutable$3))).foreach((Function1 & Serializable)x$35 -> {
            MapZipWith.$anonfun$nullSafeEval$3(this, valueData1, valueData2, keys, i, inputRow, values, x$35);
            return BoxedUnit.UNIT;
        });
        return new ArrayBasedMapData(keys, values);
    }

    @Override
    public String nodeName() {
        return "map_zip_with";
    }

    @Override
    public Expression first() {
        return this.left();
    }

    @Override
    public Expression second() {
        return this.right();
    }

    @Override
    public Expression third() {
        return this.function();
    }

    @Override
    public MapZipWith withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public MapZipWith copy(Expression left, Expression right, Expression function) {
        return new MapZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "MapZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.function();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapZipWith;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "function";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapZipWith mapZipWith = (MapZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = mapZipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapZipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = mapZipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!mapZipWith.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesFast$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesFast$2(MapZipWith $this, LinkedHashMap hashMap$1, Tuple2 x$30) {
        Tuple2 tuple2 = x$30;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                Object key = array.get(i, $this.keyType());
                Option option = hashMap$1.get(key);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Option[] indexes = (Option[])some.value();
                    if (indexes[z].isEmpty()) {
                        indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    }
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    hashMap$1.put(key, (Object)indexes);
                    continue;
                }
                throw new MatchError((Object)option);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesBruteForce$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesBruteForce$2(MapZipWith $this, ArrayBuffer arrayBuffer$1, Tuple2 x$32) {
        Tuple2 tuple2 = x$32;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                boolean found = false;
                for (int j = 0; !found && j < arrayBuffer$1.size(); ++j) {
                    Tuple2 tuple22 = (Tuple2)arrayBuffer$1.apply(j);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object bufferKey = tuple22._1();
                    Option[] indexes = (Option[])tuple22._2();
                    Tuple2 tuple23 = new Tuple2(bufferKey, (Object)indexes);
                    Object bufferKey2 = tuple23._1();
                    Option[] indexes2 = (Option[])tuple23._2();
                    if (!$this.ordering().equiv(bufferKey2, key)) continue;
                    found = true;
                    if (!indexes2[z].isEmpty()) continue;
                    indexes2[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                }
                if (!found) {
                    $this.assertSizeOfArrayBuffer(arrayBuffer$1.size());
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = arrayBuffer$1.$plus$eq((Object)new Tuple2(key, (Object)indexes));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeEval$2(Tuple2 check$ifrefutable$3) {
        Object object;
        Option[] optionArray;
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null && (optionArray = (Option[])tuple2._2()) != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)optionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$3(MapZipWith $this, ArrayData valueData1$1, ArrayData valueData2$1, GenericArrayData keys$1, IntRef i$1, InternalRow inputRow$3, GenericArrayData values$1, Tuple2 x$35) {
        Tuple2 tuple2 = x$35;
        if (tuple2 != null) {
            Object object;
            Object key = tuple2._1();
            Option[] optionArray = (Option[])tuple2._2();
            if (optionArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)optionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                Option index1 = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                Option index2 = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                Object v1 = index1.map((Function1 & Serializable)x$33 -> valueData1$1.get(BoxesRunTime.unboxToInt((Object)x$33), $this.leftValueType())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Object v2 = index2.map((Function1 & Serializable)x$34 -> valueData2$1.get(BoxesRunTime.unboxToInt((Object)x$34), $this.rightValueType())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                $this.keyVar().value().set(key);
                $this.value1Var().value().set(v1);
                $this.value2Var().value().set(v2);
                keys$1.update(i$1.elem, key);
                Object v = InternalRow$.MODULE$.copyValue($this.functionForEval().eval(inputRow$3));
                values$1.update(i$1.elem, v);
                ++i$1.elem;
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public MapZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        TernaryLike.$init$(this);
        Statics.releaseFence();
    }
}

