/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.spark.deploy.master.FileSystemPersistenceEngine$;
import org.apache.spark.deploy.master.PersistenceEngine;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd!B\t\u0013\u0001Ia\u0002\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011A\u0015\t\u0011]\u0002!\u0011!Q\u0001\n)B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u00159\u0007\u0001\"\u0011i\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+Aq!a\f\u0001\t\u0013\t\td\u0002\u0006\u0002DI\t\t\u0011#\u0001\u0013\u0003\u000b2\u0011\"\u0005\n\u0002\u0002#\u0005!#a\u0012\t\r5sA\u0011AA%\u0011%\tYEDI\u0001\n\u0003\tiEA\u000eGS2,7+_:uK6\u0004VM]:jgR,gnY3F]\u001eLg.\u001a\u0006\u0003'Q\ta!\\1ti\u0016\u0014(BA\u000b\u0017\u0003\u0019!W\r\u001d7ps*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xmE\u0002\u0001;\u0005\u0002\"AH\u0010\u000e\u0003II!\u0001\t\n\u0003#A+'o]5ti\u0016t7-Z#oO&tW\r\u0005\u0002#K5\t1E\u0003\u0002%-\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002'G\t9Aj\\4hS:<\u0017a\u00013je\u000e\u0001Q#\u0001\u0016\u0011\u0005-\"dB\u0001\u00173!\ti\u0003'D\u0001/\u0015\ty\u0003&\u0001\u0004=e>|GO\u0010\u0006\u0002c\u0005)1oY1mC&\u00111\u0007M\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024a\u0005!A-\u001b:!\u0003)\u0019XM]5bY&TXM]\u000b\u0002uA\u00111(P\u0007\u0002y)\u0011\u0001HF\u0005\u0003}q\u0012!bU3sS\u0006d\u0017N_3s\u0003-\u0019XM]5bY&TXM\u001d\u0011\u0002\u000b\r|G-Z2\u0016\u0003\t\u00032a\u0011#G\u001b\u0005\u0001\u0014BA#1\u0005\u0019y\u0005\u000f^5p]B\u0011qIS\u0007\u0002\u0011*\u0011\u0011JF\u0001\u0003S>L!a\u0013%\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017AB2pI\u0016\u001c\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001fB\u000b&\u000b\u0005\u0002\u001f\u0001!)qe\u0002a\u0001U!)\u0001h\u0002a\u0001u!9\u0001i\u0002I\u0001\u0002\u0004\u0011\u0015a\u00029feNL7\u000f\u001e\u000b\u0004+bS\u0006CA\"W\u0013\t9\u0006G\u0001\u0003V]&$\b\"B-\t\u0001\u0004Q\u0013\u0001\u00028b[\u0016DQa\u0017\u0005A\u0002q\u000b1a\u001c2k!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0003mC:<'\"A1\u0002\t)\fg/Y\u0005\u0003Gz\u0013aa\u00142kK\u000e$\u0018!C;oa\u0016\u00148/[:u)\t)f\rC\u0003Z\u0013\u0001\u0007!&\u0001\u0003sK\u0006$WCA5w)\rQ\u0017q\u0002\u000b\u0003W~\u00042\u0001\\9u\u001d\tiwN\u0004\u0002.]&\t\u0011'\u0003\u0002qa\u00059\u0001/Y2lC\u001e,\u0017B\u0001:t\u0005\r\u0019V-\u001d\u0006\u0003aB\u0002\"!\u001e<\r\u0001\u0011)qO\u0003b\u0001q\n\tA+\u0005\u0002zyB\u00111I_\u0005\u0003wB\u0012qAT8uQ&tw\r\u0005\u0002D{&\u0011a\u0010\r\u0002\u0004\u0003:L\b\"CA\u0001\u0015\u0005\u0005\t9AA\u0002\u0003))g/\u001b3f]\u000e,G%\r\t\u0006\u0003\u000b\tY\u0001^\u0007\u0003\u0003\u000fQ1!!\u00031\u0003\u001d\u0011XM\u001a7fGRLA!!\u0004\u0002\b\tA1\t\\1tgR\u000bw\r\u0003\u0004\u0002\u0012)\u0001\rAK\u0001\u0007aJ,g-\u001b=\u0002#M,'/[1mSj,\u0017J\u001c;p\r&dW\rF\u0003V\u0003/\t)\u0003C\u0004\u0002\u001a-\u0001\r!a\u0007\u0002\t\u0019LG.\u001a\t\u0005\u0003;\t\t#\u0004\u0002\u0002 )\u0011\u0011\nY\u0005\u0005\u0003G\tyB\u0001\u0003GS2,\u0007bBA\u0014\u0017\u0001\u0007\u0011\u0011F\u0001\u0006m\u0006dW/\u001a\t\u0004\u0007\u0006-\u0012bAA\u0017a\t1\u0011I\\=SK\u001a\f1\u0003Z3tKJL\u0017\r\\5{K\u001a\u0013x.\u001c$jY\u0016,B!a\r\u0002:Q!\u0011QGA!)\u0011\t9$a\u000f\u0011\u0007U\fI\u0004B\u0003x\u0019\t\u0007\u0001\u0010C\u0004\u0002>1\u0001\u001d!a\u0010\u0002\u00035\u0004b!!\u0002\u0002\f\u0005]\u0002bBA\r\u0019\u0001\u0007\u00111D\u0001\u001c\r&dWmU=ti\u0016l\u0007+\u001a:tSN$XM\\2f\u000b:<\u0017N\\3\u0011\u0005yq1c\u0001\b\u0002*Q\u0011\u0011QI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005=#f\u0001\"\u0002R-\u0012\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%)hn\u00195fG.,GMC\u0002\u0002^A\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t'a\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class FileSystemPersistenceEngine
extends PersistenceEngine
implements Logging {
    private final String dir;
    private final Serializer serializer;
    private final Option<CompressionCodec> codec;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<CompressionCodec> $lessinit$greater$default$3() {
        return FileSystemPersistenceEngine$.MODULE$.$lessinit$greater$default$3();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String dir() {
        return this.dir;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public Option<CompressionCodec> codec() {
        return this.codec;
    }

    @Override
    public void persist(String name, Object obj) {
        this.serializeIntoFile(new File(this.dir() + File.separator + name), obj);
    }

    @Override
    public void unpersist(String name) {
        File f = new File(this.dir() + File.separator + name);
        if (!f.delete()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)f.getPath())}))));
            return;
        }
    }

    @Override
    public <T> Seq<T> read(String prefix, ClassTag<T> evidence$1) {
        File[] files = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])new File(this.dir()).listFiles()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemPersistenceEngine.$anonfun$read$1(prefix, x$1)));
        return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)file -> this.deserializeFromFile((File)file, evidence$1), evidence$1)).toImmutableArraySeq();
    }

    private void serializeIntoFile(File file, Object value) {
        if (file.exists()) {
            throw new IllegalStateException("File already exists: " + file);
        }
        boolean created = file.createNewFile();
        if (!created) {
            throw new IllegalStateException("Could not create file: " + file);
        }
        ObjectRef fileOut = ObjectRef.create((Object)new FileOutputStream(file));
        this.codec().foreach((Function1 & Serializable)c -> {
            fileOut.elem = c.compressedOutputStream((OutputStream)fileOut.elem);
            return BoxedUnit.UNIT;
        });
        ObjectRef out = ObjectRef.create(null);
        Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable)() -> {
            out$1.elem = this.serializer().newInstance().serializeStream((OutputStream)fileOut$1.elem);
            return ((SerializationStream)out$1.elem).writeObject(value, ClassTag$.MODULE$.AnyRef());
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if ((SerializationStream)out$1.elem != null) {
                ((SerializationStream)out$1.elem).close();
            }
            ((OutputStream)fileOut$1.elem).close();
        });
    }

    private <T> T deserializeFromFile(File file, ClassTag<T> m) {
        T t;
        ObjectRef fileIn = ObjectRef.create((Object)new FileInputStream(file));
        this.codec().foreach((Function1 & Serializable)c -> {
            fileIn.elem = c.compressedInputStream(new FileInputStream(file));
            return BoxedUnit.UNIT;
        });
        DeserializationStream in = null;
        try {
            in = this.serializer().newInstance().deserializeStream((InputStream)fileIn.elem);
            t = in.readObject(m);
        }
        finally {
            ((InputStream)fileIn.elem).close();
            if (in != null) {
                in.close();
            }
        }
        return t;
    }

    public static final /* synthetic */ boolean $anonfun$read$1(String prefix$1, File x$1) {
        return x$1.getName().startsWith(prefix$1);
    }

    public FileSystemPersistenceEngine(String dir, Serializer serializer, Option<CompressionCodec> codec) {
        Path path;
        this.dir = dir;
        this.serializer = serializer;
        this.codec = codec;
        Logging.$init$((Logging)this);
        try {
            path = Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileAlreadyExistsException && Files.isSymbolicLink(Paths.get(dir, new String[0]))) {
                path = Files.createDirectories(Paths.get(dir, new String[0]).toRealPath(new LinkOption[0]), new FileAttribute[0]);
            }
            throw throwable;
        }
    }
}

