/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.gymnastics.NotGiven$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.all$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.math.Ring$;
import breeze.math.Semiring$;
import breeze.numerics.package;
import breeze.stats.distributions.Gamma;
import breeze.stats.distributions.RandBasis;
import breeze.storage.Zero$;
import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t-h\u0001\u0002&L\u0005YCQa\u001a\u0001\u0005\u0002!DqA\u001b\u0001A\u0002\u0013%1\u000eC\u0004p\u0001\u0001\u0007I\u0011\u00029\t\rY\u0004\u0001\u0015)\u0003m\u0011\u001d9\b\u00011A\u0005\naDq\u0001 \u0001A\u0002\u0013%Q\u0010\u0003\u0004\u0000\u0001\u0001\u0006K!\u001f\u0005\t\u0003\u0003\u0001\u0001\u0019!C\u0005W\"I\u00111\u0001\u0001A\u0002\u0013%\u0011Q\u0001\u0005\b\u0003\u0013\u0001\u0001\u0015)\u0003m\u0011%\tY\u0001\u0001a\u0001\n\u0013\ti\u0001C\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0003\u0002\u001e!A\u0011\u0011\u0005\u0001!B\u0013\ty\u0001\u0003\u0005\u0002$\u0001!\taSA\u0007\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9\u0003C\u0005\u00020\u0001\u0001\r\u0011\"\u0003\u00022!A\u0011Q\u0007\u0001!B\u0013\tI\u0003\u0003\u0005\u00028\u0001!\taSA\u0014\u0011%\tI\u0004\u0001a\u0001\n\u0013\tY\u0004C\u0005\u0002N\u0001\u0001\r\u0011\"\u0003\u0002P!A\u00111\u000b\u0001!B\u0013\ti\u0004C\u0005\u0002V\u0001\u0001\r\u0011\"\u0003\u0002X!I\u0011q\f\u0001A\u0002\u0013%\u0011\u0011\r\u0005\t\u0003K\u0002\u0001\u0015)\u0003\u0002Z!I\u0011q\r\u0001A\u0002\u0013%\u0011q\u0005\u0005\n\u0003S\u0002\u0001\u0019!C\u0005\u0003WB\u0001\"a\u001c\u0001A\u0003&\u0011\u0011\u0006\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003OA\u0011\"a\u001d\u0001\u0001\u0004%I!!\u001e\t\u0011\u0005e\u0004\u0001)Q\u0005\u0003SA\u0011\"a\u001f\u0001\u0001\u0004%I!a\n\t\u0013\u0005u\u0004\u00011A\u0005\n\u0005}\u0004\u0002CAB\u0001\u0001\u0006K!!\u000b\t\u0013\u0005\u0015\u0005\u00011A\u0005\n\u0005]\u0003\"CAD\u0001\u0001\u0007I\u0011BAE\u0011!\ti\t\u0001Q!\n\u0005e\u0003\"CAH\u0001\u0001\u0007I\u0011BAI\u0011%\t)\u000b\u0001a\u0001\n\u0013\t9\u000b\u0003\u0005\u0002,\u0002\u0001\u000b\u0015BAJ\u0011%\ti\u000b\u0001a\u0001\n\u0013\ty\u000bC\u0005\u0002@\u0002\u0001\r\u0011\"\u0003\u0002B\"A\u0011Q\u0019\u0001!B\u0013\t\t\f\u0003\u0005\u0002H\u0002!\taSAX\u0011!\tI\r\u0001a\u0001\n\u0013Y\u0007\"CAf\u0001\u0001\u0007I\u0011BAg\u0011\u001d\t\t\u000e\u0001Q!\n1D\u0011\"a5\u0001\u0001\u0004%I!a\n\t\u0013\u0005U\u0007\u00011A\u0005\n\u0005]\u0007\u0002CAn\u0001\u0001\u0006K!!\u000b\t\u000f\u0005u\u0007\u0001\"\u0001\u0002(!9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\bbBA~\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u00119\u0001\u0001C\u0001\u0003OAqAa\u0003\u0001\t\u0003\u0011i\u0001C\u0004\u0003\u0014\u0001!\t!a\u0016\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!A!1\u0005\u0001\u0005\u0002-\u0013)\u0003\u0003\u0005\u0003*\u0001!\ta\u0013B\u0016\u0011!\u0011\t\u0004\u0001C\u0001\u0017\nM\u0002\u0002\u0003B\u001d\u0001\u0011\u00053Ja\u000f\t\u000f\t%\u0003\u0001\"\u0011LQ\"A!1\n\u0001\u0005\u0002-\u0013i\u0005C\u0004\u0003T\u0001!IA!\u0016\t\u000f\t}\u0003\u0001\"\u0003\u0003b!9!\u0011\u000f\u0001\u0005\n\tM\u0004b\u0002B;\u0001\u0011%!q\u000f\u0005\t\u0005\u0003\u0003A\u0011I&\u0003\u0004\u001eA!qS&\t\u0002=\u0013IJB\u0004K\u0017\"\u0005qJa'\t\r\u001d4E\u0011\u0001BO\u0011!\u0011yJ\u0012C\u0001\u001f\n\u0005\u0006\u0002\u0003BP\r\u0012\u00051Ja7\u0003%=sG.\u001b8f\u0019\u0012\u000bu\n\u001d;j[&TXM\u001d\u0006\u0003\u00196\u000b!b\u00197vgR,'/\u001b8h\u0015\tqu*A\u0003nY2L'M\u0003\u0002Q#\u0006)1\u000f]1sW*\u0011!kU\u0001\u0007CB\f7\r[3\u000b\u0003Q\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A,^CB\u0011\u0001lW\u0007\u00023*\t!,A\u0003tG\u0006d\u0017-\u0003\u0002]3\n1\u0011I\\=SK\u001a\u0004\"AX0\u000e\u0003-K!\u0001Y&\u0003\u00191#\u0015i\u00149uS6L'0\u001a:\u0011\u0005\t,W\"A2\u000b\u0005\u0011|\u0015\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0019\u001c'a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0004\"A\u0018\u0001\u0002\u0003-,\u0012\u0001\u001c\t\u000316L!A\\-\u0003\u0007%sG/A\u0003l?\u0012*\u0017\u000f\u0006\u0002riB\u0011\u0001L]\u0005\u0003gf\u0013A!\u00168ji\"9QoAA\u0001\u0002\u0004a\u0017a\u0001=%c\u0005\u00111\u000eI\u0001\u000bG>\u0014\b/^:TSj,W#A=\u0011\u0005aS\u0018BA>Z\u0005\u0011auN\\4\u0002\u001d\r|'\u000f];t'&TXm\u0018\u0013fcR\u0011\u0011O \u0005\bk\u001a\t\t\u00111\u0001z\u0003-\u0019wN\u001d9vgNK'0\u001a\u0011\u0002\u0013Y|7-\u00192TSj,\u0017!\u0004<pG\u0006\u00147+\u001b>f?\u0012*\u0017\u000fF\u0002r\u0003\u000fAq!^\u0005\u0002\u0002\u0003\u0007A.\u0001\u0006w_\u000e\f'mU5{K\u0002\nQ!\u00197qQ\u0006,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006N\u0003\u0019a\u0017N\\1mO&!\u0011\u0011DA\n\u0005\u00191Vm\u0019;pe\u0006I\u0011\r\u001c9iC~#S-\u001d\u000b\u0004c\u0006}\u0001\u0002C;\r\u0003\u0003\u0005\r!a\u0004\u0002\r\u0005d\u0007\u000f[1!\u0003!9W\r^!ma\"\f\u0017aA3uCV\u0011\u0011\u0011\u0006\t\u00041\u0006-\u0012bAA\u00173\n1Ai\\;cY\u0016\fq!\u001a;b?\u0012*\u0017\u000fF\u0002r\u0003gA\u0001\"\u001e\t\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0005KR\f\u0007%\u0001\u0004hKR,E/Y\u0001\u0010e\u0006tGm\\7HK:,'/\u0019;peV\u0011\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u001d\u0013\u0001\u00026bm\u0006LA!a\u0013\u0002B\t1!+\u00198e_6\f1C]1oI>lw)\u001a8fe\u0006$xN]0%KF$2!]A)\u0011!)H#!AA\u0002\u0005u\u0012\u0001\u0005:b]\u0012|WnR3oKJ\fGo\u001c:!\u0003U\u0019\u0018-\u001c9mK^KG\u000f\u001b*fa2\f7-Z7f]R,\"!!\u0017\u0011\u0007a\u000bY&C\u0002\u0002^e\u0013qAQ8pY\u0016\fg.A\rtC6\u0004H.Z,ji\"\u0014V\r\u001d7bG\u0016lWM\u001c;`I\u0015\fHcA9\u0002d!AQoFA\u0001\u0002\u0004\tI&\u0001\ftC6\u0004H.Z,ji\"\u0014V\r\u001d7bG\u0016lWM\u001c;!\u0003\u0011!\u0018-\u001e\u0019\u0002\u0011Q\fW\u000fM0%KF$2!]A7\u0011!)($!AA\u0002\u0005%\u0012!\u0002;bkB\u0002\u0013!B6baB\f\u0017!C6baB\fw\fJ3r)\r\t\u0018q\u000f\u0005\tkv\t\t\u00111\u0001\u0002*\u000511.\u00199qC\u0002\n\u0011#\\5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8o\u0003Ui\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\0%KF$2!]AA\u0011!)\b%!AA\u0002\u0005%\u0012AE7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0002\n\u0001d\u001c9uS6L'0\u001a#pG\u000e{gnY3oiJ\fG/[8o\u0003qy\u0007\u000f^5nSj,Gi\\2D_:\u001cWM\u001c;sCRLwN\\0%KF$2!]AF\u0011!)8%!AA\u0002\u0005e\u0013!G8qi&l\u0017N_3E_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002\nA\u0001Z8dgV\u0011\u00111\u0013\t\u0007\u0003+\u000bY*a(\u000e\u0005\u0005]%bAAM\u001f\u0006\u0019!\u000f\u001a3\n\t\u0005u\u0015q\u0013\u0002\u0004%\u0012#\u0005C\u0002-\u0002\"f\fy!C\u0002\u0002$f\u0013a\u0001V;qY\u0016\u0014\u0014\u0001\u00033pGN|F%Z9\u0015\u0007E\fI\u000b\u0003\u0005vM\u0005\u0005\t\u0019AAJ\u0003\u0015!wnY:!\u0003\u0019a\u0017-\u001c2eCV\u0011\u0011\u0011\u0017\t\u0007\u0003g\u000bY,!\u000b\u000e\u0005\u0005U&\u0002BA\u000b\u0003oS!!!/\u0002\r\t\u0014X-\u001a>f\u0013\u0011\ti,!.\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e_\u0001\u000bY\u0006l'\rZ1`I\u0015\fHcA9\u0002D\"AQ/KA\u0001\u0002\u0004\t\t,A\u0004mC6\u0014G-\u0019\u0011\u0002\u0013\u001d,G\u000fT1nE\u0012\f\u0017!C5uKJ\fG/[8o\u00035IG/\u001a:bi&|gn\u0018\u0013fcR\u0019\u0011/a4\t\u000fUl\u0013\u0011!a\u0001Y\u0006Q\u0011\u000e^3sCRLwN\u001c\u0011\u0002\u0015\u001d\fW.\\1TQ\u0006\u0004X-\u0001\bhC6l\u0017m\u00155ba\u0016|F%Z9\u0015\u0007E\fI\u000e\u0003\u0005va\u0005\u0005\t\u0019AA\u0015\u0003-9\u0017-\\7b'\"\f\u0007/\u001a\u0011\u0002\u000f\u001d,G\u000fV1va!*!'!9\u0002nB!\u00111]Au\u001b\t\t)OC\u0002\u0002h>\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY/!:\u0003\u000bMKgnY3\"\u0005\u0005=\u0018!B\u0019/i9\u0002\u0014aB:fiR\u000bW\u000f\r\u000b\u0005\u0003k\f90D\u0001\u0001\u0011\u001d\t9g\ra\u0001\u0003SASaMAq\u0003[\f\u0001bZ3u\u0017\u0006\u0004\b/\u0019\u0015\u0006i\u0005\u0005\u0018Q^\u0001\tg\u0016$8*\u00199qCR!\u0011Q\u001fB\u0002\u0011\u001d\t\t(\u000ea\u0001\u0003SAS!NAq\u0003[\fAcZ3u\u001b&t\u0017NQ1uG\"4%/Y2uS>t\u0007&\u0002\u001c\u0002b\u00065\u0018\u0001F:fi6Kg.\u001b\"bi\u000eDgI]1di&|g\u000e\u0006\u0003\u0002v\n=\u0001bBA>o\u0001\u0007\u0011\u0011\u0006\u0015\u0006o\u0005\u0005\u0018Q^\u0001\u001cO\u0016$x\n\u001d;j[&TX\rR8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8)\u000ba\n\tOa\u0006\"\u0005\te\u0011!B\u0019/k9\u0002\u0014aG:fi>\u0003H/[7ju\u0016$unY\"p]\u000e,g\u000e\u001e:bi&|g\u000e\u0006\u0003\u0002v\n}\u0001bBACs\u0001\u0007\u0011\u0011\f\u0015\u0006s\u0005\u0005(qC\u0001\ng\u0016$H*Y7cI\u0006$B!!>\u0003(!9\u0011Q\u0016\u001eA\u0002\u0005E\u0016!D:fi\u001e\u000bW.\\1TQ\u0006\u0004X\r\u0006\u0003\u0002v\n5\u0002b\u0002B\u0018w\u0001\u0007\u0011\u0011F\u0001\u0006g\"\f\u0007/Z\u0001\u0019g\u0016$8+Y7qY\u0016<\u0016\u000e\u001e5SKBd\u0017mY3nK:$H\u0003BA{\u0005kAqAa\u000e=\u0001\u0004\tI&A\u0004sKBd\u0017mY3\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0003j\u0005{\u0011y\u0004C\u0004\u0002\u0010v\u0002\r!a%\t\u000f\t\u0005S\b1\u0001\u0003D\u0005\u0019A\u000eZ1\u0011\u0007y\u0013)%C\u0002\u0003H-\u00131\u0001\u0014#B\u0003\u0011qW\r\u001f;\u0002\u001fM,(-\\5u\u001b&t\u0017NQ1uG\"$2!\u001bB(\u0011\u001d\u0011\tf\u0010a\u0001\u0003'\u000bQAY1uG\"\fA\"\u001e9eCR,G*Y7cI\u0006$R!\u001dB,\u00057BqA!\u0017A\u0001\u0004\t\t,\u0001\u0003ti\u0006$\bB\u0002B/\u0001\u0002\u0007A.A\u0005cCR\u001c\u0007nU5{K\u0006YQ\u000f\u001d3bi\u0016\fE\u000e\u001d5b)\u0015\t(1\rB7\u0011\u001d\u0011)'\u0011a\u0001\u0005O\nq\u0001\\8ha\"\fG\u000f\u0005\u0004\u00024\n%\u0014\u0011F\u0005\u0005\u0005W\n)LA\u0006EK:\u001cXMV3di>\u0014\bb\u0002B8\u0003\u0002\u0007\u0011\u0011F\u0001\u000e]>tW)\u001c9us\u0012{7m\u001d(\u0002\u0007IDw\u000e\u0006\u0002\u0002*\u0005qq-\u001a;HC6l\u0017-T1ue&DHCBAY\u0005s\u0012i\b\u0003\u0004\u0003|\r\u0003\r\u0001\\\u0001\u0004e><\bB\u0002B@\u0007\u0002\u0007A.A\u0002d_2\f1bZ3u\u0019\u0012\u000bUj\u001c3fYR!!Q\u0011BF!\rq&qQ\u0005\u0004\u0005\u0013[%\u0001\u0003'E\u00036{G-\u001a7\t\u000f\t5E\t1\u0001\u0003\u0010\u0006q\u0011\u000e^3sCRLwN\u001c+j[\u0016\u001c\b#\u0002-\u0003\u0012\u0006%\u0012b\u0001BJ3\n)\u0011I\u001d:bs\"*\u0001!!9\u0002n\u0006\u0011rJ\u001c7j]\u0016dE)Q(qi&l\u0017N_3s!\tqfi\u0005\u0002G/R\u0011!\u0011T\u0001\u001am\u0006\u0014\u0018.\u0019;j_:\fG\u000eV8qS\u000eLeNZ3sK:\u001cW\r\u0006\t\u0003$\n\u0005'Q\u0019Be\u0005\u001b\u0014\u0019N!6\u0003XBI\u0001L!*\u0003h\u0005E&\u0011V\u0005\u0004\u0005OK&A\u0002+va2,7\u0007E\u0003\u0003,\nmFN\u0004\u0003\u0003.\n]f\u0002\u0002BX\u0005kk!A!-\u000b\u0007\tMV+\u0001\u0004=e>|GOP\u0005\u00025&\u0019!\u0011X-\u0002\u000fA\f7m[1hK&!!Q\u0018B`\u0005\u0011a\u0015n\u001d;\u000b\u0007\te\u0016\fC\u0004\u0003D\"\u0003\rA!+\u0002\u000f%tG-[2fg\"9!q\u0019%A\u0002\t=\u0015A\u0002<bYV,7\u000fC\u0004\u0003L\"\u0003\r!!-\u0002\u0017\u0015D\b/\u00127pO\n,G/\u0019\u0005\b\u0003\u0017A\u0005\u0019\u0001Bh!\u0019\t\u0019L!5\u0002*%!\u0011\u0011DA[\u0011\u001d\t\u0019\u000e\u0013a\u0001\u0003SAQA\u001b%A\u00021DaA!7I\u0001\u0004I\u0018\u0001B:fK\u0012$bBa)\u0003^\n\u0005(1\u001dBs\u0005O\u0014I\u000fC\u0004\u0003`&\u0003\r!a\u0004\u0002\u0015Q,'/\\\"pk:$8\u000fC\u0004\u0003L&\u0003\r!!-\t\u000f\u0005-\u0011\n1\u0001\u0003P\"9\u00111[%A\u0002\u0005%\u0002\"\u00026J\u0001\u0004a\u0007B\u0002Bm\u0013\u0002\u0007\u0011\u0010")
public final class OnlineLDAOptimizer
implements LDAOptimizer,
Logging {
    private int k;
    private long corpusSize;
    private int vocabSize;
    private Vector alpha;
    private double eta;
    private Random randomGenerator;
    private boolean sampleWithReplacement;
    private double tau0;
    private double kappa;
    private double miniBatchFraction;
    private boolean optimizeDocConcentration;
    private RDD<Tuple2<Object, Vector>> docs;
    private DenseMatrix<Object> lambda;
    private int iteration;
    private double gammaShape;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private long corpusSize() {
        return this.corpusSize;
    }

    private void corpusSize_$eq(long x$1) {
        this.corpusSize = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    private Vector alpha() {
        return this.alpha;
    }

    private void alpha_$eq(Vector x$1) {
        this.alpha = x$1;
    }

    public Vector getAlpha() {
        return this.alpha();
    }

    private double eta() {
        return this.eta;
    }

    private void eta_$eq(double x$1) {
        this.eta = x$1;
    }

    public double getEta() {
        return this.eta();
    }

    private Random randomGenerator() {
        return this.randomGenerator;
    }

    private void randomGenerator_$eq(Random x$1) {
        this.randomGenerator = x$1;
    }

    private boolean sampleWithReplacement() {
        return this.sampleWithReplacement;
    }

    private void sampleWithReplacement_$eq(boolean x$1) {
        this.sampleWithReplacement = x$1;
    }

    private double tau0() {
        return this.tau0;
    }

    private void tau0_$eq(double x$1) {
        this.tau0 = x$1;
    }

    private double kappa() {
        return this.kappa;
    }

    private void kappa_$eq(double x$1) {
        this.kappa = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private boolean optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    private void optimizeDocConcentration_$eq(boolean x$1) {
        this.optimizeDocConcentration = x$1;
    }

    private RDD<Tuple2<Object, Vector>> docs() {
        return this.docs;
    }

    private void docs_$eq(RDD<Tuple2<Object, Vector>> x$1) {
        this.docs = x$1;
    }

    private DenseMatrix<Object> lambda() {
        return this.lambda;
    }

    private void lambda_$eq(DenseMatrix<Object> x$1) {
        this.lambda = x$1;
    }

    public DenseMatrix<Object> getLambda() {
        return this.lambda();
    }

    private int iteration() {
        return this.iteration;
    }

    private void iteration_$eq(int x$1) {
        this.iteration = x$1;
    }

    private double gammaShape() {
        return this.gammaShape;
    }

    private void gammaShape_$eq(double x$1) {
        this.gammaShape = x$1;
    }

    public double getTau0() {
        return this.tau0();
    }

    public OnlineLDAOptimizer setTau0(double tau0) {
        Predef$.MODULE$.require(tau0 > 0.0, (Function0 & Serializable)() -> "LDA tau0 must be positive, but was set to " + tau0);
        this.tau0_$eq(tau0);
        return this;
    }

    public double getKappa() {
        return this.kappa();
    }

    public OnlineLDAOptimizer setKappa(double kappa) {
        Predef$.MODULE$.require(kappa >= 0.0, (Function0 & Serializable)() -> "Online LDA kappa must be nonnegative, but was set to " + kappa);
        this.kappa_$eq(kappa);
        return this;
    }

    public double getMiniBatchFraction() {
        return this.miniBatchFraction();
    }

    public OnlineLDAOptimizer setMiniBatchFraction(double miniBatchFraction) {
        Predef$.MODULE$.require(miniBatchFraction > 0.0 && miniBatchFraction <= 1.0, (Function0 & Serializable)() -> "Online LDA miniBatchFraction must be in range (0,1], but was set to " + miniBatchFraction);
        this.miniBatchFraction_$eq(miniBatchFraction);
        return this;
    }

    public boolean getOptimizeDocConcentration() {
        return this.optimizeDocConcentration();
    }

    public OnlineLDAOptimizer setOptimizeDocConcentration(boolean optimizeDocConcentration) {
        this.optimizeDocConcentration_$eq(optimizeDocConcentration);
        return this;
    }

    public OnlineLDAOptimizer setLambda(DenseMatrix<Object> lambda) {
        this.lambda_$eq(lambda);
        return this;
    }

    public OnlineLDAOptimizer setGammaShape(double shape) {
        this.gammaShape_$eq(shape);
        return this;
    }

    public OnlineLDAOptimizer setSampleWithReplacement(boolean replace) {
        this.sampleWithReplacement_$eq(replace);
        return this;
    }

    @Override
    public OnlineLDAOptimizer initialize(RDD<Tuple2<Object, Vector>> docs, LDA lda) {
        Vector vector;
        this.k_$eq(lda.getK());
        this.corpusSize_$eq(docs.count());
        this.vocabSize_$eq(((Vector)((Tuple2)docs.first())._2()).size());
        if (lda.getAsymmetricDocConcentration().size() == 1) {
            if (lda.getAsymmetricDocConcentration().apply(0) == (double)-1) {
                vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0 / (double)this.k(), (ClassTag)ClassTag$.MODULE$.Double()));
            } else {
                Predef$.MODULE$.require(lda.getAsymmetricDocConcentration().apply(0) >= 0.0, (Function0 & Serializable)() -> "all entries in alpha must be >=0, got: " + this.alpha());
                vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable)() -> lda.getAsymmetricDocConcentration().apply(0), (ClassTag)ClassTag$.MODULE$.Double()));
            }
        } else {
            Predef$.MODULE$.require(lda.getAsymmetricDocConcentration().size() == this.k(), (Function0 & Serializable)() -> "alpha must have length k, got: " + this.alpha());
            lda.getAsymmetricDocConcentration().foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable)(x0$1, x1$1) -> {
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$1, x1$1);
                if (sp2 != null) {
                    double x = sp2._2$mcD$sp();
                    Predef$.MODULE$.require(x >= 0.0, (Function0 & Serializable)() -> "all entries in alpha must be >= 0, got: " + this.alpha());
                    return;
                }
                throw new MatchError((Object)sp2);
            });
            vector = lda.getAsymmetricDocConcentration();
        }
        this.alpha_$eq(vector);
        this.eta_$eq(lda.getTopicConcentration() == (double)-1 ? 1.0 / (double)this.k() : lda.getTopicConcentration());
        this.randomGenerator_$eq(new Random(lda.getSeed()));
        this.docs_$eq(docs);
        StorageLevel storageLevel = this.docs().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.");
        }
        this.lambda_$eq(this.getGammaMatrix(this.k(), this.vocabSize()));
        this.iteration_$eq(0);
        return this;
    }

    @Override
    public OnlineLDAOptimizer next() {
        RDD batch = this.docs().sample(this.sampleWithReplacement(), this.miniBatchFraction(), this.randomGenerator().nextLong());
        if (batch.isEmpty()) {
            return this;
        }
        return this.submitMiniBatch((RDD<Tuple2<Object, Vector>>)batch);
    }

    public OnlineLDAOptimizer submitMiniBatch(RDD<Tuple2<Object, Vector>> batch) {
        Option option;
        DenseMatrix denseMatrix;
        long nonEmptyDocsN;
        Broadcast expElogbetaBc;
        DenseMatrix expElogbeta;
        block5: {
            Tuple3 tuple3;
            block4: {
                this.iteration_$eq(this.iteration() + 1);
                int k = this.k();
                int vocabSize = this.vocabSize();
                expElogbeta = (DenseMatrix)((ImmutableNumericOps)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation(this.lambda()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, HasOps$.MODULE$.canMapValues_DM$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())))).t(HasOps$.MODULE$.canTranspose_DM());
                expElogbetaBc = batch.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
                breeze.linalg.Vector<Object> alpha = this.alpha().asBreeze();
                double gammaShape = this.gammaShape();
                boolean optimizeDocConcentration = this.optimizeDocConcentration();
                long seed = this.randomGenerator().nextLong();
                Function0 & Serializable logphatPartOptionBase = (Function0 & Serializable)() -> {
                    if (optimizeDocConcentration) {
                        return new Some((Object)DenseVector$.MODULE$.zeros$mDc$sp(k, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()));
                    }
                    return None$.MODULE$;
                };
                RDD stats = batch.mapPartitionsWithIndex((Function2 & Serializable)(index, docs) -> OnlineLDAOptimizer.$anonfun$submitMiniBatch$2(k, vocabSize, logphatPartOptionBase, expElogbetaBc, alpha, gammaShape, seed, BoxesRunTime.unboxToInt((Object)index), docs), batch.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple3.class));
                Tuple3 x$1 = new Tuple3(null, logphatPartOptionBase.apply(), (Object)BoxesRunTime.boxToLong((long)0L));
                Function2 & Serializable x$2 = (Function2 & Serializable)(u, v) -> OnlineLDAOptimizer.elementWiseSum$1(u, v);
                Function2 & Serializable x$3 = (Function2 & Serializable)(u, v) -> OnlineLDAOptimizer.elementWiseSum$1(u, v);
                int x$4 = stats.treeAggregate$default$4((Object)x$1);
                tuple3 = (Tuple3)stats.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(Tuple3.class));
                if (tuple3 == null) break block4;
                DenseMatrix statsSum = (DenseMatrix)tuple3._1();
                Option logphatOption = (Option)tuple3._2();
                nonEmptyDocsN = BoxesRunTime.unboxToLong((Object)tuple3._3());
                if (statsSum == null) break block4;
                denseMatrix = statsSum;
                if (logphatOption == null) break block4;
                option = logphatOption;
                if (true) break block5;
            }
            throw new MatchError((Object)tuple3);
        }
        long l = nonEmptyDocsN;
        Tuple3 tuple3 = new Tuple3((Object)denseMatrix, (Object)option, (Object)BoxesRunTime.boxToLong((long)l));
        DenseMatrix statsSum = (DenseMatrix)tuple3._1();
        Option logphatOption = (Option)tuple3._2();
        long nonEmptyDocsN2 = BoxesRunTime.unboxToLong((Object)tuple3._3());
        expElogbetaBc.destroy();
        if (nonEmptyDocsN2 == 0L) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "No non-empty documents were submitted in the batch.");
            return this;
        }
        DenseMatrix batchResult = (DenseMatrix)statsSum.$times$colon$times(expElogbeta.t(HasOps$.MODULE$.canTranspose_DM()), HasOps$.MODULE$.op_DM_DM_Double_OpMulScalar());
        int batchSize = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(this.miniBatchFraction() * (double)this.corpusSize()));
        this.updateLambda((DenseMatrix<Object>)batchResult, batchSize);
        logphatOption.foreach((Function1 & Serializable)x$11 -> (DenseVector)x$11.$div$eq((Object)BoxesRunTime.boxToDouble((double)nonEmptyDocsN2), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpDiv()));
        logphatOption.foreach((Function1 & Serializable)x$12 -> {
            this.updateAlpha((DenseVector<Object>)x$12, nonEmptyDocsN2);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void updateLambda(DenseMatrix<Object> stat, int batchSize) {
        double weight = this.rho();
        this.lambda().$colon$eq(((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)(1.0 - weight)))).$times(this.lambda(), HasOps$.MODULE$.s_dm_op_Double_OpMulMatrix())).$plus(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times(((NumericOps)stat.$times((Object)BoxesRunTime.boxToDouble((double)((double)this.corpusSize() / (double)batchSize)), HasOps$.MODULE$.op_DM_S_Double_OpMulMatrix())).$plus((Object)BoxesRunTime.boxToDouble((double)this.eta()), HasOps$.MODULE$.op_DM_S_Double_OpAdd()), HasOps$.MODULE$.s_dm_op_Double_OpMulMatrix()), HasOps$.MODULE$.op_DM_DM_Double_OpAdd()), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
    }

    private void updateAlpha(DenseVector<Object> logphat, double nonEmptyDocsN) {
        double weight = this.rho();
        DenseVector alpha = this.alpha().asBreeze().toDenseVector$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
        DenseVector gradf = (DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)nonEmptyDocsN))).$times(((NumericOps)LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)alpha).unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseVector$.MODULE$.DV_scalarOf(), Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()))).$plus(logphat, HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double()), HasOps$.MODULE$.impl_Op_S_DV_eq_DV_Double_OpMulMatrix());
        double c = nonEmptyDocsN * package.trigamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)alpha, sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))), (UFunc.UImpl)package.trigamma$.trigammaImplDouble$.MODULE$);
        DenseVector q = (DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)(-nonEmptyDocsN)))).$times(package.trigamma$.MODULE$.apply((Object)alpha, HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), (UFunc.UImpl)package.trigamma$.trigammaImplDouble$.MODULE$, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double()))), HasOps$.MODULE$.impl_Op_S_DV_eq_DV_Double_OpMulMatrix());
        double b = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(gradf.$div((Object)q, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpDiv()), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) / (1.0 / c + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)1.0))).$div((Object)q, HasOps$.MODULE$.impl_Op_S_DV_eq_DV_Double_OpDiv()), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))));
        DenseVector dalpha = (DenseVector)((ImmutableNumericOps)((ImmutableNumericOps)gradf.$minus((Object)BoxesRunTime.boxToDouble((double)b), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpSub())).unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseVector$.MODULE$.DV_scalarOf(), Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()))).$div((Object)q, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpDiv());
        if (BoxesRunTime.unboxToBoolean((Object)all$.MODULE$.apply(((NumericOps)((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times((Object)dalpha, HasOps$.MODULE$.impl_Op_S_DV_eq_DV_Double_OpMulMatrix())).$plus((Object)alpha, HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double())).$greater$colon$greater((Object)BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_DV_S_eq_BV_comparison_Double_OpGT()), (UFunc.UImpl)HasOps$.MODULE$.impl_all_BV_eq_Boolean()))) {
            alpha.$colon$plus$eq(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times((Object)dalpha, HasOps$.MODULE$.impl_Op_S_DV_eq_DV_Double_OpMulMatrix()), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            this.alpha_$eq(Vectors$.MODULE$.dense(alpha.toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double())));
            return;
        }
    }

    private double rho() {
        return scala.math.package$.MODULE$.pow(this.getTau0() + (double)this.iteration(), -this.getKappa());
    }

    private DenseMatrix<Object> getGammaMatrix(int row, int col) {
        RandBasis randBasis = new RandBasis((RandomGenerator)new MersenneTwister(this.randomGenerator().nextLong()));
        Gamma gammaRandomGenerator = new Gamma(this.gammaShape(), 1.0 / this.gammaShape(), randBasis);
        double[] temp = (double[])gammaRandomGenerator.sample(row * col).toArray((ClassTag)ClassTag$.MODULE$.Double());
        return (DenseMatrix)new DenseMatrix.mcD.sp(col, row, temp).t(HasOps$.MODULE$.canTranspose_DM());
    }

    @Override
    public LDAModel getLDAModel(double[] iterationTimes) {
        return new LocalLDAModel(Matrices$.MODULE$.fromBreeze((Matrix<Object>)this.lambda()).transpose(), this.alpha(), this.eta(), LocalLDAModel$.MODULE$.$lessinit$greater$default$4()).setSeed(this.randomGenerator().nextLong());
    }

    public static final /* synthetic */ boolean $anonfun$submitMiniBatch$3(Tuple2 x$6) {
        return ((Vector)x$6._2()).numNonzeros() > 0;
    }

    public static final /* synthetic */ void $anonfun$submitMiniBatch$4(LongRef nonEmptyDocCount$1, Broadcast expElogbetaBc$1, breeze.linalg.Vector alpha$2, double gammaShape$1, int k$2, long seed$1, int index$1, DenseMatrix stat$1, Option logphatPartOption$1, Tuple2 x0$1) {
        Vector termCounts;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (termCounts = (Vector)tuple2._2()) != null) {
            Vector vector = termCounts;
            ++nonEmptyDocCount$1.elem;
            Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)expElogbetaBc$1.value()), (breeze.linalg.Vector<Object>)alpha$2, gammaShape$1, k$2, seed$1 + (long)index$1);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            DenseVector gammad = (DenseVector)tuple3._1();
            DenseMatrix sstats = (DenseMatrix)tuple3._2();
            List ids = (List)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)gammad, (Object)sstats, (Object)ids);
            DenseVector gammad2 = (DenseVector)tuple32._1();
            DenseMatrix sstats2 = (DenseMatrix)tuple32._2();
            List ids2 = (List)tuple32._3();
            ((NumericOps)stat$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)ids2, HasOps$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), (ClassTag)ClassTag$.MODULE$.Double()))).$colon$eq(((NumericOps)stat$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)ids2, HasOps$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), (ClassTag)ClassTag$.MODULE$.Double()))).$plus((Object)sstats2, HasOps$.MODULE$.castOps_M_M((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.neq(), (UFunc.UImpl2)HasOps$.MODULE$.op_M_DM_Double_OpAdd())), HasOps$.MODULE$.castUpdateOps_M_M((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.neq(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.m_m_UpdateOp_Double_OpSet()));
            logphatPartOption$1.foreach((Function1 & Serializable)x$8 -> (DenseVector)x$8.$plus$eq(LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)gammad2), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Iterator $anonfun$submitMiniBatch$2(int k$2, int vocabSize$1, Function0 logphatPartOptionBase$1, Broadcast expElogbetaBc$1, breeze.linalg.Vector alpha$2, double gammaShape$1, long seed$1, int index, Iterator docs) {
        Iterator nonEmptyDocs = docs.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OnlineLDAOptimizer.$anonfun$submitMiniBatch$3(x$6)));
        DenseMatrix stat = DenseMatrix$.MODULE$.zeros$mDc$sp(k$2, vocabSize$1, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        Option logphatPartOption = (Option)logphatPartOptionBase$1.apply();
        LongRef nonEmptyDocCount = LongRef.create((long)0L);
        nonEmptyDocs.foreach((Function1 & Serializable)x0$1 -> {
            OnlineLDAOptimizer.$anonfun$submitMiniBatch$4(nonEmptyDocCount, expElogbetaBc$1, alpha$2, gammaShape$1, k$2, seed$1, index, stat, logphatPartOption, x0$1);
            return BoxedUnit.UNIT;
        });
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)stat, (Object)logphatPartOption, (Object)BoxesRunTime.boxToLong((long)nonEmptyDocCount.elem))}));
    }

    private static final Tuple3 elementWiseSum$1(Tuple3 u, Tuple3 v) {
        DenseMatrix denseMatrix;
        if (u._1() == null) {
            denseMatrix = (DenseMatrix)v._1();
        } else if (v._1() == null) {
            denseMatrix = (DenseMatrix)u._1();
        } else {
            ((NumericOps)u._1()).$plus$eq(v._1(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpAdd());
            denseMatrix = (DenseMatrix)u._1();
        }
        DenseMatrix vec = denseMatrix;
        ((Option)u._2()).foreach((Function1 & Serializable)x$9 -> (DenseVector)x$9.$plus$eq(((Option)v._2()).get(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double()));
        return new Tuple3((Object)vec, u._2(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)u._3()) + BoxesRunTime.unboxToLong((Object)v._3()))));
    }

    public OnlineLDAOptimizer() {
        Logging.$init$((Logging)this);
        this.k = 0;
        this.corpusSize = 0L;
        this.vocabSize = 0;
        this.alpha = Vectors$.MODULE$.dense(0.0, (Seq<Object>)Nil$.MODULE$);
        this.eta = 0.0;
        this.randomGenerator = null;
        this.sampleWithReplacement = true;
        this.tau0 = 1024.0;
        this.kappa = 0.51;
        this.miniBatchFraction = 0.05;
        this.optimizeDocConcentration = false;
        this.docs = null;
        this.lambda = null;
        this.iteration = 0;
        this.gammaShape = 100.0;
    }
}

