/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;

public abstract class AbstractBuffersUsageGauge
implements Gauge<Float> {
    protected final SingleInputGate[] inputGates;

    @VisibleForTesting
    public abstract int calculateUsedBuffers(SingleInputGate var1);

    @VisibleForTesting
    public abstract int calculateTotalBuffers(SingleInputGate var1);

    AbstractBuffersUsageGauge(SingleInputGate[] inputGates) {
        this.inputGates = inputGates;
    }

    public Float getValue() {
        int usedBuffers = 0;
        int totalBuffers = 0;
        for (SingleInputGate inputGate : this.inputGates) {
            usedBuffers += this.calculateUsedBuffers(inputGate);
            totalBuffers += this.calculateTotalBuffers(inputGate);
        }
        if (totalBuffers != 0) {
            return Float.valueOf((float)usedBuffers / (float)totalBuffers);
        }
        return Float.valueOf(0.0f);
    }
}

