/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.configuration.api.CasConfigurationPropertiesSourceLocator;
import org.apereo.cas.configuration.loader.CasConfigurationPropertiesLoader;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Order(value=-2147483648)
public class StandaloneConfigurationFilePropertiesSourceLocator
implements CasConfigurationPropertiesSourceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneConfigurationFilePropertiesSourceLocator.class);
    private final CipherExecutor<String, String> casConfigurationCipherExecutor;

    @Override
    public Optional<PropertySource<?>> locate(Environment environment, ResourceLoader resourceLoader) {
        CompositePropertySource compositePropertySource = new CompositePropertySource(this.getClass().getSimpleName());
        File configFile = CasConfigurationPropertiesSourceLocator.getStandaloneProfileConfigurationFile(environment);
        if (configFile != null) {
            LOGGER.info("Loading standalone configuration properties from [{}]", (Object)configFile);
            PropertySource<Map<String, Object>> sourceStandalone = this.loadSettingsFromStandaloneConfigFile(environment, configFile);
            compositePropertySource.addPropertySource(sourceStandalone);
            return Optional.of(compositePropertySource);
        }
        LOGGER.info("No standalone configuration properties are available");
        return Optional.empty();
    }

    private PropertySource<Map<String, Object>> loadSettingsFromStandaloneConfigFile(Environment environment, File configFile) {
        List<CasConfigurationPropertiesLoader> configurationLoaders = CasConfigurationPropertiesSourceLocator.getConfigurationPropertiesLoaders();
        FileSystemResource resource = new FileSystemResource(configFile);
        CasConfigurationPropertiesLoader foundLoader = configurationLoaders.stream().filter(loader -> loader.supports((Resource)resource)).findFirst().orElseThrow();
        return foundLoader.load((Resource)resource, environment, "standaloneConfigurationFileProperties", this.casConfigurationCipherExecutor);
    }

    @Generated
    public StandaloneConfigurationFilePropertiesSourceLocator(CipherExecutor<String, String> casConfigurationCipherExecutor) {
        this.casConfigurationCipherExecutor = casConfigurationCipherExecutor;
    }
}

