/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public enum PublicKeyCredentialType {
    PUBLIC_KEY("public-key");

    @JsonValue
    @NonNull
    private final String id;

    public static Optional<PublicKeyCredentialType> fromId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Stream.of(PublicKeyCredentialType.values()).filter(v -> v.id.equals(id)).findAny();
    }

    @JsonCreator
    private static PublicKeyCredentialType fromJsonString(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return PublicKeyCredentialType.fromId(id).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown %s value: %s", PublicKeyCredentialType.class.getSimpleName(), id)));
    }

    @Generated
    private PublicKeyCredentialType(String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }
}

