/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.self;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.self.SelfKeymasterOps;
import org.apache.syncope.common.keymaster.rest.api.service.NetworkServiceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.ExponentialBackOff;

public class SelfKeymasterServiceOps
extends SelfKeymasterOps
implements ServiceOps {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceOps.class);
    private final int maxRetries;
    private final String path;

    public SelfKeymasterServiceOps(JAXRSClientFactoryBean clientFactory, int maxRetries) {
        super(clientFactory);
        this.maxRetries = maxRetries;
        this.path = NetworkServiceService.class.getAnnotation(Path.class).value();
    }

    public List<NetworkService> list(NetworkService.Type serviceType) {
        try {
            return ((NetworkServiceService)this.client(NetworkServiceService.class, Map.of())).list(serviceType);
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public NetworkService get(NetworkService.Type serviceType) {
        try {
            return ((NetworkServiceService)this.client(NetworkServiceService.class, Map.of())).get(serviceType);
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    private void handleRetry(NetworkService service, NetworkServiceService.Action action, int retries, BackOffExecution backOffExecution) {
        block5: {
            try {
                if (action == NetworkServiceService.Action.register && retries > 0) {
                    long nextBackoff = backOffExecution.nextBackOff();
                    LOG.debug("Still {} retries available for {}; waiting for {} ms", new Object[]{retries, service, nextBackoff});
                    try {
                        Thread.sleep(nextBackoff);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.retry(this.completionStage(action, service), service, action, retries - 1, backOffExecution);
                    break block5;
                }
                LOG.debug("No more retries {} for {}", (Object)action, (Object)service);
            }
            catch (Throwable t) {
                LOG.error("Could not continue {} for {}, aborting", new Object[]{action, service, t});
            }
        }
    }

    private void retry(CompletionStage<Response> completionStage, NetworkService service, NetworkServiceService.Action action, int retries, BackOffExecution backOffExecution) {
        completionStage.whenComplete((response, throwable) -> {
            if (throwable == null && response.getStatus() < 300) {
                LOG.info("{} successfully {}ed", (Object)service, (Object)action);
            } else {
                LOG.error("Could not {} {}", new Object[]{action, service, throwable});
                this.handleRetry(service, action, retries, backOffExecution);
            }
        }).exceptionally(throwable -> {
            LOG.error("Could not {} {}", new Object[]{action, service, throwable});
            this.handleRetry(service, action, retries, backOffExecution);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        });
    }

    private CompletionStage<Response> completionStage(NetworkServiceService.Action action, NetworkService service) {
        return this.rx(this.path + "?action=" + action.name()).post(Entity.entity((Object)service, (String)"application/json"));
    }

    public void register(NetworkService service) {
        this.retry(this.completionStage(NetworkServiceService.Action.register, service), service, NetworkServiceService.Action.register, this.maxRetries, new ExponentialBackOff(5000L, 1.5).start());
    }

    public void unregister(NetworkService service) {
        this.retry(this.completionStage(NetworkServiceService.Action.unregister, service), service, NetworkServiceService.Action.unregister, this.maxRetries, new ExponentialBackOff(5000L, 1.5).start());
    }
}

