/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.core.util.PrettyPrintHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Yaml {
    private static final Logger LOGGER = LoggerFactory.getLogger(Yaml.class);

    public static ObjectMapper mapper() {
        return ObjectMapperHolder.MAPPER;
    }

    public static ObjectWriter pretty() {
        return Yaml.mapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public static String pretty(Object o) {
        try {
            return Yaml.pretty().writeValueAsString(o);
        }
        catch (Exception e) {
            PrettyPrintHelper.emitError(LOGGER, "Error serializing object to YAML", e);
            return null;
        }
    }

    public static void prettyPrint(Object o) {
        try {
            String prettyString = Yaml.pretty().writeValueAsString(o);
            PrettyPrintHelper.emit(LOGGER, prettyString);
        }
        catch (Exception e) {
            PrettyPrintHelper.emitError(LOGGER, "Error pretty-printing YAML", e);
        }
    }

    private static final class ObjectMapperHolder {
        private static final ObjectMapper MAPPER = ObjectMapperFactory.createYaml();

        private ObjectMapperHolder() {
        }
    }
}

