/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.support.password.PasswordExpiringWarningMessageDescriptor;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class HandlePasswordExpirationWarningMessagesAction
extends BaseCasWebflowAction {
    public static final String ATTRIBUTE_NAME_EXPIRATION_WARNING_FOUND = "passwordExpirationWarningFound";

    protected Event doExecuteInternal(RequestContext context) {
        AttributeMap attributes = context.getCurrentEvent().getAttributes();
        Collection warnings = (Collection)attributes.get("authenticationWarnings", Collection.class, new LinkedHashSet(0));
        Optional<MessageDescriptor> found = warnings.stream().filter(PasswordExpiringWarningMessageDescriptor.class::isInstance).findAny();
        context.getFlowScope().put(ATTRIBUTE_NAME_EXPIRATION_WARNING_FOUND, (Object)found.isPresent());
        Optional.ofNullable(WebUtils.getCredential((RequestContext)context, Credential.class)).ifPresent(upc -> PasswordManagementWebflowUtils.putPasswordResetUsername(context, upc.getId()));
        return null;
    }
}

