/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.api;

import java.util.List;
import javax.net.ssl.TrustManager;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.security.GuardedString;

public final class RemoteFrameworkConnectionInfo {
    private final String host;
    private final int port;
    private final GuardedString key;
    private final boolean useSSL;
    private final List<TrustManager> trustManagers;
    private final int timeout;

    public RemoteFrameworkConnectionInfo(String host, int port, GuardedString key) {
        this(host, port, key, false, null, 60000);
    }

    public RemoteFrameworkConnectionInfo(String host, int port, GuardedString key, boolean useSSL, List<TrustManager> trustManagers, int timeout) {
        Assertions.nullCheck(host, "host");
        Assertions.nullCheck(key, "key");
        this.host = host;
        this.port = port;
        this.key = key;
        this.useSSL = useSSL;
        this.trustManagers = CollectionUtil.newReadOnlyList(trustManagers);
        this.timeout = timeout;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public GuardedString getKey() {
        return this.key;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public List<TrustManager> getTrustManagers() {
        return this.trustManagers;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteFrameworkConnectionInfo) {
            RemoteFrameworkConnectionInfo other = (RemoteFrameworkConnectionInfo)o;
            if (!this.getHost().equals(other.getHost())) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getUseSSL() != other.getUseSSL()) {
                return false;
            }
            if (!this.getTrustManagers().equals(other.getTrustManagers())) {
                return false;
            }
            if (!this.getKey().equals(other.getKey())) {
                return false;
            }
            return this.getTimeout() == other.getTimeout();
        }
        return false;
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port;
    }

    public String toString() {
        return "{host=" + this.host + ", port=" + this.port + "}";
    }
}

