/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.NameUtil;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

public final class ObjectClassInfo {
    private final String type;
    private final Set<AttributeInfo> attributeInfos;
    private final boolean isContainer;
    private final boolean isAuxiliary;
    private final boolean isEmbedded;

    public ObjectClassInfo(String type, Set<AttributeInfo> attrInfo, boolean isContainer, boolean isAuxiliary, boolean isEmbedded) {
        Assertions.nullCheck(type, "type");
        this.type = type;
        this.attributeInfos = CollectionUtil.newReadOnlySet(attrInfo);
        this.isContainer = isContainer;
        this.isAuxiliary = isAuxiliary;
        this.isEmbedded = isEmbedded;
        Map<String, AttributeInfo> map = AttributeInfoUtil.toMap(attrInfo);
        if (!map.containsKey(Name.NAME)) {
            throw new IllegalArgumentException("Missing 'Name' attribute info.");
        }
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public boolean isAuxiliary() {
        return this.isAuxiliary;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public Set<AttributeInfo> getAttributeInfo() {
        return CollectionUtil.newReadOnlySet(this.attributeInfos);
    }

    public String getType() {
        return this.type;
    }

    public boolean is(String name) {
        return NameUtil.namesEqual(this.type, name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ObjectClassInfo other = (ObjectClassInfo)obj;
        if (!this.is(other.getType())) {
            return false;
        }
        if (!CollectionUtil.equals(this.getAttributeInfo(), other.getAttributeInfo())) {
            return false;
        }
        if (!this.isContainer == other.isContainer) {
            return false;
        }
        if (!this.isAuxiliary == other.isAuxiliary) {
            return false;
        }
        return !this.isEmbedded != other.isEmbedded;
    }

    public int hashCode() {
        return NameUtil.nameHashCode(this.type);
    }

    public String toString() {
        return SerializerUtil.serializeXmlObject(this, false);
    }
}

