/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.ConvertedRecords;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumSource;

public class MemoryRecordsBuilderTest {
    private final Time time = Time.SYSTEM;

    @Test
    public void testUnsupportedCompress() {
        BiFunction<Byte, Compression, MemoryRecordsBuilder> builderBiFunction = (magic, compression) -> new MemoryRecordsBuilder(ByteBuffer.allocate(128), magic.byteValue(), compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, 128);
        Arrays.asList((byte)0, (byte)1).forEach(magic -> {
            Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> {
                MemoryRecordsBuilder cfr_ignored_0 = (MemoryRecordsBuilder)builderBiFunction.apply((Byte)magic, (Compression)Compression.zstd().build());
            });
            Assertions.assertEquals((Object)e.getMessage(), (Object)("ZStandard compression is not supported for magic " + magic));
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteEmptyRecordSet(Args args) {
        byte magic = args.magic;
        ByteBuffer buffer = this.allocateBuffer(128, args);
        MemoryRecords records = new MemoryRecordsBuilder(buffer, magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, buffer.capacity()).build();
        Assertions.assertEquals((int)0, (int)records.sizeInBytes());
        Assertions.assertEquals((int)args.bufferOffset, (int)buffer.position());
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteTransactionalRecordSet(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        long pid = 9809L;
        short epoch = 15;
        int sequence = 2342;
        Supplier<MemoryRecordsBuilder> supplier = () -> new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, pid, epoch, sequence, true, false, -1, buffer.capacity());
        if (args.magic < 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            MemoryRecordsBuilder builder = supplier.get();
            builder.append(System.currentTimeMillis(), "foo".getBytes(), "bar".getBytes());
            MemoryRecords records = builder.build();
            List batches = Utils.toList(records.batches().iterator());
            Assertions.assertEquals((int)1, (int)batches.size());
            Assertions.assertTrue((boolean)((MutableRecordBatch)batches.get(0)).isTransactional());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteTransactionalWithInvalidPID(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        long pid = -1L;
        short epoch = 15;
        int sequence = 2342;
        Supplier<MemoryRecordsBuilder> supplier = () -> new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, pid, epoch, sequence, true, false, -1, buffer.capacity());
        if (args.magic < 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            MemoryRecordsBuilder builder = supplier.get();
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((MemoryRecordsBuilder)builder).close());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteIdempotentWithInvalidEpoch(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        long pid = 9809L;
        short epoch = -1;
        int sequence = 2342;
        Supplier<MemoryRecordsBuilder> supplier = () -> new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, pid, epoch, sequence, true, false, -1, buffer.capacity());
        if (args.magic < 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            MemoryRecordsBuilder builder = supplier.get();
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((MemoryRecordsBuilder)builder).close());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteIdempotentWithInvalidBaseSequence(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        long pid = 9809L;
        short epoch = 15;
        int sequence = -1;
        Supplier<MemoryRecordsBuilder> supplier = () -> new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, pid, epoch, sequence, true, false, -1, buffer.capacity());
        if (args.magic < 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            MemoryRecordsBuilder builder = supplier.get();
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((MemoryRecordsBuilder)builder).close());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteEndTxnMarkerNonTransactionalBatch(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        long pid = 9809L;
        short epoch = 15;
        int sequence = -1;
        Supplier<MemoryRecordsBuilder> supplier = () -> new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, pid, epoch, sequence, false, true, -1, buffer.capacity());
        if (args.magic < 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            MemoryRecordsBuilder builder = supplier.get();
            Assertions.assertThrows(IllegalArgumentException.class, () -> builder.appendEndTxnMarker(-1L, new EndTransactionMarker(ControlRecordType.ABORT, 0)));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteEndTxnMarkerNonControlBatch(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        long pid = 9809L;
        short epoch = 15;
        int sequence = -1;
        Supplier<MemoryRecordsBuilder> supplier = () -> new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, pid, epoch, sequence, true, false, -1, buffer.capacity());
        if (args.magic < 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            MemoryRecordsBuilder builder = supplier.get();
            Assertions.assertThrows(IllegalArgumentException.class, () -> builder.appendEndTxnMarker(-1L, new EndTransactionMarker(ControlRecordType.ABORT, 0)));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteLeaderChangeControlBatchWithoutLeaderEpoch(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        Supplier<MemoryRecordsBuilder> supplier = () -> new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, true, -1, buffer.capacity());
        if (args.magic < 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            boolean leaderId = true;
            MemoryRecordsBuilder builder = supplier.get();
            Assertions.assertThrows(IllegalArgumentException.class, () -> builder.appendLeaderChangeMessage(-1L, new LeaderChangeMessage().setLeaderId(1).setVoters(Collections.emptyList())));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testWriteLeaderChangeControlBatch(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        boolean leaderId = true;
        int leaderEpoch = 5;
        List<Integer> voters = Arrays.asList(2, 3);
        Supplier<MemoryRecordsBuilder> supplier = () -> new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, true, 5, buffer.capacity());
        if (args.magic < 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            MemoryRecordsBuilder builder = supplier.get();
            builder.appendLeaderChangeMessage(-1L, new LeaderChangeMessage().setLeaderId(1).setVoters(voters.stream().map(voterId -> new LeaderChangeMessage.Voter().setVoterId(voterId.intValue())).collect(Collectors.toList())));
            MemoryRecords built = builder.build();
            List records = TestUtils.toList(built.records());
            Assertions.assertEquals((int)1, (int)records.size());
            LeaderChangeMessage leaderChangeMessage = ControlRecordUtils.deserializeLeaderChangeMessage((Record)((Record)records.get(0)));
            Assertions.assertEquals((int)1, (int)leaderChangeMessage.leaderId());
            Assertions.assertEquals(voters, leaderChangeMessage.voters().stream().map(LeaderChangeMessage.Voter::voterId).collect(Collectors.toList()));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testLegacyCompressionRate(Args args) {
        byte magic = args.magic;
        ByteBuffer buffer = this.allocateBuffer(1024, args);
        Supplier<LegacyRecord[]> supplier = () -> new LegacyRecord[]{LegacyRecord.create((byte)magic, (long)0L, (byte[])"a".getBytes(), (byte[])"1".getBytes()), LegacyRecord.create((byte)magic, (long)1L, (byte[])"b".getBytes(), (byte[])"2".getBytes()), LegacyRecord.create((byte)magic, (long)2L, (byte[])"c".getBytes(), (byte[])"3".getBytes())};
        if (magic >= 2) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            LegacyRecord[] records = supplier.get();
            MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, buffer.capacity());
            int uncompressedSize = 0;
            for (LegacyRecord record : records) {
                uncompressedSize += record.sizeInBytes() + 12;
                builder.append(record);
            }
            MemoryRecords built = builder.build();
            if (args.compression.type() == CompressionType.NONE) {
                Assertions.assertEquals((double)1.0, (double)builder.compressionRatio(), (double)1.0E-5);
            } else {
                int recordHead = magic == 0 ? 14 : 22;
                int compressedSize = built.sizeInBytes() - 12 - recordHead;
                double computedCompressionRate = (double)compressedSize / (double)uncompressedSize;
                Assertions.assertEquals((double)computedCompressionRate, (double)builder.compressionRatio(), (double)1.0E-5);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testEstimatedSizeInBytes(Args args) {
        ByteBuffer buffer = this.allocateBuffer(1024, args);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, buffer.capacity());
        int previousEstimate = 0;
        for (int i = 0; i < 10; ++i) {
            builder.append(new SimpleRecord((long)i, ("" + i).getBytes()));
            int currentEstimate = builder.estimatedSizeInBytes();
            Assertions.assertTrue((currentEstimate > previousEstimate ? 1 : 0) != 0);
            previousEstimate = currentEstimate;
        }
        int bytesWrittenBeforeClose = builder.estimatedSizeInBytes();
        MemoryRecords records = builder.build();
        Assertions.assertEquals((int)records.sizeInBytes(), (int)builder.estimatedSizeInBytes());
        if (args.compression.type() == CompressionType.NONE) {
            Assertions.assertEquals((int)records.sizeInBytes(), (int)bytesWrittenBeforeClose);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void buildUsingLogAppendTime(Args args) {
        byte magic = args.magic;
        ByteBuffer buffer = this.allocateBuffer(1024, args);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, magic, args.compression, TimestampType.LOG_APPEND_TIME, 0L, logAppendTime, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.append(0L, "a".getBytes(), "1".getBytes());
        builder.append(0L, "b".getBytes(), "2".getBytes());
        builder.append(0L, "c".getBytes(), "3".getBytes());
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        Assertions.assertEquals((long)logAppendTime, (long)info.maxTimestamp);
        if (args.compression.type() == CompressionType.NONE && magic <= 1) {
            Assertions.assertEquals((long)0L, (long)info.shallowOffsetOfMaxTimestamp);
        } else {
            Assertions.assertEquals((long)2L, (long)info.shallowOffsetOfMaxTimestamp);
        }
        for (RecordBatch batch : records.batches()) {
            if (magic == 0) {
                Assertions.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)batch.timestampType());
                continue;
            }
            Assertions.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)batch.timestampType());
            for (Record record : batch) {
                Assertions.assertEquals((long)logAppendTime, (long)record.timestamp());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void buildUsingCreateTime(Args args) {
        byte magic = args.magic;
        ByteBuffer buffer = this.allocateBuffer(1024, args);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, magic, args.compression, TimestampType.CREATE_TIME, 0L, logAppendTime, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.append(0L, "a".getBytes(), "1".getBytes());
        builder.append(2L, "b".getBytes(), "2".getBytes());
        builder.append(1L, "c".getBytes(), "3".getBytes());
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        if (magic == 0) {
            Assertions.assertEquals((long)-1L, (long)info.maxTimestamp);
        } else {
            Assertions.assertEquals((long)2L, (long)info.maxTimestamp);
        }
        if (magic == 0) {
            Assertions.assertEquals((long)-1L, (long)info.shallowOffsetOfMaxTimestamp);
        } else if (args.compression.type() == CompressionType.NONE && magic == 1) {
            Assertions.assertEquals((long)1L, (long)info.shallowOffsetOfMaxTimestamp);
        } else {
            Assertions.assertEquals((long)2L, (long)info.shallowOffsetOfMaxTimestamp);
        }
        int i = 0;
        long[] expectedTimestamps = new long[]{0L, 2L, 1L};
        for (RecordBatch batch : records.batches()) {
            if (magic == 0) {
                Assertions.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)batch.timestampType());
                continue;
            }
            Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
            for (Record record : batch) {
                Assertions.assertEquals((long)expectedTimestamps[i++], (long)record.timestamp());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testAppendedChecksumConsistency(Args args) {
        ByteBuffer buffer = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, -1L, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.append(1L, "key".getBytes(), "value".getBytes());
        MemoryRecords memoryRecords = builder.build();
        List records = TestUtils.toList(memoryRecords.records());
        Assertions.assertEquals((int)1, (int)records.size());
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testSmallWriteLimit(Args args) {
        byte[] key = "foo".getBytes();
        byte[] value = "bar".getBytes();
        int writeLimit = 0;
        ByteBuffer buffer = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, -1L, -1L, -1, -1, false, false, -1, writeLimit);
        Assertions.assertFalse((boolean)builder.isFull());
        Assertions.assertTrue((boolean)builder.hasRoomFor(0L, key, value, Record.EMPTY_HEADERS));
        builder.append(0L, key, value);
        Assertions.assertTrue((boolean)builder.isFull());
        Assertions.assertFalse((boolean)builder.hasRoomFor(0L, key, value, Record.EMPTY_HEADERS));
        MemoryRecords memRecords = builder.build();
        List records = TestUtils.toList(memRecords.records());
        Assertions.assertEquals((int)1, (int)records.size());
        Record record = (Record)records.get(0);
        Assertions.assertEquals((Object)ByteBuffer.wrap(key), (Object)record.key());
        Assertions.assertEquals((Object)ByteBuffer.wrap(value), (Object)record.value());
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void writePastLimit(Args args) {
        byte magic = args.magic;
        ByteBuffer buffer = this.allocateBuffer(64, args);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, magic, args.compression, TimestampType.CREATE_TIME, 0L, logAppendTime, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.setEstimatedCompressionRatio(0.5f);
        builder.append(0L, "a".getBytes(), "1".getBytes());
        builder.append(1L, "b".getBytes(), "2".getBytes());
        Assertions.assertFalse((boolean)builder.hasRoomFor(2L, "c".getBytes(), "3".getBytes(), Record.EMPTY_HEADERS));
        builder.append(2L, "c".getBytes(), "3".getBytes());
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        if (magic == 0) {
            Assertions.assertEquals((long)-1L, (long)info.shallowOffsetOfMaxTimestamp);
            Assertions.assertEquals((long)-1L, (long)info.maxTimestamp);
        } else {
            Assertions.assertEquals((long)2L, (long)info.shallowOffsetOfMaxTimestamp);
            Assertions.assertEquals((long)2L, (long)info.maxTimestamp);
        }
        long i = 0L;
        for (RecordBatch batch : records.batches()) {
            if (magic == 0) {
                Assertions.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)batch.timestampType());
                continue;
            }
            Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
            for (Record record : batch) {
                Assertions.assertEquals((long)i++, (long)record.timestamp());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testAppendAtInvalidOffset(Args args) {
        ByteBuffer buffer = this.allocateBuffer(1024, args);
        long logAppendTime = System.currentTimeMillis();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, logAppendTime, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.appendWithOffset(0L, System.currentTimeMillis(), "a".getBytes(), null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.appendWithOffset(0L, System.currentTimeMillis(), "b".getBytes(), null));
    }

    @ParameterizedTest
    @EnumSource(value=CompressionType.class)
    public void convertV2ToV1UsingMixedCreateAndLogAppendTime(CompressionType compressionType) {
        ByteBuffer buffer = ByteBuffer.allocate(512);
        Compression compression = Compression.of((CompressionType)compressionType).build();
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (Compression)compression, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        int sizeExcludingTxnMarkers = buffer.position();
        MemoryRecords.writeEndTransactionalMarker((ByteBuffer)buffer, (long)1L, (long)System.currentTimeMillis(), (int)0, (long)15L, (short)0, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 0));
        int position = buffer.position();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(12L, "2".getBytes(), "b".getBytes());
        builder.append(13L, "3".getBytes(), "c".getBytes());
        builder.close();
        sizeExcludingTxnMarkers += buffer.position() - position;
        MemoryRecords.writeEndTransactionalMarker((ByteBuffer)buffer, (long)14L, (long)System.currentTimeMillis(), (int)0, (long)1L, (short)0, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 0));
        buffer.flip();
        Supplier<ConvertedRecords> convertedRecordsSupplier = () -> MemoryRecords.readableRecords((ByteBuffer)buffer).downConvert((byte)1, 0L, this.time);
        if (compression.type() != CompressionType.ZSTD) {
            ConvertedRecords convertedRecords = convertedRecordsSupplier.get();
            MemoryRecords records = (MemoryRecords)convertedRecords.records();
            this.verifyRecordsProcessingStats(compression, convertedRecords.recordConversionStats(), 3, 3, records.sizeInBytes(), sizeExcludingTxnMarkers);
            List batches = Utils.toList(records.batches().iterator());
            if (compression.type() != CompressionType.NONE) {
                Assertions.assertEquals((int)2, (int)batches.size());
                Assertions.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)((RecordBatch)batches.get(0)).timestampType());
                Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)((RecordBatch)batches.get(1)).timestampType());
            } else {
                Assertions.assertEquals((int)3, (int)batches.size());
                Assertions.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)((RecordBatch)batches.get(0)).timestampType());
                Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)((RecordBatch)batches.get(1)).timestampType());
                Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)((RecordBatch)batches.get(2)).timestampType());
            }
            List logRecords = Utils.toList(records.records().iterator());
            Assertions.assertEquals((int)3, (int)logRecords.size());
            Assertions.assertEquals((Object)ByteBuffer.wrap("1".getBytes()), (Object)((Record)logRecords.get(0)).key());
            Assertions.assertEquals((Object)ByteBuffer.wrap("2".getBytes()), (Object)((Record)logRecords.get(1)).key());
            Assertions.assertEquals((Object)ByteBuffer.wrap("3".getBytes()), (Object)((Record)logRecords.get(2)).key());
        } else {
            Exception e = (Exception)Assertions.assertThrows(UnsupportedCompressionTypeException.class, convertedRecordsSupplier::get);
            Assertions.assertEquals((Object)"Down-conversion of zstandard-compressed batches is not supported", (Object)e.getMessage());
        }
    }

    @ParameterizedTest
    @EnumSource(value=CompressionType.class)
    public void convertToV1WithMixedV0AndV2Data(CompressionType compressionType) {
        ByteBuffer buffer = ByteBuffer.allocate(512);
        Compression compression = Compression.of((CompressionType)compressionType).build();
        Supplier<MemoryRecordsBuilder> supplier = () -> MemoryRecords.builder((ByteBuffer)buffer, (byte)0, (Compression)compression, (TimestampType)TimestampType.NO_TIMESTAMP_TYPE, (long)0L);
        if (compressionType == CompressionType.ZSTD) {
            Assertions.assertThrows(IllegalArgumentException.class, supplier::get);
        } else {
            MemoryRecordsBuilder builder = supplier.get();
            builder.append(-1L, "1".getBytes(), "a".getBytes());
            builder.close();
            builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (Compression)compression, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
            builder.append(11L, "2".getBytes(), "b".getBytes());
            builder.append(12L, "3".getBytes(), "c".getBytes());
            builder.close();
            buffer.flip();
            ConvertedRecords convertedRecords = MemoryRecords.readableRecords((ByteBuffer)buffer).downConvert((byte)1, 0L, this.time);
            MemoryRecords records = (MemoryRecords)convertedRecords.records();
            this.verifyRecordsProcessingStats(compression, convertedRecords.recordConversionStats(), 3, 2, records.sizeInBytes(), buffer.limit());
            List batches = Utils.toList(records.batches().iterator());
            if (compressionType != CompressionType.NONE) {
                Assertions.assertEquals((int)2, (int)batches.size());
                Assertions.assertEquals((byte)0, (byte)((RecordBatch)batches.get(0)).magic());
                Assertions.assertEquals((long)0L, (long)((RecordBatch)batches.get(0)).baseOffset());
                Assertions.assertEquals((byte)1, (byte)((RecordBatch)batches.get(1)).magic());
                Assertions.assertEquals((long)1L, (long)((RecordBatch)batches.get(1)).baseOffset());
            } else {
                Assertions.assertEquals((int)3, (int)batches.size());
                Assertions.assertEquals((byte)0, (byte)((RecordBatch)batches.get(0)).magic());
                Assertions.assertEquals((long)0L, (long)((RecordBatch)batches.get(0)).baseOffset());
                Assertions.assertEquals((byte)1, (byte)((RecordBatch)batches.get(1)).magic());
                Assertions.assertEquals((long)1L, (long)((RecordBatch)batches.get(1)).baseOffset());
                Assertions.assertEquals((byte)1, (byte)((RecordBatch)batches.get(2)).magic());
                Assertions.assertEquals((long)2L, (long)((RecordBatch)batches.get(2)).baseOffset());
            }
            List logRecords = Utils.toList(records.records().iterator());
            Assertions.assertEquals((Object)"1", (Object)Utils.utf8((ByteBuffer)((Record)logRecords.get(0)).key()));
            Assertions.assertEquals((Object)"2", (Object)Utils.utf8((ByteBuffer)((Record)logRecords.get(1)).key()));
            Assertions.assertEquals((Object)"3", (Object)Utils.utf8((ByteBuffer)((Record)logRecords.get(2)).key()));
            convertedRecords = MemoryRecords.readableRecords((ByteBuffer)buffer).downConvert((byte)1, 2L, this.time);
            records = (MemoryRecords)convertedRecords.records();
            batches = Utils.toList(records.batches().iterator());
            logRecords = Utils.toList(records.records().iterator());
            if (compressionType != CompressionType.NONE) {
                Assertions.assertEquals((int)2, (int)batches.size());
                Assertions.assertEquals((byte)0, (byte)((RecordBatch)batches.get(0)).magic());
                Assertions.assertEquals((long)0L, (long)((RecordBatch)batches.get(0)).baseOffset());
                Assertions.assertEquals((byte)1, (byte)((RecordBatch)batches.get(1)).magic());
                Assertions.assertEquals((long)1L, (long)((RecordBatch)batches.get(1)).baseOffset());
                Assertions.assertEquals((Object)"1", (Object)Utils.utf8((ByteBuffer)((Record)logRecords.get(0)).key()));
                Assertions.assertEquals((Object)"2", (Object)Utils.utf8((ByteBuffer)((Record)logRecords.get(1)).key()));
                Assertions.assertEquals((Object)"3", (Object)Utils.utf8((ByteBuffer)((Record)logRecords.get(2)).key()));
                this.verifyRecordsProcessingStats(compression, convertedRecords.recordConversionStats(), 3, 2, records.sizeInBytes(), buffer.limit());
            } else {
                Assertions.assertEquals((int)2, (int)batches.size());
                Assertions.assertEquals((byte)0, (byte)((RecordBatch)batches.get(0)).magic());
                Assertions.assertEquals((long)0L, (long)((RecordBatch)batches.get(0)).baseOffset());
                Assertions.assertEquals((byte)1, (byte)((RecordBatch)batches.get(1)).magic());
                Assertions.assertEquals((long)2L, (long)((RecordBatch)batches.get(1)).baseOffset());
                Assertions.assertEquals((Object)"1", (Object)Utils.utf8((ByteBuffer)((Record)logRecords.get(0)).key()));
                Assertions.assertEquals((Object)"3", (Object)Utils.utf8((ByteBuffer)((Record)logRecords.get(1)).key()));
                this.verifyRecordsProcessingStats(compression, convertedRecords.recordConversionStats(), 3, 1, records.sizeInBytes(), buffer.limit());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void shouldThrowIllegalStateExceptionOnBuildWhenAborted(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.abort();
        Assertions.assertThrows(IllegalStateException.class, () -> ((MemoryRecordsBuilder)builder).build());
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void shouldResetBufferToInitialPositionOnAbort(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.append(0L, "a".getBytes(), "1".getBytes());
        builder.abort();
        Assertions.assertEquals((int)args.bufferOffset, (int)builder.buffer().position());
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void shouldThrowIllegalStateExceptionOnCloseWhenAborted(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.abort();
        Assertions.assertThrows(IllegalStateException.class, () -> ((MemoryRecordsBuilder)builder).close(), (String)"Should have thrown IllegalStateException");
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void shouldThrowIllegalStateExceptionOnAppendWhenAborted(Args args) {
        ByteBuffer buffer = this.allocateBuffer(128, args);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, buffer.capacity());
        builder.abort();
        Assertions.assertThrows(IllegalStateException.class, () -> builder.append(0L, "a".getBytes(), "1".getBytes()), (String)"Should have thrown IllegalStateException");
    }

    @ParameterizedTest
    @ArgumentsSource(value=MemoryRecordsBuilderArgumentsProvider.class)
    public void testBuffersDereferencedOnClose(Args args) {
        Runtime runtime = Runtime.getRuntime();
        int payloadLen = 0x100000;
        ByteBuffer buffer = ByteBuffer.allocate(payloadLen * 2);
        byte[] key = new byte[]{};
        byte[] value = new byte[payloadLen];
        new Random().nextBytes(value);
        ArrayList<MemoryRecordsBuilder> builders = new ArrayList<MemoryRecordsBuilder>(100);
        long startMem = 0L;
        long memUsed = 0L;
        int iterations = 0;
        while (iterations++ < 100) {
            buffer.rewind();
            MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, 0);
            builder.append(1L, key, value);
            builder.build();
            builders.add(builder);
            System.gc();
            memUsed = runtime.totalMemory() - runtime.freeMemory() - startMem;
            if (iterations == 2) {
                startMem = memUsed;
                continue;
            }
            if (iterations <= 2 || memUsed >= (long)((iterations - 2) * 1024)) continue;
            break;
        }
        Assertions.assertTrue((iterations < 100 ? 1 : 0) != 0, (String)("Memory usage too high: " + memUsed));
    }

    @ParameterizedTest
    @ArgumentsSource(value=V2MemoryRecordsBuilderArgumentsProvider.class)
    public void testRecordTimestampsWithDeleteHorizon(Args args) {
        long deleteHorizon = 100L;
        int payloadLen = 0x100000;
        ByteBuffer buffer = ByteBuffer.allocate(payloadLen * 2);
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(buffer);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(byteBufferOutputStream, args.magic, args.compression, TimestampType.CREATE_TIME, 0L, 0L, -1L, -1, -1, false, false, -1, 0, deleteHorizon);
        builder.append(50L, "0".getBytes(), "0".getBytes());
        builder.append(100L, "1".getBytes(), null);
        builder.append(150L, "2".getBytes(), "2".getBytes());
        MemoryRecords records = builder.build();
        List batches = TestUtils.toList(records.batches());
        Assertions.assertEquals((Object)OptionalLong.of(deleteHorizon), (Object)((MutableRecordBatch)batches.get(0)).deleteHorizonMs());
        CloseableIterator recordIterator = ((MutableRecordBatch)batches.get(0)).streamingIterator(BufferSupplier.create());
        Record record = (Record)recordIterator.next();
        Assertions.assertEquals((long)50L, (long)record.timestamp());
        record = (Record)recordIterator.next();
        Assertions.assertEquals((long)100L, (long)record.timestamp());
        record = (Record)recordIterator.next();
        Assertions.assertEquals((long)150L, (long)record.timestamp());
        recordIterator.close();
    }

    private void verifyRecordsProcessingStats(Compression compression, RecordValidationStats processingStats, int numRecords, int numRecordsConverted, long finalBytes, long preConvertedBytes) {
        Assertions.assertNotNull((Object)processingStats, (String)"Records processing info is null");
        Assertions.assertEquals((int)numRecordsConverted, (int)processingStats.numRecordsConverted());
        Assertions.assertTrue((processingStats.conversionTimeNanos() >= 0L ? 1 : 0) != 0, (String)("Processing time not recorded: " + processingStats));
        long tempBytes = processingStats.temporaryMemoryBytes();
        if (compression.type() == CompressionType.NONE) {
            if (numRecordsConverted == 0) {
                Assertions.assertEquals((long)finalBytes, (long)tempBytes);
            } else if (numRecordsConverted == numRecords) {
                Assertions.assertEquals((long)(preConvertedBytes + finalBytes), (long)tempBytes);
            } else {
                Assertions.assertTrue((tempBytes > finalBytes && tempBytes < finalBytes + preConvertedBytes ? 1 : 0) != 0, (String)String.format("Unexpected temp bytes %d final %d pre %d", tempBytes, finalBytes, preConvertedBytes));
            }
        } else {
            long compressedBytes = finalBytes - 12L - 14L;
            Assertions.assertTrue((tempBytes > compressedBytes ? 1 : 0) != 0, (String)String.format("Uncompressed size expected temp=%d, compressed=%d", tempBytes, compressedBytes));
        }
    }

    private ByteBuffer allocateBuffer(int size, Args args) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.position(args.bufferOffset);
        return buffer;
    }

    private static class V2MemoryRecordsBuilderArgumentsProvider
    implements ArgumentsProvider {
        private V2MemoryRecordsBuilderArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            ArrayList<Arguments> values = new ArrayList<Arguments>();
            for (int bufferOffset : Arrays.asList(0, 15)) {
                for (CompressionType type : CompressionType.values()) {
                    values.add(Arguments.of((Object[])new Object[]{new Args(bufferOffset, Compression.of((CompressionType)type).build(), 2)}));
                }
            }
            return values.stream();
        }
    }

    private static class MemoryRecordsBuilderArgumentsProvider
    implements ArgumentsProvider {
        private MemoryRecordsBuilderArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            ArrayList<Arguments> values = new ArrayList<Arguments>();
            for (int bufferOffset : Arrays.asList(0, 15)) {
                for (CompressionType type : CompressionType.values()) {
                    List<Byte> magics = type == CompressionType.ZSTD ? Collections.singletonList((byte)2) : Arrays.asList((byte)0, (byte)1, (byte)2);
                    for (byte magic : magics) {
                        values.add(Arguments.of((Object[])new Object[]{new Args(bufferOffset, Compression.of((CompressionType)type).build(), magic)}));
                    }
                }
            }
            return values.stream();
        }
    }

    private static class Args {
        final int bufferOffset;
        final Compression compression;
        final byte magic;

        public Args(int bufferOffset, Compression compression, byte magic) {
            this.bufferOffset = bufferOffset;
            this.compression = compression;
            this.magic = magic;
        }

        public String toString() {
            return "magic=" + this.magic + ", bufferOffset=" + this.bufferOffset + ", compression=" + this.compression;
        }
    }
}

