/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

public class AddPartitionsToTxnRequestTest {
    private static final int PRODUCER_ID = 10;
    private static final short PRODUCER_EPOCH = 1;
    private static final int THROTTLE_TIME_MS = 10;
    private static final TopicPartition TP_0 = new TopicPartition("topic", 0);
    private static final TopicPartition TP_1 = new TopicPartition("topic", 1);
    private final String transactionalId1 = "transaction1";
    private final String transactionalId2 = "transaction2";

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.ADD_PARTITIONS_TO_TXN)
    public void testConstructor(short version) {
        AddPartitionsToTxnRequest request;
        if (version < 4) {
            ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
            partitions.add(TP_0);
            partitions.add(TP_1);
            AddPartitionsToTxnRequest.Builder builder = AddPartitionsToTxnRequest.Builder.forClient((String)"transaction1", (long)10L, (short)1, partitions);
            request = builder.build(version);
            Assertions.assertEquals((Object)"transaction1", (Object)request.data().v3AndBelowTransactionalId());
            Assertions.assertEquals((long)10L, (long)request.data().v3AndBelowProducerId());
            Assertions.assertEquals((short)1, (short)request.data().v3AndBelowProducerEpoch());
            Assertions.assertEquals(partitions, (Object)AddPartitionsToTxnRequest.getPartitions((AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection)request.data().v3AndBelowTopics()));
        } else {
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = this.createTwoTransactionCollection();
            AddPartitionsToTxnRequest.Builder builder = AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions);
            request = builder.build(version);
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction reqTxn1 = request.data().transactions().find("transaction1");
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction reqTxn2 = request.data().transactions().find("transaction2");
            Assertions.assertEquals((Object)transactions.find("transaction1"), (Object)reqTxn1);
            Assertions.assertEquals((Object)transactions.find("transaction2"), (Object)reqTxn2);
        }
        AddPartitionsToTxnResponse response = request.getErrorResponse(10, (Throwable)Errors.UNKNOWN_TOPIC_OR_PARTITION.exception());
        Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
        if (version >= 4) {
            Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)response.data().errorCode());
            Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_TOPIC_OR_PARTITION, 1), (Object)response.errorCounts());
        } else {
            Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_TOPIC_OR_PARTITION, 2), (Object)response.errorCounts());
        }
    }

    @Test
    public void testBatchedRequests() {
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = this.createTwoTransactionCollection();
        AddPartitionsToTxnRequest.Builder builder = AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions);
        AddPartitionsToTxnRequest request = builder.build(ApiKeys.ADD_PARTITIONS_TO_TXN.latestVersion());
        HashMap<String, List<TopicPartition>> expectedMap = new HashMap<String, List<TopicPartition>>();
        expectedMap.put("transaction1", Collections.singletonList(TP_0));
        expectedMap.put("transaction2", Collections.singletonList(TP_1));
        Assertions.assertEquals(expectedMap, (Object)request.partitionsByTransaction());
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection results = new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection();
        results.add((ImplicitLinkedHashCollection.Element)request.errorResponseForTransaction("transaction1", Errors.UNKNOWN_TOPIC_OR_PARTITION));
        results.add((ImplicitLinkedHashCollection.Element)request.errorResponseForTransaction("transaction2", Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED));
        AddPartitionsToTxnResponse response = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setResultsByTransaction(results).setThrottleTimeMs(10));
        Assertions.assertEquals(Collections.singletonMap(TP_0, Errors.UNKNOWN_TOPIC_OR_PARTITION), (Object)AddPartitionsToTxnResponse.errorsForTransaction((AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection)response.getTransactionTopicResults("transaction1")));
        Assertions.assertEquals(Collections.singletonMap(TP_1, Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED), (Object)AddPartitionsToTxnResponse.errorsForTransaction((AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection)response.getTransactionTopicResults("transaction2")));
    }

    @Test
    public void testNormalizeRequest() {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        partitions.add(TP_0);
        partitions.add(TP_1);
        AddPartitionsToTxnRequest.Builder builder = AddPartitionsToTxnRequest.Builder.forClient((String)"transaction1", (long)10L, (short)1, partitions);
        AddPartitionsToTxnRequest request = builder.build((short)3);
        AddPartitionsToTxnRequest singleton = request.normalizeRequest();
        Assertions.assertEquals(partitions, singleton.partitionsByTransaction().get("transaction1"));
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction transaction = singleton.data().transactions().find("transaction1");
        Assertions.assertEquals((long)10L, (long)transaction.producerId());
        Assertions.assertEquals((short)1, (short)transaction.producerEpoch());
    }

    private AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection createTwoTransactionCollection() {
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics0 = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
        topics0.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(TP_0.topic()).setPartitions(Collections.singletonList(TP_0.partition())));
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics1 = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
        topics1.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(TP_1.topic()).setPartitions(Collections.singletonList(TP_1.partition())));
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection();
        transactions.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId("transaction1").setProducerId(10L).setProducerEpoch((short)1).setVerifyOnly(true).setTopics(topics0));
        transactions.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId("transaction2").setProducerId(11L).setProducerEpoch((short)2).setVerifyOnly(false).setTopics(topics1));
        return transactions;
    }
}

