/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import net.shibboleth.shared.xml.ParserPool;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.pac4j.core.adapter.FrameworkAdapter;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.util.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class Configuration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);

    private Configuration() {
    }

    private static void bootstrap() {
        ServiceLoader<ConfigurationManager> configurationManagers = ServiceLoader.load(ConfigurationManager.class, Configuration.class.getClassLoader());
        if (configurationManagers.findFirst().isEmpty()) {
            configurationManagers = ServiceLoader.load(ConfigurationManager.class);
        }
        ArrayList configurationManagerList = new ArrayList();
        configurationManagers.forEach(configurationManagerList::add);
        if (!configurationManagerList.isEmpty()) {
            configurationManagerList.sort((arg_0, arg_1) -> ((FrameworkAdapter)FrameworkAdapter.INSTANCE).compareManagers(arg_0, arg_1));
            ((ConfigurationManager)configurationManagerList.get(0)).configure();
        }
    }

    public static ParserPool getParserPool() {
        return XMLObjectProviderRegistrySupport.getParserPool();
    }

    public static XMLObjectBuilderFactory getBuilderFactory() {
        return XMLObjectProviderRegistrySupport.getBuilderFactory();
    }

    public static MarshallerFactory getMarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getMarshallerFactory();
    }

    public static UnmarshallerFactory getUnmarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }

    public static StringWriter serializeSamlObject(XMLObject samlObject) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(samlObject.getElementQName());
            if (marshaller != null) {
                Element element = marshaller.marshall(samlObject);
                DOMSource domSource = new DOMSource(element);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(domSource, result);
            }
        }
        catch (Exception e) {
            throw new SAMLException(e.getMessage(), e);
        }
        return writer;
    }

    public static Optional<XMLObject> deserializeSamlObject(String obj) {
        StringReader reader = new StringReader(obj);
        try {
            Optional<XMLObject> optional = Optional.of(XMLObjectSupport.unmarshallFromReader((ParserPool)Configuration.getParserPool(), (Reader)reader));
            reader.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Error unmarshalling message from input stream", (Throwable)e);
                return Optional.empty();
            }
        }
    }

    static {
        LOGGER.info("Bootstrapping OpenSAML configuration via Pac4j...");
        Configuration.bootstrap();
    }
}

