/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.DateOps;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxGridFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.MultiFieldPanel;
import org.apache.syncope.common.lib.Schema;
import org.apache.syncope.common.lib.report.SearchCondition;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class BeanPanel<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = 3905038169553185171L;
    protected static final Logger LOG = LoggerFactory.getLogger(BeanPanel.class);
    @SpringBean
    protected SchemaRestClient schemaRestClient;
    protected final List<String> excluded;
    protected final Map<String, Pair<AbstractFiqlSearchConditionBuilder<?, ?, ?>, List<SearchClause>>> sCondWrapper;

    public BeanPanel(String id, IModel<T> bean, PageReference pageRef, String ... excluded) {
        this(id, bean, null, pageRef, excluded);
    }

    public BeanPanel(String id, final IModel<T> bean, Map<String, Pair<AbstractFiqlSearchConditionBuilder<?, ?, ?>, List<SearchClause>>> sCondWrapper, final PageReference pageRef, String ... excluded) {
        super(id, bean);
        this.setOutputMarkupId(true);
        this.sCondWrapper = sCondWrapper;
        this.excluded = new ArrayList<String>(List.of(excluded));
        this.excluded.add("serialVersionUID");
        this.excluded.add("class");
        LoadableDetachableModel<List<Field>> model = new LoadableDetachableModel<List<Field>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<Field> load() {
                ArrayList<Field> result = new ArrayList<Field>();
                if (BeanPanel.this.getDefaultModelObject() != null) {
                    ReflectionUtils.doWithFields(BeanPanel.this.getDefaultModelObject().getClass(), result::add, field -> !field.isSynthetic() && !BeanPanel.this.excluded.contains(field.getName()));
                }
                return result;
            }
        };
        this.add(new Component[]{new ListView<Field>("propView", (IModel)model){
            private static final long serialVersionUID = 9101744072914090143L;

            private void setRequired(ListItem<Field> item, boolean required) {
                if (required) {
                    Fragment fragment = new Fragment("required", "requiredFragment", (MarkupContainer)this);
                    fragment.add(new Component[]{new Label("requiredLabel", (Serializable)((Object)"*"))});
                    item.replace((Component)fragment);
                }
            }

            private void setDescription(ListItem<Field> item, String description) {
                Fragment fragment = new Fragment("description", "descriptionFragment", (MarkupContainer)this);
                fragment.add(new Component[]{new Label("descriptionLabel", (IModel)Model.of()).add(new Behavior[]{new PopoverBehavior((IModel)Model.of(), (IModel)Model.of((Serializable)((Object)description)), new PopoverConfig().withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.right)){
                    private static final long serialVersionUID = -7867802555691605021L;

                    protected String createRelAttribute() {
                        return "description";
                    }
                }}).setRenderBodyOnly(false)});
                item.replace((Component)fragment);
            }

            protected void populateItem(ListItem<Field> item) {
                Object panel;
                item.add(new Component[]{new Fragment("required", "emptyFragment", (MarkupContainer)this)});
                item.add(new Component[]{new Fragment("description", "emptyFragment", (MarkupContainer)this)});
                Field field = (Field)item.getModelObject();
                item.add(new Component[]{new Label("fieldName", (IModel)new ResourceModel(field.getName(), field.getName()))});
                SearchCondition scondAnnot = field.getAnnotation(SearchCondition.class);
                if (scondAnnot != null) {
                    BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean.getObject());
                    String fiql = (String)wrapper.getPropertyValue(field.getName());
                    List clauses = Optional.ofNullable(fiql).map(f -> SearchUtils.getSearchClauses(f.replaceAll(SearchUtils.getTypeConditionPattern(scondAnnot.type()).pattern(), ""))).orElseGet(ArrayList::new);
                    Optional.ofNullable(BeanPanel.this.sCondWrapper).ifPresent(arg_0 -> 2.lambda$populateItem$1(field, (AbstractFiqlSearchConditionBuilder)(switch (scondAnnot.type()) {
                        case "USER" -> {
                            panel = new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses), pageRef).required(false).build("value");
                            yield SyncopeClient.getUserSearchConditionBuilder();
                        }
                        case "GROUP" -> {
                            panel = new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses), pageRef).required(false).build("value");
                            yield SyncopeClient.getGroupSearchConditionBuilder();
                        }
                        default -> {
                            panel = new AnyObjectSearchPanel.Builder(scondAnnot.type(), (IModel<List<SearchClause>>)new ListModel(clauses), pageRef).required(false).build("value");
                            yield SyncopeClient.getAnyObjectSearchConditionBuilder((String)scondAnnot.type());
                        }
                    }), clauses, arg_0));
                } else if (List.class.equals(field.getType())) {
                    Class clazz;
                    Type clauses = field.getGenericType();
                    if (clauses instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)clauses;
                        clazz = (Class)parameterizedType.getActualTypeArguments()[0];
                    } else {
                        clazz = String.class;
                    }
                    Class listItemType = clazz;
                    Schema schema = field.getAnnotation(Schema.class);
                    if (listItemType.equals(String.class) && schema != null) {
                        ArrayList choices = new ArrayList();
                        block12: for (SchemaType type : schema.type()) {
                            switch (type) {
                                case PLAIN: {
                                    choices.addAll(BeanPanel.this.schemaRestClient.getSchemas(SchemaType.PLAIN, schema.anyTypeKind()));
                                    continue block12;
                                }
                                case DERIVED: {
                                    choices.addAll(BeanPanel.this.schemaRestClient.getSchemas(SchemaType.DERIVED, schema.anyTypeKind()));
                                    continue block12;
                                }
                            }
                        }
                        panel = new AjaxPalettePanel.Builder().setName(field.getName()).build("value", (IModel)new PropertyModel(bean.getObject(), field.getName()), (IModel)new ListModel(choices.stream().map(SchemaTO::getKey).collect(Collectors.toList()))).hideLabel();
                    } else if (listItemType.isEnum()) {
                        panel = new AjaxPalettePanel.Builder().setName(field.getName()).build("value", (IModel)new PropertyModel(bean.getObject(), field.getName()), (IModel)new ListModel(List.of(listItemType.getEnumConstants()))).hideLabel();
                    } else {
                        SinglePanel single = BeanPanel.this.buildSinglePanel((Serializable)bean.getObject(), field.getType(), field.getName(), field.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class), "panel");
                        this.setRequired(item, single.required);
                        single.description().ifPresent(description -> this.setDescription(item, (String)description));
                        panel = new MultiFieldPanel.Builder((IModel)new PropertyModel(bean.getObject(), field.getName())).build("value", field.getName(), single.panel()).hideLabel();
                    }
                } else if (Map.class.equals(field.getType())) {
                    panel = new AjaxGridFieldPanel("value", field.getName(), (IModel)new PropertyModel((Object)bean, field.getName()), false).hideLabel();
                    Optional.ofNullable(field.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class)).ifPresent(annot -> this.setDescription(item, annot.description()));
                } else {
                    SinglePanel single = BeanPanel.this.buildSinglePanel((Serializable)bean.getObject(), field.getType(), field.getName(), field.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class), "value");
                    this.setRequired(item, single.required());
                    single.description().ifPresent(description -> this.setDescription(item, (String)description));
                    panel = single.panel().hideLabel();
                }
                item.add(new Component[]{panel.setRenderBodyOnly(true)});
            }

            private static /* synthetic */ void lambda$populateItem$1(Field field, AbstractFiqlSearchConditionBuilder builder, List clauses, Map scw) {
                scw.put(field.getName(), Pair.of((Object)builder, (Object)clauses));
            }
        }.setReuseItems(false)});
    }

    private SinglePanel buildSinglePanel(final Serializable bean, Class<?> type, final String fieldName, io.swagger.v3.oas.annotations.media.Schema schema, String id) {
        AjaxCheckBoxPanel panel;
        PropertyModel model = new PropertyModel((Object)bean, fieldName);
        if (ClassUtils.isAssignable(Boolean.class, type)) {
            panel = new AjaxCheckBoxPanel(id, fieldName, (IModel)model);
        } else if (ClassUtils.isAssignable(Number.class, type)) {
            panel = new AjaxNumberFieldPanel.Builder().build(id, fieldName, AjaxNumberFieldPanel.cast((Class)ClassUtils.resolvePrimitiveIfNecessary(type)), (IModel)model);
        } else if (Date.class.equals(type)) {
            panel = new AjaxDateTimeFieldPanel(id, fieldName, (IModel)model, DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT);
        } else if (OffsetDateTime.class.equals(type)) {
            panel = new AjaxDateTimeFieldPanel(id, fieldName, (IModel)DateOps.WrappedDateModel.ofOffset((IModel)model), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT);
        } else if (ZonedDateTime.class.equals(type)) {
            panel = new AjaxDateTimeFieldPanel(id, fieldName, (IModel)DateOps.WrappedDateModel.ofZoned((IModel)model), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT);
        } else if (LocalDateTime.class.equals(type)) {
            panel = new AjaxDateTimeFieldPanel(id, fieldName, (IModel)DateOps.WrappedDateModel.ofLocal((IModel)model), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT);
        } else if (type.isEnum()) {
            panel = new AjaxDropDownChoicePanel(id, fieldName, (IModel)model).setChoices(List.of(type.getEnumConstants()));
        } else if (Duration.class.equals(type)) {
            panel = new AjaxTextFieldPanel(id, fieldName, (IModel)new IModel<String>(){
                private static final long serialVersionUID = 807008909842554829L;

                public String getObject() {
                    return Optional.ofNullable(PropertyResolver.getValue((String)fieldName, (Object)bean)).map(Object::toString).orElse(null);
                }

                public void setObject(String object) {
                    PropertyResolverConverter prc = new PropertyResolverConverter(SyncopeWebApplication.get().getConverterLocator(), SyncopeConsoleSession.get().getLocale());
                    PropertyResolver.setValue((String)fieldName, (Object)bean, (Object)Duration.parse(object), (PropertyResolverConverter)prc);
                }
            });
        } else if (URI.class.equals(type)) {
            panel = new AjaxTextFieldPanel(id, fieldName, (IModel)new IModel<String>(){
                private static final long serialVersionUID = -608076080746590282L;

                public String getObject() {
                    return Optional.ofNullable(PropertyResolver.getValue((String)fieldName, (Object)bean)).map(o -> ((URI)o).toASCIIString()).orElse(null);
                }

                public void setObject(String object) {
                    PropertyResolverConverter prc = new PropertyResolverConverter(SyncopeWebApplication.get().getConverterLocator(), SyncopeConsoleSession.get().getLocale());
                    PropertyResolver.setValue((String)fieldName, (Object)bean, (Object)(object == null ? null : URI.create(object)), (PropertyResolverConverter)prc);
                }
            });
            panel.getField().add((IValidator)new UrlValidator(new String[]{"http", "https"}));
        } else {
            panel = new AjaxTextFieldPanel(id, fieldName, (IModel)model);
        }
        boolean required = false;
        Optional<String> description = Optional.empty();
        if (schema != null) {
            panel.setReadOnly(schema.accessMode() == Schema.AccessMode.READ_ONLY);
            required = schema.requiredMode() == Schema.RequiredMode.REQUIRED;
            panel.setRequired(required);
            Optional.ofNullable(schema.example()).ifPresent(arg_0 -> ((FieldPanel)panel).setPlaceholder(arg_0));
            description = Optional.ofNullable(schema.description());
            if (panel instanceof AjaxTextFieldPanel) {
                AjaxTextFieldPanel components = (AjaxTextFieldPanel)panel;
                if (panel.getModelObject() == null && schema.defaultValue() != null) {
                    components.setModelObject((Serializable)((Object)schema.defaultValue()));
                }
            }
        }
        return new SinglePanel((FieldPanel<Serializable>)panel, required, description);
    }

    private record SinglePanel(FieldPanel<Serializable> panel, Boolean required, Optional<String> description) {
    }
}

