/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import jakarta.ws.rs.core.GenericType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.ui.commons.status.Status;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.status.StatusUtils;
import org.apache.syncope.common.lib.request.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.StatusRType;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.common.rest.api.service.UserService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class UserRestClient
extends AbstractAnyRestClient<UserTO> {
    private static final long serialVersionUID = -1575748964398293968L;

    @Override
    protected Class<? extends AnyService<UserTO>> getAnyServiceClass() {
        return UserService.class;
    }

    public ProvisioningResult<UserTO> create(UserCR createReq) {
        return (ProvisioningResult)this.getService(UserService.class).create(createReq).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(this){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningResult<UserTO> update(String etag, UserUR updateReq) {
        ProvisioningResult result;
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            result = (ProvisioningResult)this.getService(etag, UserService.class).update(updateReq).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(this){});
            this.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    @Override
    public long count(String realm, String fiql) {
        return this.getService(UserService.class).search((AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm(realm).fiql(fiql).page(Integer.valueOf(1))).size(Integer.valueOf(0))).details(false).build()).getTotalCount();
    }

    @Override
    public List<UserTO> search(String realm, String fiql, int page, int size, SortParam<String> sort) {
        return this.getService(UserService.class).search((AnyQuery)((AnyQuery.Builder)((AnyQuery.Builder)((AnyQuery.Builder)new AnyQuery.Builder().realm(realm).fiql(fiql).page(Integer.valueOf(page))).size(Integer.valueOf(size))).details(false).orderBy(UserRestClient.toOrderBy(sort))).details(false).build()).getResult();
    }

    public ProvisioningResult<UserTO> mustChangePassword(String etag, boolean value, String key) {
        UserUR userUR = (UserUR)new UserUR.Builder(key).mustChangePassword((BooleanReplacePatchItem)((BooleanReplacePatchItem.Builder)new BooleanReplacePatchItem.Builder().value((Object)value)).build()).build();
        return this.update(etag, userUR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> status(StatusRType type, String etag, String userKey, List<StatusBean> statuses) {
        HashMap<String, String> results;
        StatusR statusR = StatusUtils.statusR((String)userKey, (StatusRType)type, statuses);
        UserRestClient userRestClient = this;
        synchronized (userRestClient) {
            ProvisioningResult provisioningResult = (ProvisioningResult)this.getService(etag, UserService.class).status(statusR).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(this){});
            statuses.forEach(statusBean -> statusBean.setStatus(Status.UNDEFINED));
            results = new HashMap<String, String>();
            provisioningResult.getPropagationStatuses().forEach(propagationStatus -> {
                Boolean enabled;
                results.put(propagationStatus.getResource(), propagationStatus.getStatus().name());
                if (propagationStatus.getAfterObj() != null && (enabled = StatusUtils.isEnabled((ConnObject)propagationStatus.getAfterObj())) != null) {
                    statuses.stream().filter(statusBean -> propagationStatus.getResource().equals(statusBean.getResource())).findFirst().ifPresent(statusBean -> statusBean.setStatus(enabled != false ? Status.ACTIVE : Status.SUSPENDED));
                }
            });
            statuses.stream().filter(statusBean -> "syncope".equals(statusBean.getResource())).findFirst().ifPresent(statusBean -> statusBean.setStatus("suspended".equalsIgnoreCase(((UserTO)provisioningResult.getEntity()).getStatus()) ? Status.SUSPENDED : Status.ACTIVE));
            if (statusR.isOnSyncope()) {
                results.put("syncope", "suspended".equalsIgnoreCase(((UserTO)provisioningResult.getEntity()).getStatus()) && type == StatusRType.SUSPEND || "active".equalsIgnoreCase(((UserTO)provisioningResult.getEntity()).getStatus()) && type == StatusRType.REACTIVATE ? ExecStatus.SUCCESS.name() : ExecStatus.FAILURE.name());
            }
            this.resetClient(UserService.class);
        }
        return results;
    }

    public Map<String, String> suspend(String etag, String userKey, List<StatusBean> statuses) {
        return this.status(StatusRType.SUSPEND, etag, userKey, statuses);
    }

    public Map<String, String> reactivate(String etag, String userKey, List<StatusBean> statuses) {
        return this.status(StatusRType.REACTIVATE, etag, userKey, statuses);
    }
}

