/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.beans.Introspector;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.log.LogAccessor;
import org.springframework.integration.channel.DefaultHeaderChannelRegistry;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.GlobalChannelInterceptorProcessor;
import org.springframework.integration.config.IdGeneratorConfigurer;
import org.springframework.integration.config.IntegrationConfigUtils;
import org.springframework.integration.config.IntegrationConfigurationReport;
import org.springframework.integration.config.IntegrationEvaluationContextFactoryBean;
import org.springframework.integration.config.IntegrationSimpleEvaluationContextFactoryBean;
import org.springframework.integration.context.IntegrationProperties;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.integration.handler.support.IntegrationMessageHandlerMethodFactory;
import org.springframework.integration.json.JsonPathUtils;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.SmartLifecycleRoleController;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.converter.ConfigurableCompositeMessageConverter;
import org.springframework.integration.support.converter.DefaultDatatypeChannelMessageConverter;
import org.springframework.integration.support.management.ControlBusCommandRegistry;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ClassUtils;

public class DefaultConfiguringBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final LogAccessor LOGGER = new LogAccessor(DefaultConfiguringBeanFactoryPostProcessor.class);
    private static final Set<Integer> REGISTRIES_PROCESSED = new HashSet<Integer>();
    private static final Class<?> XPATH_CLASS;
    private static final boolean JSON_PATH_PRESENT;
    private ConfigurableListableBeanFactory beanFactory;
    private BeanDefinitionRegistry registry;

    DefaultConfiguringBeanFactoryPostProcessor() {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
        this.beanFactory = (ConfigurableListableBeanFactory)registry;
        this.registerBeanFactoryChannelResolver();
        this.registerMessagePublishingErrorHandler();
        this.registerNullChannel();
        this.registerErrorChannel();
        this.registerIntegrationEvaluationContext();
        this.registerTaskScheduler();
        this.registerIdGeneratorConfigurer();
        this.registerIntegrationProperties();
        this.registerBuiltInBeans();
        this.registerRoleController();
        this.registerMessageBuilderFactory();
        this.registerHeaderChannelRegistry();
        this.registerGlobalChannelInterceptorProcessor();
        this.registerDefaultDatatypeChannelMessageConverter();
        this.registerArgumentResolverMessageConverter();
        this.registerMessageHandlerMethodFactory();
        this.registerListMessageHandlerMethodFactory();
        this.registerIntegrationConfigurationReport();
        this.registerControlBusCommandRegistry();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void registerBeanFactoryChannelResolver() {
        if (!this.beanFactory.containsBeanDefinition("integrationChannelResolver")) {
            this.registry.registerBeanDefinition("integrationChannelResolver", (BeanDefinition)new RootBeanDefinition(BeanFactoryChannelResolver.class));
        }
    }

    private void registerMessagePublishingErrorHandler() {
        if (!this.beanFactory.containsBeanDefinition("integrationMessagePublishingErrorHandler")) {
            this.registry.registerBeanDefinition("integrationMessagePublishingErrorHandler", (BeanDefinition)new RootBeanDefinition(MessagePublishingErrorHandler.class));
        }
    }

    private void registerNullChannel() {
        if (this.beanFactory.containsBean("nullChannel")) {
            BeanDefinition nullChannelDefinition = null;
            ConfigurableListableBeanFactory beanFactoryToUse = this.beanFactory;
            do {
                ConfigurableListableBeanFactory listable;
                if (beanFactoryToUse instanceof ConfigurableListableBeanFactory && (listable = beanFactoryToUse).containsBeanDefinition("nullChannel")) {
                    nullChannelDefinition = listable.getBeanDefinition("nullChannel");
                }
                if (!(beanFactoryToUse instanceof HierarchicalBeanFactory)) continue;
                HierarchicalBeanFactory hierarchicalBeanFactory = (HierarchicalBeanFactory)beanFactoryToUse;
                beanFactoryToUse = hierarchicalBeanFactory.getParentBeanFactory();
            } while (nullChannelDefinition == null);
            if (!NullChannel.class.getName().equals(nullChannelDefinition.getBeanClassName())) {
                throw new IllegalStateException("The bean name 'nullChannel' is reserved.");
            }
        } else {
            this.registry.registerBeanDefinition("nullChannel", (BeanDefinition)new RootBeanDefinition(NullChannel.class));
        }
    }

    private void registerErrorChannel() {
        if (!this.beanFactory.containsBean("errorChannel")) {
            LOGGER.info(() -> "No bean named 'errorChannel' has been explicitly defined. Therefore, a default PublishSubscribeChannel will be created.");
            this.registry.registerBeanDefinition("errorChannel", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(PublishSubscribeChannel.class).addConstructorArgValue((Object)IntegrationProperties.getExpressionFor("spring.integration.channels.error.requireSubscribers")).addPropertyValue("ignoreFailures", (Object)IntegrationProperties.getExpressionFor("spring.integration.channels.error.ignoreFailures")).getBeanDefinition());
            String errorLoggerBeanName = "_org.springframework.integration.errorLogger.handler";
            this.registry.registerBeanDefinition(errorLoggerBeanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(LoggingHandler.class).addConstructorArgValue((Object)LoggingHandler.Level.ERROR).addPropertyValue("order", (Object)2147483547).getBeanDefinition());
            BeanDefinitionBuilder loggingEndpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConsumerEndpointFactoryBean.class).addPropertyValue("inputChannelName", (Object)"errorChannel").addPropertyReference("handler", errorLoggerBeanName);
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition((BeanDefinition)loggingEndpointBuilder.getBeanDefinition(), "_org.springframework.integration.errorLogger");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)componentDefinition, (BeanDefinitionRegistry)this.registry);
        }
    }

    private void registerIntegrationEvaluationContext() {
        BeanDefinitionBuilder integrationEvaluationContextBuilder;
        if (!this.registry.containsBeanDefinition("integrationEvaluationContext")) {
            integrationEvaluationContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationEvaluationContextFactoryBean.class).setRole(2);
            this.registry.registerBeanDefinition("integrationEvaluationContext", (BeanDefinition)integrationEvaluationContextBuilder.getBeanDefinition());
        }
        if (!this.registry.containsBeanDefinition("integrationSimpleEvaluationContext")) {
            integrationEvaluationContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationSimpleEvaluationContextFactoryBean.class).setRole(2);
            this.registry.registerBeanDefinition("integrationSimpleEvaluationContext", (BeanDefinition)integrationEvaluationContextBuilder.getBeanDefinition());
        }
    }

    private void registerIdGeneratorConfigurer() {
        String[] definitionNames;
        Class<IdGeneratorConfigurer> clazz = IdGeneratorConfigurer.class;
        String className = clazz.getName();
        for (String definitionName : definitionNames = this.registry.getBeanDefinitionNames()) {
            BeanDefinition definition = this.registry.getBeanDefinition(definitionName);
            if (!className.equals(definition.getBeanClassName())) continue;
            LOGGER.info(() -> className + " is already registered and will be used");
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(clazz);
        beanDefinition.setRole(2);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)this.registry);
    }

    private void registerTaskScheduler() {
        if (!this.beanFactory.containsBean("taskScheduler")) {
            LOGGER.info(() -> "No bean named 'taskScheduler' has been explicitly defined. Therefore, a default ThreadPoolTaskScheduler will be created.");
            AbstractBeanDefinition scheduler = BeanDefinitionBuilder.genericBeanDefinition(ThreadPoolTaskScheduler.class).addPropertyValue("poolSize", (Object)IntegrationProperties.getExpressionFor("spring.integration.taskScheduler.poolSize")).addPropertyValue("threadNamePrefix", (Object)"task-scheduler-").addPropertyValue("rejectedExecutionHandler", (Object)new ThreadPoolExecutor.CallerRunsPolicy()).addPropertyValue("phase", (Object)0x3FFFFFFF).addPropertyReference("errorHandler", "integrationMessagePublishingErrorHandler").getBeanDefinition();
            this.registry.registerBeanDefinition("taskScheduler", (BeanDefinition)scheduler);
        }
    }

    private void registerIntegrationProperties() {
        if (!this.beanFactory.containsBean("integrationGlobalProperties")) {
            AbstractBeanDefinition userProperties = BeanDefinitionBuilder.genericBeanDefinition(PropertiesFactoryBean.class).addPropertyValue("locations", (Object)"classpath*:META-INF/spring.integration.properties").getBeanDefinition();
            AbstractBeanDefinition integrationProperties = BeanDefinitionBuilder.genericBeanDefinition(IntegrationProperties.class).setFactoryMethod("parse").addConstructorArgValue((Object)userProperties).getBeanDefinition();
            this.registry.registerBeanDefinition("integrationGlobalProperties", (BeanDefinition)integrationProperties);
        }
    }

    private void registerBuiltInBeans() {
        int registryId = System.identityHashCode(this.registry);
        this.jsonPath(registryId);
        this.xpath(registryId);
        REGISTRIES_PROCESSED.add(registryId);
    }

    private void jsonPath(int registryId) throws LinkageError {
        String jsonPathBeanName = "jsonPath";
        if (JSON_PATH_PRESENT) {
            if (!this.beanFactory.containsBean(jsonPathBeanName) && !REGISTRIES_PROCESSED.contains(registryId)) {
                IntegrationConfigUtils.registerSpelFunctionBean(this.registry, jsonPathBeanName, JsonPathUtils.class, "evaluate");
            }
        } else {
            LOGGER.debug((CharSequence)"The '#jsonPath' SpEL function cannot be registered: there is no jayway json-path.jar on the classpath.");
        }
    }

    private void xpath(int registryId) throws LinkageError {
        String xpathBeanName = "xpath";
        if (XPATH_CLASS != null && !this.beanFactory.containsBean(xpathBeanName) && !REGISTRIES_PROCESSED.contains(registryId)) {
            IntegrationConfigUtils.registerSpelFunctionBean(this.registry, xpathBeanName, XPATH_CLASS, "evaluate");
        }
    }

    private void registerRoleController() {
        if (!this.beanFactory.containsBean("integrationLifecycleRoleController")) {
            this.registry.registerBeanDefinition("integrationLifecycleRoleController", (BeanDefinition)new RootBeanDefinition(SmartLifecycleRoleController.class));
        }
    }

    private void registerMessageBuilderFactory() {
        if (!this.beanFactory.containsBean("messageBuilderFactory")) {
            BeanDefinitionBuilder mbfBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultMessageBuilderFactory.class).addPropertyValue("readOnlyHeaders", (Object)IntegrationProperties.getExpressionFor("spring.integration.readOnly.headers"));
            this.registry.registerBeanDefinition("messageBuilderFactory", (BeanDefinition)mbfBuilder.getBeanDefinition());
        }
    }

    private void registerHeaderChannelRegistry() {
        if (!this.beanFactory.containsBean("integrationHeaderChannelRegistry")) {
            LOGGER.info(() -> "No bean named 'integrationHeaderChannelRegistry' has been explicitly defined. Therefore, a default DefaultHeaderChannelRegistry will be created.");
            this.registry.registerBeanDefinition("integrationHeaderChannelRegistry", (BeanDefinition)new RootBeanDefinition(DefaultHeaderChannelRegistry.class));
        }
    }

    private void registerGlobalChannelInterceptorProcessor() {
        if (!this.registry.containsBeanDefinition("globalChannelInterceptorProcessor")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GlobalChannelInterceptorProcessor.class).setRole(2);
            this.registry.registerBeanDefinition("globalChannelInterceptorProcessor", (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private void registerDefaultDatatypeChannelMessageConverter() {
        if (!this.beanFactory.containsBean("datatypeChannelMessageConverter")) {
            this.registry.registerBeanDefinition("datatypeChannelMessageConverter", (BeanDefinition)new RootBeanDefinition(DefaultDatatypeChannelMessageConverter.class));
        }
    }

    private void registerArgumentResolverMessageConverter() {
        if (!this.beanFactory.containsBean("integrationArgumentResolverMessageConverter")) {
            this.registry.registerBeanDefinition("integrationArgumentResolverMessageConverter", (BeanDefinition)new RootBeanDefinition(ConfigurableCompositeMessageConverter.class));
        }
    }

    private void registerMessageHandlerMethodFactory() {
        if (!this.beanFactory.containsBean("integrationMessageHandlerMethodFactory")) {
            BeanDefinitionBuilder messageHandlerMethodFactoryBuilder = DefaultConfiguringBeanFactoryPostProcessor.createMessageHandlerMethodFactoryBeanDefinition(false);
            this.registry.registerBeanDefinition("integrationMessageHandlerMethodFactory", (BeanDefinition)messageHandlerMethodFactoryBuilder.getBeanDefinition());
        }
    }

    private void registerListMessageHandlerMethodFactory() {
        if (!this.beanFactory.containsBean("integrationListMessageHandlerMethodFactory")) {
            BeanDefinitionBuilder messageHandlerMethodFactoryBuilder = DefaultConfiguringBeanFactoryPostProcessor.createMessageHandlerMethodFactoryBeanDefinition(true);
            this.registry.registerBeanDefinition("integrationListMessageHandlerMethodFactory", (BeanDefinition)messageHandlerMethodFactoryBuilder.getBeanDefinition());
        }
    }

    private void registerIntegrationConfigurationReport() {
        this.registry.registerBeanDefinition(Introspector.decapitalize(IntegrationConfigurationReport.class.getName()), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(IntegrationConfigurationReport.class).setRole(2).getBeanDefinition());
    }

    private void registerControlBusCommandRegistry() {
        if (!this.beanFactory.containsBean("controlBusCommandRegistry")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ControlBusCommandRegistry.class).setRole(2);
            this.registry.registerBeanDefinition("controlBusCommandRegistry", (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private static BeanDefinitionBuilder createMessageHandlerMethodFactoryBeanDefinition(boolean listCapable) {
        return BeanDefinitionBuilder.genericBeanDefinition(IntegrationMessageHandlerMethodFactory.class).addConstructorArgValue((Object)listCapable).addPropertyReference("messageConverter", "integrationArgumentResolverMessageConverter");
    }

    static {
        JSON_PATH_PRESENT = ClassUtils.isPresent((String)"com.jayway.jsonpath.JsonPath", null);
        Class xpathClass = null;
        try {
            xpathClass = ClassUtils.forName((String)"org.springframework.integration.xml.xpath.XPathUtils", (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug((CharSequence)"SpEL function '#xpath' isn't registered: there is no spring-integration-xml.jar on the classpath.");
        }
        finally {
            XPATH_CLASS = xpathClass;
        }
    }
}

