/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.ArrayList;
import java.util.List;

class BaseHashTable<T> {
    private static final double MAX_LOAD_FACTOR = 0.75;
    static final int MIN_CAPACITY = 2;
    static final int MAX_CAPACITY = 0x40000000;
    private Object[] elements;
    private int size = 0;

    BaseHashTable(int expectedSize) {
        this.elements = new Object[BaseHashTable.expectedSizeToCapacity(expectedSize)];
    }

    static int expectedSizeToCapacity(int expectedSize) {
        long minCapacity = (long)Math.ceil((double)expectedSize / 0.75);
        return Math.max(2, (int)Math.min(0x40000000L, BaseHashTable.roundUpToPowerOfTwo(minCapacity)));
    }

    private static long roundUpToPowerOfTwo(long i) {
        if (i <= 0L) {
            return 0L;
        }
        if (i > 0x4000000000000000L) {
            throw new ArithmeticException("There are no 63-bit powers of 2 higher than or equal to " + i);
        }
        return 1L << -Long.numberOfLeadingZeros(i - 1L);
    }

    final int baseSize() {
        return this.size;
    }

    final Object[] baseElements() {
        return this.elements;
    }

    final T baseGet(Object key) {
        int slot = BaseHashTable.findSlot(key, this.elements.length);
        Object value = this.elements[slot];
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            Object[] array;
            for (Object object : array = (Object[])value) {
                if (!object.equals(key)) continue;
                return (T)object;
            }
            return null;
        }
        if (value.equals(key)) {
            return (T)value;
        }
        return null;
    }

    final T baseAddOrReplace(T newObject) {
        int slot;
        Object cur;
        if ((double)(this.size + 1) * 0.75 > (double)this.elements.length && this.elements.length < 0x40000000) {
            int newSize = this.elements.length * 2;
            this.rehash(newSize);
        }
        if ((cur = this.elements[slot = BaseHashTable.findSlot(newObject, this.elements.length)]) == null) {
            ++this.size;
            this.elements[slot] = newObject;
            return null;
        }
        if (cur instanceof Object[]) {
            Object[] curArray = (Object[])cur;
            for (int i = 0; i < curArray.length; ++i) {
                Object value = curArray[i];
                if (!value.equals(newObject)) continue;
                curArray[i] = newObject;
                return (T)value;
            }
            ++this.size;
            Object[] newArray = new Object[curArray.length + 1];
            System.arraycopy(curArray, 0, newArray, 0, curArray.length);
            newArray[curArray.length] = newObject;
            this.elements[slot] = newArray;
            return null;
        }
        if (cur.equals(newObject)) {
            this.elements[slot] = newObject;
            return (T)cur;
        }
        ++this.size;
        this.elements[slot] = new Object[]{cur, newObject};
        return null;
    }

    final T baseRemove(Object key) {
        int slot = BaseHashTable.findSlot(key, this.elements.length);
        Object object = this.elements[slot];
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            Object[] curArray = (Object[])object;
            for (int i = 0; i < curArray.length; ++i) {
                if (!curArray[i].equals(key)) continue;
                --this.size;
                if (curArray.length <= 2) {
                    int j = i == 0 ? 1 : 0;
                    this.elements[slot] = curArray[j];
                } else {
                    Object[] newArray = new Object[curArray.length - 1];
                    System.arraycopy(curArray, 0, newArray, 0, i);
                    System.arraycopy(curArray, i + 1, newArray, i, curArray.length - 1 - i);
                    this.elements[slot] = newArray;
                }
                return (T)curArray[i];
            }
            return null;
        }
        if (object.equals(key)) {
            --this.size;
            this.elements[slot] = null;
            return (T)object;
        }
        return null;
    }

    private void rehash(int newSize) {
        Object[] prevElements = this.elements;
        this.elements = new Object[newSize];
        ArrayList ready = new ArrayList();
        for (int slot = 0; slot < prevElements.length; ++slot) {
            BaseHashTable.unpackSlot(ready, prevElements, slot);
            for (Object object : ready) {
                int newSlot = BaseHashTable.findSlot(object, this.elements.length);
                Object cur = this.elements[newSlot];
                if (cur == null) {
                    this.elements[newSlot] = object;
                    continue;
                }
                if (cur instanceof Object[]) {
                    Object[] curArray = (Object[])cur;
                    Object[] newArray = new Object[curArray.length + 1];
                    System.arraycopy(curArray, 0, newArray, 0, curArray.length);
                    newArray[curArray.length] = object;
                    this.elements[newSlot] = newArray;
                    continue;
                }
                this.elements[newSlot] = new Object[]{cur, object};
            }
            ready.clear();
        }
    }

    static int findSlot(Object object, int numElements) {
        int objectHashCode = object.hashCode();
        int log2size = 32 - Integer.numberOfLeadingZeros(numElements);
        int shift = 65 - log2size;
        return (int)((long)objectHashCode * -7046029254386353131L >>> shift);
    }

    static <T> void unpackSlot(List<T> out, Object[] elements, int slot) {
        Object value = elements[slot];
        if (value != null) {
            if (value instanceof Object[]) {
                Object[] array;
                for (Object object : array = (Object[])value) {
                    out.add(object);
                }
            } else {
                out.add(value);
            }
        }
    }

    String baseToDebugString() {
        StringBuilder bld = new StringBuilder();
        bld.append("BaseHashTable{");
        for (int i = 0; i < this.elements.length; ++i) {
            Object slotObject = this.elements[i];
            bld.append(String.format("%n%d: ", i));
            if (slotObject == null) {
                bld.append("null");
                continue;
            }
            if (slotObject instanceof Object[]) {
                Object[] array = (Object[])slotObject;
                String prefix = "";
                for (Object object : array) {
                    bld.append(prefix);
                    prefix = ", ";
                    bld.append(object);
                }
                continue;
            }
            bld.append(slotObject);
        }
        bld.append(String.format("%n}", new Object[0]));
        return bld.toString();
    }
}

