/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class OidcServerDiscoverySettings {
    public static final String BEAN_NAME_FACTORY = "oidcServerDiscoverySettingsFactory";
    @JsonProperty
    private final String issuer;
    @JsonProperty(value="scopes_supported")
    private Set<String> scopesSupported;
    @JsonProperty(value="response_types_supported")
    private Set<String> responseTypesSupported;
    @JsonProperty(value="response_modes_supported")
    private Set<String> responseModesSupported;
    @JsonProperty(value="subject_types_supported")
    private Set<String> subjectTypesSupported;
    @JsonProperty(value="claim_types_supported")
    private Set<String> claimTypesSupported;
    @JsonProperty(value="claims_supported")
    private Set<String> claimsSupported;
    @JsonProperty(value="grant_types_supported")
    private Set<String> grantTypesSupported;
    @JsonProperty(value="id_token_signing_alg_values_supported")
    private Set<String> idTokenSigningAlgValuesSupported;
    @JsonProperty(value="dpop_signing_alg_values_supported")
    private Set<String> dPopSigningAlgValuesSupported;
    @JsonProperty(value="id_token_encryption_alg_values_supported")
    private Set<String> idTokenEncryptionAlgValuesSupported;
    @JsonProperty(value="id_token_encryption_enc_values_supported")
    private Set<String> idTokenEncryptionEncodingValuesSupported;
    @JsonProperty(value="userinfo_signing_alg_values_supported")
    private Set<String> userInfoSigningAlgValuesSupported;
    @JsonProperty(value="userinfo_encryption_alg_values_supported")
    private Set<String> userInfoEncryptionAlgValuesSupported;
    @JsonProperty(value="userinfo_encryption_enc_values_supported")
    private Set<String> userInfoEncryptionEncodingValuesSupported;
    @JsonProperty(value="acr_values_supported")
    private Set<String> acrValuesSupported;
    @JsonProperty(value="request_object_signing_alg_values_supported")
    private Set<String> requestObjectSigningAlgValuesSupported;
    @JsonProperty(value="request_object_encryption_alg_values_supported")
    private Set<String> requestObjectEncryptionAlgValuesSupported;
    @JsonProperty(value="request_object_encryption_enc_values_supported")
    private Set<String> requestObjectEncryptionEncodingValuesSupported;
    @JsonProperty(value="introspection_endpoint_auth_methods_supported")
    private Set<String> introspectionSupportedAuthenticationMethods;
    @JsonProperty(value="token_endpoint_auth_methods_supported")
    private Set<String> tokenEndpointAuthMethodsSupported;
    @JsonProperty(value="code_challenge_methods_supported")
    private Set<String> codeChallengeMethodsSupported;
    @JsonProperty(value="prompt_values_supported")
    private Set<String> promptValuesSupported;
    @JsonProperty(value="claims_parameter_supported")
    private boolean claimsParameterSupported = true;
    @JsonProperty(value="request_uri_parameter_supported")
    private boolean requestUriParameterSupported = true;
    @JsonProperty(value="request_parameter_supported")
    private boolean requestParameterSupported = true;
    @JsonProperty(value="verified_claims_supported")
    private boolean verifiedClaimsSupported = true;
    @JsonProperty(value="trust_frameworks_supported")
    private Set<String> trustFrameworksSupported;
    @JsonProperty(value="evidence_supported")
    private Set<String> evidenceSupported;
    @JsonProperty(value="documents_supported")
    private Set<String> documentsSupported;
    @JsonProperty(value="documents_validation_methods_supported")
    private Set<String> documentsValidationMethodsSupported;
    @JsonProperty(value="documents_verification_methods_supported")
    private Set<String> documentsVerificationMethodsSupported;
    @JsonProperty(value="electronic_records_supported")
    private Set<String> electronicRecordsSupported;
    @JsonProperty(value="claims_in_verified_claims_supported")
    private Set<String> claimsInVerifiedClaimsSupported;
    @JsonProperty(value="require_pushed_authorization_requests")
    private boolean requirePushedAuthorizationRequests;
    @JsonProperty(value="authorization_response_iss_parameter_supported")
    private boolean authorizationResponseIssuerParameterSupported = true;
    @JsonProperty(value="backchannel_logout_supported")
    private boolean backchannelLogoutSupported;
    @JsonProperty(value="frontchannel_logout_supported")
    private boolean frontchannelLogoutSupported;
    @JsonProperty(value="tls_client_certificate_bound_access_tokens")
    private boolean tlsClientCertificateBoundAccessTokens;
    @JsonProperty(value="introspection_signing_alg_values_supported")
    private Set<String> introspectionSignedResponseAlgValuesSupported;
    @JsonProperty(value="introspection_encryption_alg_values_supported")
    private Set<String> introspectionEncryptedResponseAlgValuesSupported;
    @JsonProperty(value="introspection_encryption_enc_values_supported")
    private Set<String> introspectionEncryptedResponseEncodingValuesSupported;
    @JsonProperty(value="backchannel_authentication_request_signing_alg_values_supported")
    private Set<String> backchannelAuthenticationRequestSigningAlgValuesSupported;
    @JsonProperty(value="backchannel_user_code_parameter_supported")
    private boolean backchannelUserCodeParameterSupported;
    @JsonProperty(value="backchannel_token_delivery_modes_supported")
    private Set<String> backchannelTokenDeliveryModesSupported;

    @JsonProperty(value="backchannel_authentication_endpoint")
    public String getBackchannelAuthenticationEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("oidcCiba");
    }

    @JsonProperty(value="authorization_endpoint")
    public String getAuthorizationEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("oidcAuthorize");
    }

    @JsonProperty(value="token_endpoint")
    public String getTokenEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("oidcAccessToken");
    }

    @JsonProperty(value="device_authorization_endpoint")
    public String getDeviceAuthorizationEndpoint() {
        return this.getTokenEndpoint();
    }

    @JsonProperty(value="userinfo_endpoint")
    public String getUserinfoEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("oidcProfile");
    }

    @JsonProperty(value="pushed_authorization_request_endpoint")
    public String getPushedAuthorizationRequestEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("oidcPushAuthorize");
    }

    @JsonProperty(value="jwks_uri")
    public String getJwksUri() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("jwks");
    }

    @JsonProperty(value="registration_endpoint")
    public String getRegistrationEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("register");
    }

    @JsonProperty(value="end_session_endpoint")
    public String getEndSessionEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("oidcLogout");
    }

    @JsonProperty(value="introspection_endpoint")
    public String getIntrospectionEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("introspect");
    }

    @JsonProperty(value="revocation_endpoint")
    public String getRevocationEndpoint() {
        return StringUtils.appendIfMissing((String)this.issuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("revoke");
    }

    @JsonProperty(value="backchannel_logout_session_supported")
    public boolean isBackchannelLogoutSessionSupported() {
        return this.isBackchannelLogoutSupported();
    }

    @JsonProperty(value="frontchannel_logout_session_supported")
    public boolean isFrontchannelLogoutSessionSupported() {
        return this.isFrontchannelLogoutSupported();
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public Set<String> getScopesSupported() {
        return this.scopesSupported;
    }

    @Generated
    public Set<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    @Generated
    public Set<String> getResponseModesSupported() {
        return this.responseModesSupported;
    }

    @Generated
    public Set<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    @Generated
    public Set<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    @Generated
    public Set<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    @Generated
    public Set<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    @Generated
    public Set<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    @Generated
    public Set<String> getDPopSigningAlgValuesSupported() {
        return this.dPopSigningAlgValuesSupported;
    }

    @Generated
    public Set<String> getIdTokenEncryptionAlgValuesSupported() {
        return this.idTokenEncryptionAlgValuesSupported;
    }

    @Generated
    public Set<String> getIdTokenEncryptionEncodingValuesSupported() {
        return this.idTokenEncryptionEncodingValuesSupported;
    }

    @Generated
    public Set<String> getUserInfoSigningAlgValuesSupported() {
        return this.userInfoSigningAlgValuesSupported;
    }

    @Generated
    public Set<String> getUserInfoEncryptionAlgValuesSupported() {
        return this.userInfoEncryptionAlgValuesSupported;
    }

    @Generated
    public Set<String> getUserInfoEncryptionEncodingValuesSupported() {
        return this.userInfoEncryptionEncodingValuesSupported;
    }

    @Generated
    public Set<String> getAcrValuesSupported() {
        return this.acrValuesSupported;
    }

    @Generated
    public Set<String> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    @Generated
    public Set<String> getRequestObjectEncryptionAlgValuesSupported() {
        return this.requestObjectEncryptionAlgValuesSupported;
    }

    @Generated
    public Set<String> getRequestObjectEncryptionEncodingValuesSupported() {
        return this.requestObjectEncryptionEncodingValuesSupported;
    }

    @Generated
    public Set<String> getIntrospectionSupportedAuthenticationMethods() {
        return this.introspectionSupportedAuthenticationMethods;
    }

    @Generated
    public Set<String> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    @Generated
    public Set<String> getCodeChallengeMethodsSupported() {
        return this.codeChallengeMethodsSupported;
    }

    @Generated
    public Set<String> getPromptValuesSupported() {
        return this.promptValuesSupported;
    }

    @Generated
    public boolean isClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    @Generated
    public boolean isRequestUriParameterSupported() {
        return this.requestUriParameterSupported;
    }

    @Generated
    public boolean isRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    @Generated
    public boolean isVerifiedClaimsSupported() {
        return this.verifiedClaimsSupported;
    }

    @Generated
    public Set<String> getTrustFrameworksSupported() {
        return this.trustFrameworksSupported;
    }

    @Generated
    public Set<String> getEvidenceSupported() {
        return this.evidenceSupported;
    }

    @Generated
    public Set<String> getDocumentsSupported() {
        return this.documentsSupported;
    }

    @Generated
    public Set<String> getDocumentsValidationMethodsSupported() {
        return this.documentsValidationMethodsSupported;
    }

    @Generated
    public Set<String> getDocumentsVerificationMethodsSupported() {
        return this.documentsVerificationMethodsSupported;
    }

    @Generated
    public Set<String> getElectronicRecordsSupported() {
        return this.electronicRecordsSupported;
    }

    @Generated
    public Set<String> getClaimsInVerifiedClaimsSupported() {
        return this.claimsInVerifiedClaimsSupported;
    }

    @Generated
    public boolean isRequirePushedAuthorizationRequests() {
        return this.requirePushedAuthorizationRequests;
    }

    @Generated
    public boolean isAuthorizationResponseIssuerParameterSupported() {
        return this.authorizationResponseIssuerParameterSupported;
    }

    @Generated
    public boolean isBackchannelLogoutSupported() {
        return this.backchannelLogoutSupported;
    }

    @Generated
    public boolean isFrontchannelLogoutSupported() {
        return this.frontchannelLogoutSupported;
    }

    @Generated
    public boolean isTlsClientCertificateBoundAccessTokens() {
        return this.tlsClientCertificateBoundAccessTokens;
    }

    @Generated
    public Set<String> getIntrospectionSignedResponseAlgValuesSupported() {
        return this.introspectionSignedResponseAlgValuesSupported;
    }

    @Generated
    public Set<String> getIntrospectionEncryptedResponseAlgValuesSupported() {
        return this.introspectionEncryptedResponseAlgValuesSupported;
    }

    @Generated
    public Set<String> getIntrospectionEncryptedResponseEncodingValuesSupported() {
        return this.introspectionEncryptedResponseEncodingValuesSupported;
    }

    @Generated
    public Set<String> getBackchannelAuthenticationRequestSigningAlgValuesSupported() {
        return this.backchannelAuthenticationRequestSigningAlgValuesSupported;
    }

    @Generated
    public boolean isBackchannelUserCodeParameterSupported() {
        return this.backchannelUserCodeParameterSupported;
    }

    @Generated
    public Set<String> getBackchannelTokenDeliveryModesSupported() {
        return this.backchannelTokenDeliveryModesSupported;
    }

    @JsonProperty(value="scopes_supported")
    @Generated
    public void setScopesSupported(Set<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    @JsonProperty(value="response_types_supported")
    @Generated
    public void setResponseTypesSupported(Set<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    @JsonProperty(value="response_modes_supported")
    @Generated
    public void setResponseModesSupported(Set<String> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
    }

    @JsonProperty(value="subject_types_supported")
    @Generated
    public void setSubjectTypesSupported(Set<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    @JsonProperty(value="claim_types_supported")
    @Generated
    public void setClaimTypesSupported(Set<String> claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    @JsonProperty(value="claims_supported")
    @Generated
    public void setClaimsSupported(Set<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    @JsonProperty(value="grant_types_supported")
    @Generated
    public void setGrantTypesSupported(Set<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    @JsonProperty(value="id_token_signing_alg_values_supported")
    @Generated
    public void setIdTokenSigningAlgValuesSupported(Set<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    @JsonProperty(value="dpop_signing_alg_values_supported")
    @Generated
    public void setDPopSigningAlgValuesSupported(Set<String> dPopSigningAlgValuesSupported) {
        this.dPopSigningAlgValuesSupported = dPopSigningAlgValuesSupported;
    }

    @JsonProperty(value="id_token_encryption_alg_values_supported")
    @Generated
    public void setIdTokenEncryptionAlgValuesSupported(Set<String> idTokenEncryptionAlgValuesSupported) {
        this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
    }

    @JsonProperty(value="id_token_encryption_enc_values_supported")
    @Generated
    public void setIdTokenEncryptionEncodingValuesSupported(Set<String> idTokenEncryptionEncodingValuesSupported) {
        this.idTokenEncryptionEncodingValuesSupported = idTokenEncryptionEncodingValuesSupported;
    }

    @JsonProperty(value="userinfo_signing_alg_values_supported")
    @Generated
    public void setUserInfoSigningAlgValuesSupported(Set<String> userInfoSigningAlgValuesSupported) {
        this.userInfoSigningAlgValuesSupported = userInfoSigningAlgValuesSupported;
    }

    @JsonProperty(value="userinfo_encryption_alg_values_supported")
    @Generated
    public void setUserInfoEncryptionAlgValuesSupported(Set<String> userInfoEncryptionAlgValuesSupported) {
        this.userInfoEncryptionAlgValuesSupported = userInfoEncryptionAlgValuesSupported;
    }

    @JsonProperty(value="userinfo_encryption_enc_values_supported")
    @Generated
    public void setUserInfoEncryptionEncodingValuesSupported(Set<String> userInfoEncryptionEncodingValuesSupported) {
        this.userInfoEncryptionEncodingValuesSupported = userInfoEncryptionEncodingValuesSupported;
    }

    @JsonProperty(value="acr_values_supported")
    @Generated
    public void setAcrValuesSupported(Set<String> acrValuesSupported) {
        this.acrValuesSupported = acrValuesSupported;
    }

    @JsonProperty(value="request_object_signing_alg_values_supported")
    @Generated
    public void setRequestObjectSigningAlgValuesSupported(Set<String> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
    }

    @JsonProperty(value="request_object_encryption_alg_values_supported")
    @Generated
    public void setRequestObjectEncryptionAlgValuesSupported(Set<String> requestObjectEncryptionAlgValuesSupported) {
        this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
    }

    @JsonProperty(value="request_object_encryption_enc_values_supported")
    @Generated
    public void setRequestObjectEncryptionEncodingValuesSupported(Set<String> requestObjectEncryptionEncodingValuesSupported) {
        this.requestObjectEncryptionEncodingValuesSupported = requestObjectEncryptionEncodingValuesSupported;
    }

    @JsonProperty(value="introspection_endpoint_auth_methods_supported")
    @Generated
    public void setIntrospectionSupportedAuthenticationMethods(Set<String> introspectionSupportedAuthenticationMethods) {
        this.introspectionSupportedAuthenticationMethods = introspectionSupportedAuthenticationMethods;
    }

    @JsonProperty(value="token_endpoint_auth_methods_supported")
    @Generated
    public void setTokenEndpointAuthMethodsSupported(Set<String> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    @JsonProperty(value="code_challenge_methods_supported")
    @Generated
    public void setCodeChallengeMethodsSupported(Set<String> codeChallengeMethodsSupported) {
        this.codeChallengeMethodsSupported = codeChallengeMethodsSupported;
    }

    @JsonProperty(value="prompt_values_supported")
    @Generated
    public void setPromptValuesSupported(Set<String> promptValuesSupported) {
        this.promptValuesSupported = promptValuesSupported;
    }

    @JsonProperty(value="claims_parameter_supported")
    @Generated
    public void setClaimsParameterSupported(boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
    }

    @JsonProperty(value="request_uri_parameter_supported")
    @Generated
    public void setRequestUriParameterSupported(boolean requestUriParameterSupported) {
        this.requestUriParameterSupported = requestUriParameterSupported;
    }

    @JsonProperty(value="request_parameter_supported")
    @Generated
    public void setRequestParameterSupported(boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
    }

    @JsonProperty(value="verified_claims_supported")
    @Generated
    public void setVerifiedClaimsSupported(boolean verifiedClaimsSupported) {
        this.verifiedClaimsSupported = verifiedClaimsSupported;
    }

    @JsonProperty(value="trust_frameworks_supported")
    @Generated
    public void setTrustFrameworksSupported(Set<String> trustFrameworksSupported) {
        this.trustFrameworksSupported = trustFrameworksSupported;
    }

    @JsonProperty(value="evidence_supported")
    @Generated
    public void setEvidenceSupported(Set<String> evidenceSupported) {
        this.evidenceSupported = evidenceSupported;
    }

    @JsonProperty(value="documents_supported")
    @Generated
    public void setDocumentsSupported(Set<String> documentsSupported) {
        this.documentsSupported = documentsSupported;
    }

    @JsonProperty(value="documents_validation_methods_supported")
    @Generated
    public void setDocumentsValidationMethodsSupported(Set<String> documentsValidationMethodsSupported) {
        this.documentsValidationMethodsSupported = documentsValidationMethodsSupported;
    }

    @JsonProperty(value="documents_verification_methods_supported")
    @Generated
    public void setDocumentsVerificationMethodsSupported(Set<String> documentsVerificationMethodsSupported) {
        this.documentsVerificationMethodsSupported = documentsVerificationMethodsSupported;
    }

    @JsonProperty(value="electronic_records_supported")
    @Generated
    public void setElectronicRecordsSupported(Set<String> electronicRecordsSupported) {
        this.electronicRecordsSupported = electronicRecordsSupported;
    }

    @JsonProperty(value="claims_in_verified_claims_supported")
    @Generated
    public void setClaimsInVerifiedClaimsSupported(Set<String> claimsInVerifiedClaimsSupported) {
        this.claimsInVerifiedClaimsSupported = claimsInVerifiedClaimsSupported;
    }

    @JsonProperty(value="require_pushed_authorization_requests")
    @Generated
    public void setRequirePushedAuthorizationRequests(boolean requirePushedAuthorizationRequests) {
        this.requirePushedAuthorizationRequests = requirePushedAuthorizationRequests;
    }

    @JsonProperty(value="authorization_response_iss_parameter_supported")
    @Generated
    public void setAuthorizationResponseIssuerParameterSupported(boolean authorizationResponseIssuerParameterSupported) {
        this.authorizationResponseIssuerParameterSupported = authorizationResponseIssuerParameterSupported;
    }

    @JsonProperty(value="backchannel_logout_supported")
    @Generated
    public void setBackchannelLogoutSupported(boolean backchannelLogoutSupported) {
        this.backchannelLogoutSupported = backchannelLogoutSupported;
    }

    @JsonProperty(value="frontchannel_logout_supported")
    @Generated
    public void setFrontchannelLogoutSupported(boolean frontchannelLogoutSupported) {
        this.frontchannelLogoutSupported = frontchannelLogoutSupported;
    }

    @JsonProperty(value="tls_client_certificate_bound_access_tokens")
    @Generated
    public void setTlsClientCertificateBoundAccessTokens(boolean tlsClientCertificateBoundAccessTokens) {
        this.tlsClientCertificateBoundAccessTokens = tlsClientCertificateBoundAccessTokens;
    }

    @JsonProperty(value="introspection_signing_alg_values_supported")
    @Generated
    public void setIntrospectionSignedResponseAlgValuesSupported(Set<String> introspectionSignedResponseAlgValuesSupported) {
        this.introspectionSignedResponseAlgValuesSupported = introspectionSignedResponseAlgValuesSupported;
    }

    @JsonProperty(value="introspection_encryption_alg_values_supported")
    @Generated
    public void setIntrospectionEncryptedResponseAlgValuesSupported(Set<String> introspectionEncryptedResponseAlgValuesSupported) {
        this.introspectionEncryptedResponseAlgValuesSupported = introspectionEncryptedResponseAlgValuesSupported;
    }

    @JsonProperty(value="introspection_encryption_enc_values_supported")
    @Generated
    public void setIntrospectionEncryptedResponseEncodingValuesSupported(Set<String> introspectionEncryptedResponseEncodingValuesSupported) {
        this.introspectionEncryptedResponseEncodingValuesSupported = introspectionEncryptedResponseEncodingValuesSupported;
    }

    @JsonProperty(value="backchannel_authentication_request_signing_alg_values_supported")
    @Generated
    public void setBackchannelAuthenticationRequestSigningAlgValuesSupported(Set<String> backchannelAuthenticationRequestSigningAlgValuesSupported) {
        this.backchannelAuthenticationRequestSigningAlgValuesSupported = backchannelAuthenticationRequestSigningAlgValuesSupported;
    }

    @JsonProperty(value="backchannel_user_code_parameter_supported")
    @Generated
    public void setBackchannelUserCodeParameterSupported(boolean backchannelUserCodeParameterSupported) {
        this.backchannelUserCodeParameterSupported = backchannelUserCodeParameterSupported;
    }

    @JsonProperty(value="backchannel_token_delivery_modes_supported")
    @Generated
    public void setBackchannelTokenDeliveryModesSupported(Set<String> backchannelTokenDeliveryModesSupported) {
        this.backchannelTokenDeliveryModesSupported = backchannelTokenDeliveryModesSupported;
    }

    @Generated
    public OidcServerDiscoverySettings(String issuer) {
        this.issuer = issuer;
    }
}

