/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.WeakPasswordException;

public class PasswordStrengthAuthenticationPostProcessor
implements AuthenticationPostProcessor {
    private final PasswordValidationService passwordValidationService;

    public void process(AuthenticationBuilder builder, AuthenticationTransaction transaction) throws Throwable {
        UsernamePasswordCredential primaryCredential = (UsernamePasswordCredential)transaction.getPrimaryCredential().orElseThrow();
        if (!this.passwordValidationService.isAcceptedByPasswordPolicy(primaryCredential.toPassword())) {
            throw new WeakPasswordException(primaryCredential);
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    @Generated
    public PasswordStrengthAuthenticationPostProcessor(PasswordValidationService passwordValidationService) {
        this.passwordValidationService = passwordValidationService;
    }
}

