/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class AttributeDeltaBuilder {
    private static final String NAME_ERROR = "Name must not be blank!";
    private static final String COLLISION_ERROR = "Collision, valuesToReplace, valuesToAdd and valuesToRemove can't be used together!";
    private static final String COLLISION_ERROR_REPLACE = "Collision, valuesToReplace can't be used together with valuesToAdd or valuesToRemove!";
    private static final String COLLISION_ERROR_ADDORREMOVE = "Collision, valuesToAdd or valuesToRemove can't be used together with valuesToReplace!";
    private String name;
    private List<Object> valuesToAdd;
    private List<Object> valuesToRemove;
    private List<Object> valuesToReplace;

    public static AttributeDelta build(String name) {
        AttributeDeltaBuilder bld = new AttributeDeltaBuilder();
        bld.setName(name);
        return bld.build();
    }

    public static AttributeDelta build(String name, Collection<?> valuesToAdd, Collection<?> valuesToRemove) {
        AttributeDeltaBuilder bld = new AttributeDeltaBuilder();
        bld.setName(name);
        bld.addValueToAdd(valuesToAdd);
        bld.addValueToRemove(valuesToRemove);
        return bld.build();
    }

    public static AttributeDelta build(String name, Object ... args) {
        AttributeDeltaBuilder bld = new AttributeDeltaBuilder();
        bld.setName(name);
        bld.addValueToReplace(args);
        return bld.build();
    }

    public static AttributeDelta build(String name, Collection<?> valuesToReplace) {
        AttributeDeltaBuilder bld = new AttributeDeltaBuilder();
        bld.setName(name);
        bld.addValueToReplace(valuesToReplace);
        return bld.build();
    }

    public String getName() {
        return this.name;
    }

    public AttributeDeltaBuilder setName(String name) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException(NAME_ERROR);
        }
        this.name = name;
        return this;
    }

    public List<Object> getValuesToAdd() {
        return this.valuesToAdd == null ? null : CollectionUtil.asReadOnlyList(this.valuesToAdd);
    }

    public List<Object> getValueToRemove() {
        return this.valuesToRemove == null ? null : CollectionUtil.asReadOnlyList(this.valuesToRemove);
    }

    public List<Object> getValueToReplace() {
        return this.valuesToReplace == null ? null : CollectionUtil.asReadOnlyList(this.valuesToReplace);
    }

    public AttributeDeltaBuilder addValueToAdd(Collection<?> obj) {
        if (this.valuesToReplace != null) {
            throw new IllegalArgumentException(COLLISION_ERROR_ADDORREMOVE);
        }
        this.valuesToAdd = this.addValuesInternal(obj, this.valuesToAdd);
        return this;
    }

    public AttributeDeltaBuilder addValueToAdd(Object ... objs) {
        if (this.valuesToReplace == null) {
            if (objs != null) {
                this.valuesToAdd = this.addValuesInternal(Arrays.asList(objs), this.valuesToAdd);
            }
        } else {
            throw new IllegalArgumentException(COLLISION_ERROR_ADDORREMOVE);
        }
        return this;
    }

    public AttributeDeltaBuilder addValueToRemove(Collection<?> obj) {
        if (this.valuesToReplace != null) {
            throw new IllegalArgumentException(COLLISION_ERROR_ADDORREMOVE);
        }
        this.valuesToRemove = this.addValuesInternal(obj, this.valuesToRemove);
        return this;
    }

    public AttributeDeltaBuilder addValueToRemove(Object ... objs) {
        if (this.valuesToReplace == null) {
            if (objs != null) {
                this.valuesToRemove = this.addValuesInternal(Arrays.asList(objs), this.valuesToRemove);
            }
        } else {
            throw new IllegalArgumentException(COLLISION_ERROR_ADDORREMOVE);
        }
        return this;
    }

    public AttributeDeltaBuilder addValueToReplace(Collection<?> obj) {
        if (this.valuesToAdd != null || this.valuesToRemove != null) {
            throw new IllegalArgumentException(COLLISION_ERROR_REPLACE);
        }
        this.valuesToReplace = this.addValuesInternal(obj, this.valuesToReplace);
        return this;
    }

    public AttributeDeltaBuilder addValueToReplace(Object ... objs) {
        if (this.valuesToAdd == null && this.valuesToRemove == null) {
            if (objs != null) {
                this.valuesToReplace = this.addValuesInternal(Arrays.asList(objs), this.valuesToReplace);
            }
        } else {
            throw new IllegalArgumentException(COLLISION_ERROR_REPLACE);
        }
        return this;
    }

    public AttributeDelta build() {
        if (StringUtil.isBlank(this.name)) {
            throw new IllegalArgumentException(NAME_ERROR);
        }
        if (this.valuesToReplace != null && (this.valuesToAdd != null || this.valuesToRemove != null)) {
            throw new IllegalArgumentException(COLLISION_ERROR);
        }
        if (Uid.NAME.equals(this.name)) {
            return new AttributeDelta(Uid.NAME, null, null, this.getSingleStringValue());
        }
        if (Name.NAME.equals(this.name)) {
            return new AttributeDelta(Name.NAME, null, null, this.getSingleStringValue());
        }
        return new AttributeDelta(this.name, this.valuesToAdd, this.valuesToRemove, this.valuesToReplace);
    }

    private void checkSingleValue() {
        if (this.valuesToReplace == null || this.valuesToReplace.size() != 1) {
            throw new IllegalArgumentException("ValueToReplace of attributeDelta '" + this.name + "' must be a single value, but it has " + (this.valuesToReplace == null ? null : Integer.valueOf(this.valuesToReplace.size())) + "values");
        }
    }

    private List<Object> getSingleStringValue() {
        this.checkSingleValue();
        if (!(this.valuesToReplace.get(0) instanceof String)) {
            throw new IllegalArgumentException("ValueToReplace of attributeDelta '" + this.name + "' must be an instance of String.");
        }
        return Arrays.asList(this.valuesToReplace.get(0));
    }

    private List<Object> addValuesInternal(Iterable<?> values, List<Object> ListValues) {
        if (values != null) {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (ListValues != null) {
                ret.addAll(ListValues);
            }
            for (Object v : values) {
                FrameworkUtil.checkAttributeValue(this.name, v);
                ret.add(v);
            }
            return ret;
        }
        return ListValues;
    }

    public static AttributeDelta buildPasswordExpirationDate(Date dateTime) {
        return AttributeDeltaBuilder.buildPasswordExpirationDate(dateTime.getTime());
    }

    public static AttributeDelta buildPasswordExpirationDate(long dateTime) {
        return AttributeDeltaBuilder.build(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME, dateTime);
    }

    public static AttributeDelta buildPassword(GuardedString password) {
        return AttributeDeltaBuilder.build(OperationalAttributes.PASSWORD_NAME, password);
    }

    public static AttributeDelta buildPassword(char[] password) {
        return AttributeDeltaBuilder.buildPassword(new GuardedString(password));
    }

    public static AttributeDelta buildCurrentPassword(GuardedString password) {
        return AttributeDeltaBuilder.build(OperationalAttributes.CURRENT_PASSWORD_NAME, password);
    }

    public static AttributeDelta buildCurrentPassword(char[] password) {
        return AttributeDeltaBuilder.buildCurrentPassword(new GuardedString(password));
    }

    public static AttributeDelta buildEnabled(boolean value) {
        return AttributeDeltaBuilder.build(OperationalAttributes.ENABLE_NAME, value);
    }

    public static AttributeDelta buildEnableDate(Date date) {
        return AttributeDeltaBuilder.buildEnableDate(date.getTime());
    }

    public static AttributeDelta buildEnableDate(long date) {
        return AttributeDeltaBuilder.build(OperationalAttributes.ENABLE_DATE_NAME, date);
    }

    public static AttributeDelta buildDisableDate(Date date) {
        return AttributeDeltaBuilder.buildDisableDate(date.getTime());
    }

    public static AttributeDelta buildDisableDate(long date) {
        return AttributeDeltaBuilder.build(OperationalAttributes.DISABLE_DATE_NAME, date);
    }

    public static AttributeDelta buildLockOut(boolean lock) {
        return AttributeDeltaBuilder.build(OperationalAttributes.LOCK_OUT_NAME, lock);
    }

    public static AttributeDelta buildPasswordExpired(boolean value) {
        return AttributeDeltaBuilder.build(OperationalAttributes.PASSWORD_EXPIRED_NAME, value);
    }

    public static AttributeDelta buildLastLoginDate(Date date) {
        return AttributeDeltaBuilder.buildLastLoginDate(date.getTime());
    }

    public static AttributeDelta buildLastLoginDate(long date) {
        return AttributeDeltaBuilder.build(PredefinedAttributes.LAST_LOGIN_DATE_NAME, date);
    }

    public static AttributeDelta buildLastPasswordChangeDate(Date date) {
        return AttributeDeltaBuilder.buildLastPasswordChangeDate(date.getTime());
    }

    public static AttributeDelta buildLastPasswordChangeDate(long date) {
        return AttributeDeltaBuilder.build(PredefinedAttributes.LAST_PASSWORD_CHANGE_DATE_NAME, date);
    }

    public static AttributeDelta buildPasswordChangeInterval(long value) {
        return AttributeDeltaBuilder.build(PredefinedAttributes.PASSWORD_CHANGE_INTERVAL_NAME, value);
    }
}

