/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.api.PasswordlessAuthenticationPreProcessor;
import org.apereo.cas.api.PasswordlessRequestParser;
import org.apereo.cas.authentication.SurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.principal.DelegatedAuthenticationCredentialExtractor;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialParser;
import org.apereo.cas.config.CasDelegatedAuthenticationAutoConfiguration;
import org.apereo.cas.config.CasPasswordlessAuthenticationWebflowAutoConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.passwordless.SurrogateDelegatedAuthenticationCredentialExtractor;
import org.apereo.cas.web.flow.passwordless.SurrogatePasswordlessAuthenticationPreProcessor;
import org.apereo.cas.web.flow.passwordless.SurrogatePasswordlessAuthenticationRequestParser;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnClass(value={CasPasswordlessAuthenticationWebflowAutoConfiguration.class})
@Configuration(value="SurrogateAuthenticationPasswordlessConfiguration", proxyBeanMethods=false)
class SurrogateAuthenticationPasswordlessConfiguration {
    SurrogateAuthenticationPasswordlessConfiguration() {
    }

    @Configuration(value="SurrogateAuthenticationDelegationPasswordlessConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={CasDelegatedAuthenticationAutoConfiguration.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordlessAuthn, CasFeatureModule.FeatureCatalog.DelegatedAuthentication, CasFeatureModule.FeatureCatalog.SurrogateAuthentication})
    public static class SurrogateAuthenticationDelegationPasswordlessConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"surrogateDelegatedPasswordlessAuthenticationCredentialExtractor"})
        public DelegatedAuthenticationCredentialExtractor surrogateDelegatedPasswordlessAuthenticationCredentialExtractor(@Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore) {
            return new SurrogateDelegatedAuthenticationCredentialExtractor(delegatedClientDistributedSessionStore);
        }
    }

    @Configuration(value="BaseSurrogateAuthenticationPasswordlessConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordlessAuthn, CasFeatureModule.FeatureCatalog.SurrogateAuthentication})
    public static class BaseSurrogateAuthenticationPasswordlessConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogatePasswordlessAuthenticationPreProcessor"})
        public PasswordlessAuthenticationPreProcessor surrogatePasswordlessAuthenticationPreProcessor(@Qualifier(value="surrogateAuthenticationService") SurrogateAuthenticationService surrogateAuthenticationService, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="surrogatePrincipalBuilder") SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder) {
            return new SurrogatePasswordlessAuthenticationPreProcessor(servicesManager, surrogatePrincipalBuilder, surrogateAuthenticationService);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogatePasswordlessRequestParser"})
        public PasswordlessRequestParser passwordlessRequestParser(@Qualifier(value="surrogateCredentialParser") SurrogateCredentialParser surrogateCredentialParser) {
            return new SurrogatePasswordlessAuthenticationRequestParser(surrogateCredentialParser);
        }
    }
}

