/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.support;

import com.okta.commons.http.QueryString;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.impl.http.CanonicalUri;
import java.util.Map;

public class DefaultCanonicalUri
implements CanonicalUri {
    private final String absolutePath;
    private final QueryString query;

    public DefaultCanonicalUri(String absolutePath, QueryString query) {
        Assert.hasText((String)absolutePath, (String)"absolutePath argument cannot be null or empty.");
        this.absolutePath = absolutePath;
        this.query = query;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public boolean hasQuery() {
        return this.query != null;
    }

    @Override
    public QueryString getQuery() {
        return this.query;
    }

    public static CanonicalUri create(String href, Map<String, ?> queryParams) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        QueryString query = null;
        if (!Collections.isEmpty(queryParams)) {
            query = new QueryString(queryParams);
            int questionMarkIndex = href.lastIndexOf(63);
            if (questionMarkIndex >= 0) {
                QueryString queryStringFromHref;
                String queryString = href.substring(questionMarkIndex + 1);
                href = href.substring(0, questionMarkIndex);
                if (Strings.hasLength((String)queryString) && (queryStringFromHref = QueryString.create((String)queryString)) != null) {
                    query.putAll((Map)queryStringFromHref);
                }
            }
        }
        return new DefaultCanonicalUri(href, query);
    }
}

