/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging;

import lombok.Generated;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apereo.cas.util.spring.ApplicationContextProvider;

public final class LoggingUtils {
    public static LogEvent prepareLogEvent(LogEvent logEvent) {
        Log4jLogEvent.Builder newLogEventBuilder = LoggingUtils.getLogEventBuilder(logEvent);
        return newLogEventBuilder.build();
    }

    public static Log4jLogEvent.Builder getLogEventBuilder(LogEvent logEvent) {
        String messageModified = ApplicationContextProvider.getMessageSanitizer().map(sanitizer -> sanitizer.sanitize(logEvent.getMessage().getFormattedMessage())).orElseGet(() -> logEvent.getMessage().getFormattedMessage());
        SimpleMessage message = new SimpleMessage(messageModified);
        SortedArrayStringMap contextData = new SortedArrayStringMap(logEvent.getContextData());
        Log4jLogEvent.Builder newLogEventBuilder = Log4jLogEvent.newBuilder().setLevel(logEvent.getLevel()).setLoggerName(logEvent.getLoggerName()).setLoggerFqcn(logEvent.getLoggerFqcn()).setContextData((StringMap)contextData).setContextStack(logEvent.getContextStack()).setEndOfBatch(logEvent.isEndOfBatch()).setIncludeLocation(logEvent.isIncludeLocation()).setMarker(logEvent.getMarker()).setMessage((Message)message).setNanoTime(logEvent.getNanoTime()).setThreadName(logEvent.getThreadName()).setThrownProxy(logEvent.getThrownProxy()).setThrown(logEvent.getThrown()).setTimeMillis(logEvent.getTimeMillis());
        try {
            newLogEventBuilder.setSource(logEvent.getSource());
        }
        catch (Exception e) {
            newLogEventBuilder.setSource(null);
        }
        return newLogEventBuilder;
    }

    @Generated
    private LoggingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

